/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesthinclient.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDeviceResponse extends WorkSpacesThinClientResponse implements
        ToCopyableBuilder<UpdateDeviceResponse.Builder, UpdateDeviceResponse> {
    private static final SdkField<DeviceSummary> DEVICE_FIELD = SdkField.<DeviceSummary> builder(MarshallingType.SDK_POJO)
            .memberName("device").getter(getter(UpdateDeviceResponse::device)).setter(setter(Builder::device))
            .constructor(DeviceSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("device").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DeviceSummary device;

    private UpdateDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.device = builder.device;
    }

    /**
     * <p>
     * Describes a device.
     * </p>
     * 
     * @return Describes a device.
     */
    public final DeviceSummary device() {
        return device;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(device());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDeviceResponse)) {
            return false;
        }
        UpdateDeviceResponse other = (UpdateDeviceResponse) obj;
        return Objects.equals(device(), other.device());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDeviceResponse").add("Device", device()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "device":
            return Optional.ofNullable(clazz.cast(device()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("device", DEVICE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDeviceResponse, T> g) {
        return obj -> g.apply((UpdateDeviceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesThinClientResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDeviceResponse> {
        /**
         * <p>
         * Describes a device.
         * </p>
         * 
         * @param device
         *        Describes a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(DeviceSummary device);

        /**
         * <p>
         * Describes a device.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeviceSummary.Builder} avoiding the need
         * to create one manually via {@link DeviceSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeviceSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #device(DeviceSummary)}.
         * 
         * @param device
         *        a consumer that will call methods on {@link DeviceSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #device(DeviceSummary)
         */
        default Builder device(Consumer<DeviceSummary.Builder> device) {
            return device(DeviceSummary.builder().applyMutation(device).build());
        }
    }

    static final class BuilderImpl extends WorkSpacesThinClientResponse.BuilderImpl implements Builder {
        private DeviceSummary device;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDeviceResponse model) {
            super(model);
            device(model.device);
        }

        public final DeviceSummary.Builder getDevice() {
            return device != null ? device.toBuilder() : null;
        }

        public final void setDevice(DeviceSummary.BuilderImpl device) {
            this.device = device != null ? device.build() : null;
        }

        @Override
        public final Builder device(DeviceSummary device) {
            this.device = device;
            return this;
        }

        @Override
        public UpdateDeviceResponse build() {
            return new UpdateDeviceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
