/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesthinclient.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspacesthinclient.model.ApplyTimeOf;
import software.amazon.awssdk.services.workspacesthinclient.model.DayOfWeek;
import software.amazon.awssdk.services.workspacesthinclient.model.DayOfWeekListCopier;
import software.amazon.awssdk.services.workspacesthinclient.model.MaintenanceWindowType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MaintenanceWindow
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MaintenanceWindow> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(MaintenanceWindow.getter(MaintenanceWindow::typeAsString)).setter(MaintenanceWindow.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Integer> START_TIME_HOUR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("startTimeHour").getter(MaintenanceWindow.getter(MaintenanceWindow::startTimeHour)).setter(MaintenanceWindow.setter(Builder::startTimeHour)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimeHour").build()}).build();
    private static final SdkField<Integer> START_TIME_MINUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("startTimeMinute").getter(MaintenanceWindow.getter(MaintenanceWindow::startTimeMinute)).setter(MaintenanceWindow.setter(Builder::startTimeMinute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimeMinute").build()}).build();
    private static final SdkField<Integer> END_TIME_HOUR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("endTimeHour").getter(MaintenanceWindow.getter(MaintenanceWindow::endTimeHour)).setter(MaintenanceWindow.setter(Builder::endTimeHour)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimeHour").build()}).build();
    private static final SdkField<Integer> END_TIME_MINUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("endTimeMinute").getter(MaintenanceWindow.getter(MaintenanceWindow::endTimeMinute)).setter(MaintenanceWindow.setter(Builder::endTimeMinute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimeMinute").build()}).build();
    private static final SdkField<List<String>> DAYS_OF_THE_WEEK_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("daysOfTheWeek").getter(MaintenanceWindow.getter(MaintenanceWindow::daysOfTheWeekAsStrings)).setter(MaintenanceWindow.setter(Builder::daysOfTheWeekWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("daysOfTheWeek").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> APPLY_TIME_OF_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applyTimeOf").getter(MaintenanceWindow.getter(MaintenanceWindow::applyTimeOfAsString)).setter(MaintenanceWindow.setter(Builder::applyTimeOf)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applyTimeOf").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, START_TIME_HOUR_FIELD, START_TIME_MINUTE_FIELD, END_TIME_HOUR_FIELD, END_TIME_MINUTE_FIELD, DAYS_OF_THE_WEEK_FIELD, APPLY_TIME_OF_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("type", TYPE_FIELD);
            this.put("startTimeHour", START_TIME_HOUR_FIELD);
            this.put("startTimeMinute", START_TIME_MINUTE_FIELD);
            this.put("endTimeHour", END_TIME_HOUR_FIELD);
            this.put("endTimeMinute", END_TIME_MINUTE_FIELD);
            this.put("daysOfTheWeek", DAYS_OF_THE_WEEK_FIELD);
            this.put("applyTimeOf", APPLY_TIME_OF_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String type;
    private final Integer startTimeHour;
    private final Integer startTimeMinute;
    private final Integer endTimeHour;
    private final Integer endTimeMinute;
    private final List<String> daysOfTheWeek;
    private final String applyTimeOf;

    private MaintenanceWindow(BuilderImpl builder) {
        this.type = builder.type;
        this.startTimeHour = builder.startTimeHour;
        this.startTimeMinute = builder.startTimeMinute;
        this.endTimeHour = builder.endTimeHour;
        this.endTimeMinute = builder.endTimeMinute;
        this.daysOfTheWeek = builder.daysOfTheWeek;
        this.applyTimeOf = builder.applyTimeOf;
    }

    public final MaintenanceWindowType type() {
        return MaintenanceWindowType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Integer startTimeHour() {
        return this.startTimeHour;
    }

    public final Integer startTimeMinute() {
        return this.startTimeMinute;
    }

    public final Integer endTimeHour() {
        return this.endTimeHour;
    }

    public final Integer endTimeMinute() {
        return this.endTimeMinute;
    }

    public final List<DayOfWeek> daysOfTheWeek() {
        return DayOfWeekListCopier.copyStringToEnum(this.daysOfTheWeek);
    }

    public final boolean hasDaysOfTheWeek() {
        return this.daysOfTheWeek != null && !(this.daysOfTheWeek instanceof SdkAutoConstructList);
    }

    public final List<String> daysOfTheWeekAsStrings() {
        return this.daysOfTheWeek;
    }

    public final ApplyTimeOf applyTimeOf() {
        return ApplyTimeOf.fromValue(this.applyTimeOf);
    }

    public final String applyTimeOfAsString() {
        return this.applyTimeOf;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimeHour());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimeMinute());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimeHour());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimeMinute());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDaysOfTheWeek() ? this.daysOfTheWeekAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.applyTimeOfAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindow)) {
            return false;
        }
        MaintenanceWindow other = (MaintenanceWindow)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.startTimeHour(), other.startTimeHour()) && Objects.equals(this.startTimeMinute(), other.startTimeMinute()) && Objects.equals(this.endTimeHour(), other.endTimeHour()) && Objects.equals(this.endTimeMinute(), other.endTimeMinute()) && this.hasDaysOfTheWeek() == other.hasDaysOfTheWeek() && Objects.equals(this.daysOfTheWeekAsStrings(), other.daysOfTheWeekAsStrings()) && Objects.equals(this.applyTimeOfAsString(), other.applyTimeOfAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MaintenanceWindow").add("Type", (Object)this.typeAsString()).add("StartTimeHour", (Object)this.startTimeHour()).add("StartTimeMinute", (Object)this.startTimeMinute()).add("EndTimeHour", (Object)this.endTimeHour()).add("EndTimeMinute", (Object)this.endTimeMinute()).add("DaysOfTheWeek", this.hasDaysOfTheWeek() ? this.daysOfTheWeekAsStrings() : null).add("ApplyTimeOf", (Object)this.applyTimeOfAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "startTimeHour": {
                return Optional.ofNullable(clazz.cast(this.startTimeHour()));
            }
            case "startTimeMinute": {
                return Optional.ofNullable(clazz.cast(this.startTimeMinute()));
            }
            case "endTimeHour": {
                return Optional.ofNullable(clazz.cast(this.endTimeHour()));
            }
            case "endTimeMinute": {
                return Optional.ofNullable(clazz.cast(this.endTimeMinute()));
            }
            case "daysOfTheWeek": {
                return Optional.ofNullable(clazz.cast(this.daysOfTheWeekAsStrings()));
            }
            case "applyTimeOf": {
                return Optional.ofNullable(clazz.cast(this.applyTimeOfAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceWindow, T> g) {
        return obj -> g.apply((MaintenanceWindow)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Integer startTimeHour;
        private Integer startTimeMinute;
        private Integer endTimeHour;
        private Integer endTimeMinute;
        private List<String> daysOfTheWeek = DefaultSdkAutoConstructList.getInstance();
        private String applyTimeOf;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindow model) {
            this.type(model.type);
            this.startTimeHour(model.startTimeHour);
            this.startTimeMinute(model.startTimeMinute);
            this.endTimeHour(model.endTimeHour);
            this.endTimeMinute(model.endTimeMinute);
            this.daysOfTheWeekWithStrings(model.daysOfTheWeek);
            this.applyTimeOf(model.applyTimeOf);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MaintenanceWindowType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getStartTimeHour() {
            return this.startTimeHour;
        }

        public final void setStartTimeHour(Integer startTimeHour) {
            this.startTimeHour = startTimeHour;
        }

        @Override
        public final Builder startTimeHour(Integer startTimeHour) {
            this.startTimeHour = startTimeHour;
            return this;
        }

        public final Integer getStartTimeMinute() {
            return this.startTimeMinute;
        }

        public final void setStartTimeMinute(Integer startTimeMinute) {
            this.startTimeMinute = startTimeMinute;
        }

        @Override
        public final Builder startTimeMinute(Integer startTimeMinute) {
            this.startTimeMinute = startTimeMinute;
            return this;
        }

        public final Integer getEndTimeHour() {
            return this.endTimeHour;
        }

        public final void setEndTimeHour(Integer endTimeHour) {
            this.endTimeHour = endTimeHour;
        }

        @Override
        public final Builder endTimeHour(Integer endTimeHour) {
            this.endTimeHour = endTimeHour;
            return this;
        }

        public final Integer getEndTimeMinute() {
            return this.endTimeMinute;
        }

        public final void setEndTimeMinute(Integer endTimeMinute) {
            this.endTimeMinute = endTimeMinute;
        }

        @Override
        public final Builder endTimeMinute(Integer endTimeMinute) {
            this.endTimeMinute = endTimeMinute;
            return this;
        }

        public final Collection<String> getDaysOfTheWeek() {
            if (this.daysOfTheWeek instanceof SdkAutoConstructList) {
                return null;
            }
            return this.daysOfTheWeek;
        }

        public final void setDaysOfTheWeek(Collection<String> daysOfTheWeek) {
            this.daysOfTheWeek = DayOfWeekListCopier.copy(daysOfTheWeek);
        }

        @Override
        public final Builder daysOfTheWeekWithStrings(Collection<String> daysOfTheWeek) {
            this.daysOfTheWeek = DayOfWeekListCopier.copy(daysOfTheWeek);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder daysOfTheWeekWithStrings(String ... daysOfTheWeek) {
            this.daysOfTheWeekWithStrings(Arrays.asList(daysOfTheWeek));
            return this;
        }

        @Override
        public final Builder daysOfTheWeek(Collection<DayOfWeek> daysOfTheWeek) {
            this.daysOfTheWeek = DayOfWeekListCopier.copyEnumToString(daysOfTheWeek);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder daysOfTheWeek(DayOfWeek ... daysOfTheWeek) {
            this.daysOfTheWeek(Arrays.asList(daysOfTheWeek));
            return this;
        }

        public final String getApplyTimeOf() {
            return this.applyTimeOf;
        }

        public final void setApplyTimeOf(String applyTimeOf) {
            this.applyTimeOf = applyTimeOf;
        }

        @Override
        public final Builder applyTimeOf(String applyTimeOf) {
            this.applyTimeOf = applyTimeOf;
            return this;
        }

        @Override
        public final Builder applyTimeOf(ApplyTimeOf applyTimeOf) {
            this.applyTimeOf(applyTimeOf == null ? null : applyTimeOf.toString());
            return this;
        }

        public MaintenanceWindow build() {
            return new MaintenanceWindow(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MaintenanceWindow> {
        public Builder type(String var1);

        public Builder type(MaintenanceWindowType var1);

        public Builder startTimeHour(Integer var1);

        public Builder startTimeMinute(Integer var1);

        public Builder endTimeHour(Integer var1);

        public Builder endTimeMinute(Integer var1);

        public Builder daysOfTheWeekWithStrings(Collection<String> var1);

        public Builder daysOfTheWeekWithStrings(String ... var1);

        public Builder daysOfTheWeek(Collection<DayOfWeek> var1);

        public Builder daysOfTheWeek(DayOfWeek ... var1);

        public Builder applyTimeOf(String var1);

        public Builder applyTimeOf(ApplyTimeOf var1);
    }
}

