/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesthinclient.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspacesthinclient.WorkSpacesThinClientAsyncClient;
import software.amazon.awssdk.services.workspacesthinclient.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspacesthinclient.model.ListSoftwareSetsRequest;
import software.amazon.awssdk.services.workspacesthinclient.model.ListSoftwareSetsResponse;
import software.amazon.awssdk.services.workspacesthinclient.model.SoftwareSetSummary;

public class ListSoftwareSetsPublisher
implements SdkPublisher<ListSoftwareSetsResponse> {
    private final WorkSpacesThinClientAsyncClient client;
    private final ListSoftwareSetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSoftwareSetsPublisher(WorkSpacesThinClientAsyncClient client, ListSoftwareSetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSoftwareSetsPublisher(WorkSpacesThinClientAsyncClient client, ListSoftwareSetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSoftwareSetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSoftwareSetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SoftwareSetSummary> softwareSets() {
        Function<ListSoftwareSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.softwareSets() != null) {
                return response.softwareSets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSoftwareSetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSoftwareSetsResponseFetcher
    implements AsyncPageFetcher<ListSoftwareSetsResponse> {
        private ListSoftwareSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListSoftwareSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSoftwareSetsResponse> nextPage(ListSoftwareSetsResponse previousPage) {
            if (previousPage == null) {
                return ListSoftwareSetsPublisher.this.client.listSoftwareSets(ListSoftwareSetsPublisher.this.firstRequest);
            }
            return ListSoftwareSetsPublisher.this.client.listSoftwareSets((ListSoftwareSetsRequest)((Object)ListSoftwareSetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

