/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesinstances.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines network interface configuration for WorkSpace Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceNetworkInterfaceSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceNetworkInterfaceSpecification.Builder, InstanceNetworkInterfaceSpecification> {
    private static final SdkField<Boolean> ASSOCIATE_CARRIER_IP_ADDRESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("AssociateCarrierIpAddress")
            .getter(getter(InstanceNetworkInterfaceSpecification::associateCarrierIpAddress))
            .setter(setter(Builder::associateCarrierIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociateCarrierIpAddress").build())
            .build();

    private static final SdkField<Boolean> ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("AssociatePublicIpAddress")
            .getter(getter(InstanceNetworkInterfaceSpecification::associatePublicIpAddress))
            .setter(setter(Builder::associatePublicIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatePublicIpAddress").build())
            .build();

    private static final SdkField<ConnectionTrackingSpecificationRequest> CONNECTION_TRACKING_SPECIFICATION_FIELD = SdkField
            .<ConnectionTrackingSpecificationRequest> builder(MarshallingType.SDK_POJO)
            .memberName("ConnectionTrackingSpecification")
            .getter(getter(InstanceNetworkInterfaceSpecification::connectionTrackingSpecification))
            .setter(setter(Builder::connectionTrackingSpecification))
            .constructor(ConnectionTrackingSpecificationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionTrackingSpecification")
                    .build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(InstanceNetworkInterfaceSpecification::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> DEVICE_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DeviceIndex").getter(getter(InstanceNetworkInterfaceSpecification::deviceIndex))
            .setter(setter(Builder::deviceIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceIndex").build()).build();

    private static final SdkField<EnaSrdSpecificationRequest> ENA_SRD_SPECIFICATION_FIELD = SdkField
            .<EnaSrdSpecificationRequest> builder(MarshallingType.SDK_POJO).memberName("EnaSrdSpecification")
            .getter(getter(InstanceNetworkInterfaceSpecification::enaSrdSpecification))
            .setter(setter(Builder::enaSrdSpecification)).constructor(EnaSrdSpecificationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSrdSpecification").build())
            .build();

    private static final SdkField<String> INTERFACE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InterfaceType").getter(getter(InstanceNetworkInterfaceSpecification::interfaceTypeAsString))
            .setter(setter(Builder::interfaceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterfaceType").build()).build();

    private static final SdkField<List<Ipv4PrefixSpecificationRequest>> IPV4_PREFIXES_FIELD = SdkField
            .<List<Ipv4PrefixSpecificationRequest>> builder(MarshallingType.LIST)
            .memberName("Ipv4Prefixes")
            .getter(getter(InstanceNetworkInterfaceSpecification::ipv4Prefixes))
            .setter(setter(Builder::ipv4Prefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4Prefixes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Ipv4PrefixSpecificationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(Ipv4PrefixSpecificationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> IPV4_PREFIX_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Ipv4PrefixCount").getter(getter(InstanceNetworkInterfaceSpecification::ipv4PrefixCount))
            .setter(setter(Builder::ipv4PrefixCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4PrefixCount").build()).build();

    private static final SdkField<Integer> IPV6_ADDRESS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Ipv6AddressCount").getter(getter(InstanceNetworkInterfaceSpecification::ipv6AddressCount))
            .setter(setter(Builder::ipv6AddressCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressCount").build()).build();

    private static final SdkField<List<InstanceIpv6Address>> IPV6_ADDRESSES_FIELD = SdkField
            .<List<InstanceIpv6Address>> builder(MarshallingType.LIST)
            .memberName("Ipv6Addresses")
            .getter(getter(InstanceNetworkInterfaceSpecification::ipv6Addresses))
            .setter(setter(Builder::ipv6Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceIpv6Address> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceIpv6Address::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Ipv6PrefixSpecificationRequest>> IPV6_PREFIXES_FIELD = SdkField
            .<List<Ipv6PrefixSpecificationRequest>> builder(MarshallingType.LIST)
            .memberName("Ipv6Prefixes")
            .getter(getter(InstanceNetworkInterfaceSpecification::ipv6Prefixes))
            .setter(setter(Builder::ipv6Prefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Prefixes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Ipv6PrefixSpecificationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(Ipv6PrefixSpecificationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> IPV6_PREFIX_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Ipv6PrefixCount").getter(getter(InstanceNetworkInterfaceSpecification::ipv6PrefixCount))
            .setter(setter(Builder::ipv6PrefixCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6PrefixCount").build()).build();

    private static final SdkField<Integer> NETWORK_CARD_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NetworkCardIndex").getter(getter(InstanceNetworkInterfaceSpecification::networkCardIndex))
            .setter(setter(Builder::networkCardIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkCardIndex").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId").getter(getter(InstanceNetworkInterfaceSpecification::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").build())
            .build();

    private static final SdkField<Boolean> PRIMARY_IPV6_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PrimaryIpv6").getter(getter(InstanceNetworkInterfaceSpecification::primaryIpv6))
            .setter(setter(Builder::primaryIpv6))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryIpv6").build()).build();

    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrivateIpAddress").getter(getter(InstanceNetworkInterfaceSpecification::privateIpAddress))
            .setter(setter(Builder::privateIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress").build()).build();

    private static final SdkField<List<PrivateIpAddressSpecification>> PRIVATE_IP_ADDRESSES_FIELD = SdkField
            .<List<PrivateIpAddressSpecification>> builder(MarshallingType.LIST)
            .memberName("PrivateIpAddresses")
            .getter(getter(InstanceNetworkInterfaceSpecification::privateIpAddresses))
            .setter(setter(Builder::privateIpAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PrivateIpAddressSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrivateIpAddressSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SecondaryPrivateIpAddressCount")
            .getter(getter(InstanceNetworkInterfaceSpecification::secondaryPrivateIpAddressCount))
            .setter(setter(Builder::secondaryPrivateIpAddressCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryPrivateIpAddressCount")
                    .build()).build();

    private static final SdkField<List<String>> GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(InstanceNetworkInterfaceSpecification::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(InstanceNetworkInterfaceSpecification::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ASSOCIATE_CARRIER_IP_ADDRESS_FIELD, ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD, CONNECTION_TRACKING_SPECIFICATION_FIELD,
            DESCRIPTION_FIELD, DEVICE_INDEX_FIELD, ENA_SRD_SPECIFICATION_FIELD, INTERFACE_TYPE_FIELD, IPV4_PREFIXES_FIELD,
            IPV4_PREFIX_COUNT_FIELD, IPV6_ADDRESS_COUNT_FIELD, IPV6_ADDRESSES_FIELD, IPV6_PREFIXES_FIELD,
            IPV6_PREFIX_COUNT_FIELD, NETWORK_CARD_INDEX_FIELD, NETWORK_INTERFACE_ID_FIELD, PRIMARY_IPV6_FIELD,
            PRIVATE_IP_ADDRESS_FIELD, PRIVATE_IP_ADDRESSES_FIELD, SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD, GROUPS_FIELD,
            SUBNET_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean associateCarrierIpAddress;

    private final Boolean associatePublicIpAddress;

    private final ConnectionTrackingSpecificationRequest connectionTrackingSpecification;

    private final String description;

    private final Integer deviceIndex;

    private final EnaSrdSpecificationRequest enaSrdSpecification;

    private final String interfaceType;

    private final List<Ipv4PrefixSpecificationRequest> ipv4Prefixes;

    private final Integer ipv4PrefixCount;

    private final Integer ipv6AddressCount;

    private final List<InstanceIpv6Address> ipv6Addresses;

    private final List<Ipv6PrefixSpecificationRequest> ipv6Prefixes;

    private final Integer ipv6PrefixCount;

    private final Integer networkCardIndex;

    private final String networkInterfaceId;

    private final Boolean primaryIpv6;

    private final String privateIpAddress;

    private final List<PrivateIpAddressSpecification> privateIpAddresses;

    private final Integer secondaryPrivateIpAddressCount;

    private final List<String> groups;

    private final String subnetId;

    private InstanceNetworkInterfaceSpecification(BuilderImpl builder) {
        this.associateCarrierIpAddress = builder.associateCarrierIpAddress;
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.connectionTrackingSpecification = builder.connectionTrackingSpecification;
        this.description = builder.description;
        this.deviceIndex = builder.deviceIndex;
        this.enaSrdSpecification = builder.enaSrdSpecification;
        this.interfaceType = builder.interfaceType;
        this.ipv4Prefixes = builder.ipv4Prefixes;
        this.ipv4PrefixCount = builder.ipv4PrefixCount;
        this.ipv6AddressCount = builder.ipv6AddressCount;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.ipv6Prefixes = builder.ipv6Prefixes;
        this.ipv6PrefixCount = builder.ipv6PrefixCount;
        this.networkCardIndex = builder.networkCardIndex;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.primaryIpv6 = builder.primaryIpv6;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
        this.groups = builder.groups;
        this.subnetId = builder.subnetId;
    }

    /**
     * <p>
     * Enables carrier IP address association.
     * </p>
     * 
     * @return Enables carrier IP address association.
     */
    public final Boolean associateCarrierIpAddress() {
        return associateCarrierIpAddress;
    }

    /**
     * <p>
     * Enables public IP address assignment.
     * </p>
     * 
     * @return Enables public IP address assignment.
     */
    public final Boolean associatePublicIpAddress() {
        return associatePublicIpAddress;
    }

    /**
     * <p>
     * Configures network connection tracking parameters.
     * </p>
     * 
     * @return Configures network connection tracking parameters.
     */
    public final ConnectionTrackingSpecificationRequest connectionTrackingSpecification() {
        return connectionTrackingSpecification;
    }

    /**
     * <p>
     * Descriptive text for the network interface.
     * </p>
     * 
     * @return Descriptive text for the network interface.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Unique index for the network interface.
     * </p>
     * 
     * @return Unique index for the network interface.
     */
    public final Integer deviceIndex() {
        return deviceIndex;
    }

    /**
     * <p>
     * Configures Elastic Network Adapter Scalable Reliable Datagram settings.
     * </p>
     * 
     * @return Configures Elastic Network Adapter Scalable Reliable Datagram settings.
     */
    public final EnaSrdSpecificationRequest enaSrdSpecification() {
        return enaSrdSpecification;
    }

    /**
     * <p>
     * Specifies the type of network interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interfaceType}
     * will return {@link InterfaceTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #interfaceTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of network interface.
     * @see InterfaceTypeEnum
     */
    public final InterfaceTypeEnum interfaceType() {
        return InterfaceTypeEnum.fromValue(interfaceType);
    }

    /**
     * <p>
     * Specifies the type of network interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interfaceType}
     * will return {@link InterfaceTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #interfaceTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of network interface.
     * @see InterfaceTypeEnum
     */
    public final String interfaceTypeAsString() {
        return interfaceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv4Prefixes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpv4Prefixes() {
        return ipv4Prefixes != null && !(ipv4Prefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * IPv4 prefix configurations for the interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv4Prefixes} method.
     * </p>
     * 
     * @return IPv4 prefix configurations for the interface.
     */
    public final List<Ipv4PrefixSpecificationRequest> ipv4Prefixes() {
        return ipv4Prefixes;
    }

    /**
     * <p>
     * Number of IPv4 prefixes to assign.
     * </p>
     * 
     * @return Number of IPv4 prefixes to assign.
     */
    public final Integer ipv4PrefixCount() {
        return ipv4PrefixCount;
    }

    /**
     * <p>
     * Number of IPv6 addresses to assign.
     * </p>
     * 
     * @return Number of IPv6 addresses to assign.
     */
    public final Integer ipv6AddressCount() {
        return ipv6AddressCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv6Addresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpv6Addresses() {
        return ipv6Addresses != null && !(ipv6Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specific IPv6 addresses for the interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv6Addresses} method.
     * </p>
     * 
     * @return Specific IPv6 addresses for the interface.
     */
    public final List<InstanceIpv6Address> ipv6Addresses() {
        return ipv6Addresses;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv6Prefixes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpv6Prefixes() {
        return ipv6Prefixes != null && !(ipv6Prefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * IPv6 prefix configurations for the interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv6Prefixes} method.
     * </p>
     * 
     * @return IPv6 prefix configurations for the interface.
     */
    public final List<Ipv6PrefixSpecificationRequest> ipv6Prefixes() {
        return ipv6Prefixes;
    }

    /**
     * <p>
     * Number of IPv6 prefixes to assign.
     * </p>
     * 
     * @return Number of IPv6 prefixes to assign.
     */
    public final Integer ipv6PrefixCount() {
        return ipv6PrefixCount;
    }

    /**
     * <p>
     * Index of the network card for multiple network interfaces.
     * </p>
     * 
     * @return Index of the network card for multiple network interfaces.
     */
    public final Integer networkCardIndex() {
        return networkCardIndex;
    }

    /**
     * <p>
     * Unique identifier for the network interface.
     * </p>
     * 
     * @return Unique identifier for the network interface.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * Indicates the primary IPv6 configuration.
     * </p>
     * 
     * @return Indicates the primary IPv6 configuration.
     */
    public final Boolean primaryIpv6() {
        return primaryIpv6;
    }

    /**
     * <p>
     * Primary private IP address for the interface.
     * </p>
     * 
     * @return Primary private IP address for the interface.
     */
    public final String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrivateIpAddresses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrivateIpAddresses() {
        return privateIpAddresses != null && !(privateIpAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of private IP addresses for the interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrivateIpAddresses} method.
     * </p>
     * 
     * @return List of private IP addresses for the interface.
     */
    public final List<PrivateIpAddressSpecification> privateIpAddresses() {
        return privateIpAddresses;
    }

    /**
     * <p>
     * Number of additional private IP addresses to assign.
     * </p>
     * 
     * @return Number of additional private IP addresses to assign.
     */
    public final Integer secondaryPrivateIpAddressCount() {
        return secondaryPrivateIpAddressCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Groups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Security groups associated with the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroups} method.
     * </p>
     * 
     * @return Security groups associated with the network interface.
     */
    public final List<String> groups() {
        return groups;
    }

    /**
     * <p>
     * Subnet identifier for the network interface.
     * </p>
     * 
     * @return Subnet identifier for the network interface.
     */
    public final String subnetId() {
        return subnetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associateCarrierIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(associatePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(connectionTrackingSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(deviceIndex());
        hashCode = 31 * hashCode + Objects.hashCode(enaSrdSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(interfaceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv4Prefixes() ? ipv4Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipv4PrefixCount());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6AddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv6Addresses() ? ipv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv6Prefixes() ? ipv6Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipv6PrefixCount());
        hashCode = 31 * hashCode + Objects.hashCode(networkCardIndex());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(primaryIpv6());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrivateIpAddresses() ? privateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(secondaryPrivateIpAddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceNetworkInterfaceSpecification)) {
            return false;
        }
        InstanceNetworkInterfaceSpecification other = (InstanceNetworkInterfaceSpecification) obj;
        return Objects.equals(associateCarrierIpAddress(), other.associateCarrierIpAddress())
                && Objects.equals(associatePublicIpAddress(), other.associatePublicIpAddress())
                && Objects.equals(connectionTrackingSpecification(), other.connectionTrackingSpecification())
                && Objects.equals(description(), other.description()) && Objects.equals(deviceIndex(), other.deviceIndex())
                && Objects.equals(enaSrdSpecification(), other.enaSrdSpecification())
                && Objects.equals(interfaceTypeAsString(), other.interfaceTypeAsString())
                && hasIpv4Prefixes() == other.hasIpv4Prefixes() && Objects.equals(ipv4Prefixes(), other.ipv4Prefixes())
                && Objects.equals(ipv4PrefixCount(), other.ipv4PrefixCount())
                && Objects.equals(ipv6AddressCount(), other.ipv6AddressCount()) && hasIpv6Addresses() == other.hasIpv6Addresses()
                && Objects.equals(ipv6Addresses(), other.ipv6Addresses()) && hasIpv6Prefixes() == other.hasIpv6Prefixes()
                && Objects.equals(ipv6Prefixes(), other.ipv6Prefixes())
                && Objects.equals(ipv6PrefixCount(), other.ipv6PrefixCount())
                && Objects.equals(networkCardIndex(), other.networkCardIndex())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(primaryIpv6(), other.primaryIpv6())
                && Objects.equals(privateIpAddress(), other.privateIpAddress())
                && hasPrivateIpAddresses() == other.hasPrivateIpAddresses()
                && Objects.equals(privateIpAddresses(), other.privateIpAddresses())
                && Objects.equals(secondaryPrivateIpAddressCount(), other.secondaryPrivateIpAddressCount())
                && hasGroups() == other.hasGroups() && Objects.equals(groups(), other.groups())
                && Objects.equals(subnetId(), other.subnetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceNetworkInterfaceSpecification")
                .add("AssociateCarrierIpAddress", associateCarrierIpAddress())
                .add("AssociatePublicIpAddress", associatePublicIpAddress())
                .add("ConnectionTrackingSpecification", connectionTrackingSpecification()).add("Description", description())
                .add("DeviceIndex", deviceIndex()).add("EnaSrdSpecification", enaSrdSpecification())
                .add("InterfaceType", interfaceTypeAsString()).add("Ipv4Prefixes", hasIpv4Prefixes() ? ipv4Prefixes() : null)
                .add("Ipv4PrefixCount", ipv4PrefixCount()).add("Ipv6AddressCount", ipv6AddressCount())
                .add("Ipv6Addresses", hasIpv6Addresses() ? ipv6Addresses() : null)
                .add("Ipv6Prefixes", hasIpv6Prefixes() ? ipv6Prefixes() : null).add("Ipv6PrefixCount", ipv6PrefixCount())
                .add("NetworkCardIndex", networkCardIndex()).add("NetworkInterfaceId", networkInterfaceId())
                .add("PrimaryIpv6", primaryIpv6())
                .add("PrivateIpAddress", privateIpAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PrivateIpAddresses", hasPrivateIpAddresses() ? privateIpAddresses() : null)
                .add("SecondaryPrivateIpAddressCount", secondaryPrivateIpAddressCount())
                .add("Groups", hasGroups() ? groups() : null).add("SubnetId", subnetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociateCarrierIpAddress":
            return Optional.ofNullable(clazz.cast(associateCarrierIpAddress()));
        case "AssociatePublicIpAddress":
            return Optional.ofNullable(clazz.cast(associatePublicIpAddress()));
        case "ConnectionTrackingSpecification":
            return Optional.ofNullable(clazz.cast(connectionTrackingSpecification()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DeviceIndex":
            return Optional.ofNullable(clazz.cast(deviceIndex()));
        case "EnaSrdSpecification":
            return Optional.ofNullable(clazz.cast(enaSrdSpecification()));
        case "InterfaceType":
            return Optional.ofNullable(clazz.cast(interfaceTypeAsString()));
        case "Ipv4Prefixes":
            return Optional.ofNullable(clazz.cast(ipv4Prefixes()));
        case "Ipv4PrefixCount":
            return Optional.ofNullable(clazz.cast(ipv4PrefixCount()));
        case "Ipv6AddressCount":
            return Optional.ofNullable(clazz.cast(ipv6AddressCount()));
        case "Ipv6Addresses":
            return Optional.ofNullable(clazz.cast(ipv6Addresses()));
        case "Ipv6Prefixes":
            return Optional.ofNullable(clazz.cast(ipv6Prefixes()));
        case "Ipv6PrefixCount":
            return Optional.ofNullable(clazz.cast(ipv6PrefixCount()));
        case "NetworkCardIndex":
            return Optional.ofNullable(clazz.cast(networkCardIndex()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "PrimaryIpv6":
            return Optional.ofNullable(clazz.cast(primaryIpv6()));
        case "PrivateIpAddress":
            return Optional.ofNullable(clazz.cast(privateIpAddress()));
        case "PrivateIpAddresses":
            return Optional.ofNullable(clazz.cast(privateIpAddresses()));
        case "SecondaryPrivateIpAddressCount":
            return Optional.ofNullable(clazz.cast(secondaryPrivateIpAddressCount()));
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AssociateCarrierIpAddress", ASSOCIATE_CARRIER_IP_ADDRESS_FIELD);
        map.put("AssociatePublicIpAddress", ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD);
        map.put("ConnectionTrackingSpecification", CONNECTION_TRACKING_SPECIFICATION_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DeviceIndex", DEVICE_INDEX_FIELD);
        map.put("EnaSrdSpecification", ENA_SRD_SPECIFICATION_FIELD);
        map.put("InterfaceType", INTERFACE_TYPE_FIELD);
        map.put("Ipv4Prefixes", IPV4_PREFIXES_FIELD);
        map.put("Ipv4PrefixCount", IPV4_PREFIX_COUNT_FIELD);
        map.put("Ipv6AddressCount", IPV6_ADDRESS_COUNT_FIELD);
        map.put("Ipv6Addresses", IPV6_ADDRESSES_FIELD);
        map.put("Ipv6Prefixes", IPV6_PREFIXES_FIELD);
        map.put("Ipv6PrefixCount", IPV6_PREFIX_COUNT_FIELD);
        map.put("NetworkCardIndex", NETWORK_CARD_INDEX_FIELD);
        map.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
        map.put("PrimaryIpv6", PRIMARY_IPV6_FIELD);
        map.put("PrivateIpAddress", PRIVATE_IP_ADDRESS_FIELD);
        map.put("PrivateIpAddresses", PRIVATE_IP_ADDRESSES_FIELD);
        map.put("SecondaryPrivateIpAddressCount", SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD);
        map.put("Groups", GROUPS_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceNetworkInterfaceSpecification, T> g) {
        return obj -> g.apply((InstanceNetworkInterfaceSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceNetworkInterfaceSpecification> {
        /**
         * <p>
         * Enables carrier IP address association.
         * </p>
         * 
         * @param associateCarrierIpAddress
         *        Enables carrier IP address association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associateCarrierIpAddress(Boolean associateCarrierIpAddress);

        /**
         * <p>
         * Enables public IP address assignment.
         * </p>
         * 
         * @param associatePublicIpAddress
         *        Enables public IP address assignment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatePublicIpAddress(Boolean associatePublicIpAddress);

        /**
         * <p>
         * Configures network connection tracking parameters.
         * </p>
         * 
         * @param connectionTrackingSpecification
         *        Configures network connection tracking parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionTrackingSpecification(ConnectionTrackingSpecificationRequest connectionTrackingSpecification);

        /**
         * <p>
         * Configures network connection tracking parameters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConnectionTrackingSpecificationRequest.Builder} avoiding the need to create one manually via
         * {@link ConnectionTrackingSpecificationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionTrackingSpecificationRequest.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #connectionTrackingSpecification(ConnectionTrackingSpecificationRequest)}.
         * 
         * @param connectionTrackingSpecification
         *        a consumer that will call methods on {@link ConnectionTrackingSpecificationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionTrackingSpecification(ConnectionTrackingSpecificationRequest)
         */
        default Builder connectionTrackingSpecification(
                Consumer<ConnectionTrackingSpecificationRequest.Builder> connectionTrackingSpecification) {
            return connectionTrackingSpecification(ConnectionTrackingSpecificationRequest.builder()
                    .applyMutation(connectionTrackingSpecification).build());
        }

        /**
         * <p>
         * Descriptive text for the network interface.
         * </p>
         * 
         * @param description
         *        Descriptive text for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Unique index for the network interface.
         * </p>
         * 
         * @param deviceIndex
         *        Unique index for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceIndex(Integer deviceIndex);

        /**
         * <p>
         * Configures Elastic Network Adapter Scalable Reliable Datagram settings.
         * </p>
         * 
         * @param enaSrdSpecification
         *        Configures Elastic Network Adapter Scalable Reliable Datagram settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enaSrdSpecification(EnaSrdSpecificationRequest enaSrdSpecification);

        /**
         * <p>
         * Configures Elastic Network Adapter Scalable Reliable Datagram settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnaSrdSpecificationRequest.Builder}
         * avoiding the need to create one manually via {@link EnaSrdSpecificationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnaSrdSpecificationRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #enaSrdSpecification(EnaSrdSpecificationRequest)}.
         * 
         * @param enaSrdSpecification
         *        a consumer that will call methods on {@link EnaSrdSpecificationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enaSrdSpecification(EnaSrdSpecificationRequest)
         */
        default Builder enaSrdSpecification(Consumer<EnaSrdSpecificationRequest.Builder> enaSrdSpecification) {
            return enaSrdSpecification(EnaSrdSpecificationRequest.builder().applyMutation(enaSrdSpecification).build());
        }

        /**
         * <p>
         * Specifies the type of network interface.
         * </p>
         * 
         * @param interfaceType
         *        Specifies the type of network interface.
         * @see InterfaceTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InterfaceTypeEnum
         */
        Builder interfaceType(String interfaceType);

        /**
         * <p>
         * Specifies the type of network interface.
         * </p>
         * 
         * @param interfaceType
         *        Specifies the type of network interface.
         * @see InterfaceTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InterfaceTypeEnum
         */
        Builder interfaceType(InterfaceTypeEnum interfaceType);

        /**
         * <p>
         * IPv4 prefix configurations for the interface.
         * </p>
         * 
         * @param ipv4Prefixes
         *        IPv4 prefix configurations for the interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Prefixes(Collection<Ipv4PrefixSpecificationRequest> ipv4Prefixes);

        /**
         * <p>
         * IPv4 prefix configurations for the interface.
         * </p>
         * 
         * @param ipv4Prefixes
         *        IPv4 prefix configurations for the interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Prefixes(Ipv4PrefixSpecificationRequest... ipv4Prefixes);

        /**
         * <p>
         * IPv4 prefix configurations for the interface.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspacesinstances.model.Ipv4PrefixSpecificationRequest.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.workspacesinstances.model.Ipv4PrefixSpecificationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspacesinstances.model.Ipv4PrefixSpecificationRequest.Builder#build()}
         * is called immediately and its result is passed to {@link #ipv4Prefixes(List<Ipv4PrefixSpecificationRequest>)}.
         * 
         * @param ipv4Prefixes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspacesinstances.model.Ipv4PrefixSpecificationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv4Prefixes(java.util.Collection<Ipv4PrefixSpecificationRequest>)
         */
        Builder ipv4Prefixes(Consumer<Ipv4PrefixSpecificationRequest.Builder>... ipv4Prefixes);

        /**
         * <p>
         * Number of IPv4 prefixes to assign.
         * </p>
         * 
         * @param ipv4PrefixCount
         *        Number of IPv4 prefixes to assign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4PrefixCount(Integer ipv4PrefixCount);

        /**
         * <p>
         * Number of IPv6 addresses to assign.
         * </p>
         * 
         * @param ipv6AddressCount
         *        Number of IPv6 addresses to assign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6AddressCount(Integer ipv6AddressCount);

        /**
         * <p>
         * Specific IPv6 addresses for the interface.
         * </p>
         * 
         * @param ipv6Addresses
         *        Specific IPv6 addresses for the interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses);

        /**
         * <p>
         * Specific IPv6 addresses for the interface.
         * </p>
         * 
         * @param ipv6Addresses
         *        Specific IPv6 addresses for the interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(InstanceIpv6Address... ipv6Addresses);

        /**
         * <p>
         * Specific IPv6 addresses for the interface.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspacesinstances.model.InstanceIpv6Address.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.workspacesinstances.model.InstanceIpv6Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspacesinstances.model.InstanceIpv6Address.Builder#build()} is
         * called immediately and its result is passed to {@link #ipv6Addresses(List<InstanceIpv6Address>)}.
         * 
         * @param ipv6Addresses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspacesinstances.model.InstanceIpv6Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6Addresses(java.util.Collection<InstanceIpv6Address>)
         */
        Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder>... ipv6Addresses);

        /**
         * <p>
         * IPv6 prefix configurations for the interface.
         * </p>
         * 
         * @param ipv6Prefixes
         *        IPv6 prefix configurations for the interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Prefixes(Collection<Ipv6PrefixSpecificationRequest> ipv6Prefixes);

        /**
         * <p>
         * IPv6 prefix configurations for the interface.
         * </p>
         * 
         * @param ipv6Prefixes
         *        IPv6 prefix configurations for the interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Prefixes(Ipv6PrefixSpecificationRequest... ipv6Prefixes);

        /**
         * <p>
         * IPv6 prefix configurations for the interface.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspacesinstances.model.Ipv6PrefixSpecificationRequest.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.workspacesinstances.model.Ipv6PrefixSpecificationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspacesinstances.model.Ipv6PrefixSpecificationRequest.Builder#build()}
         * is called immediately and its result is passed to {@link #ipv6Prefixes(List<Ipv6PrefixSpecificationRequest>)}.
         * 
         * @param ipv6Prefixes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspacesinstances.model.Ipv6PrefixSpecificationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6Prefixes(java.util.Collection<Ipv6PrefixSpecificationRequest>)
         */
        Builder ipv6Prefixes(Consumer<Ipv6PrefixSpecificationRequest.Builder>... ipv6Prefixes);

        /**
         * <p>
         * Number of IPv6 prefixes to assign.
         * </p>
         * 
         * @param ipv6PrefixCount
         *        Number of IPv6 prefixes to assign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6PrefixCount(Integer ipv6PrefixCount);

        /**
         * <p>
         * Index of the network card for multiple network interfaces.
         * </p>
         * 
         * @param networkCardIndex
         *        Index of the network card for multiple network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkCardIndex(Integer networkCardIndex);

        /**
         * <p>
         * Unique identifier for the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        Unique identifier for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * Indicates the primary IPv6 configuration.
         * </p>
         * 
         * @param primaryIpv6
         *        Indicates the primary IPv6 configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryIpv6(Boolean primaryIpv6);

        /**
         * <p>
         * Primary private IP address for the interface.
         * </p>
         * 
         * @param privateIpAddress
         *        Primary private IP address for the interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * List of private IP addresses for the interface.
         * </p>
         * 
         * @param privateIpAddresses
         *        List of private IP addresses for the interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(Collection<PrivateIpAddressSpecification> privateIpAddresses);

        /**
         * <p>
         * List of private IP addresses for the interface.
         * </p>
         * 
         * @param privateIpAddresses
         *        List of private IP addresses for the interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(PrivateIpAddressSpecification... privateIpAddresses);

        /**
         * <p>
         * List of private IP addresses for the interface.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspacesinstances.model.PrivateIpAddressSpecification.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.workspacesinstances.model.PrivateIpAddressSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspacesinstances.model.PrivateIpAddressSpecification.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #privateIpAddresses(List<PrivateIpAddressSpecification>)}.
         * 
         * @param privateIpAddresses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspacesinstances.model.PrivateIpAddressSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateIpAddresses(java.util.Collection<PrivateIpAddressSpecification>)
         */
        Builder privateIpAddresses(Consumer<PrivateIpAddressSpecification.Builder>... privateIpAddresses);

        /**
         * <p>
         * Number of additional private IP addresses to assign.
         * </p>
         * 
         * @param secondaryPrivateIpAddressCount
         *        Number of additional private IP addresses to assign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount);

        /**
         * <p>
         * Security groups associated with the network interface.
         * </p>
         * 
         * @param groups
         *        Security groups associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<String> groups);

        /**
         * <p>
         * Security groups associated with the network interface.
         * </p>
         * 
         * @param groups
         *        Security groups associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(String... groups);

        /**
         * <p>
         * Subnet identifier for the network interface.
         * </p>
         * 
         * @param subnetId
         *        Subnet identifier for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);
    }

    static final class BuilderImpl implements Builder {
        private Boolean associateCarrierIpAddress;

        private Boolean associatePublicIpAddress;

        private ConnectionTrackingSpecificationRequest connectionTrackingSpecification;

        private String description;

        private Integer deviceIndex;

        private EnaSrdSpecificationRequest enaSrdSpecification;

        private String interfaceType;

        private List<Ipv4PrefixSpecificationRequest> ipv4Prefixes = DefaultSdkAutoConstructList.getInstance();

        private Integer ipv4PrefixCount;

        private Integer ipv6AddressCount;

        private List<InstanceIpv6Address> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();

        private List<Ipv6PrefixSpecificationRequest> ipv6Prefixes = DefaultSdkAutoConstructList.getInstance();

        private Integer ipv6PrefixCount;

        private Integer networkCardIndex;

        private String networkInterfaceId;

        private Boolean primaryIpv6;

        private String privateIpAddress;

        private List<PrivateIpAddressSpecification> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();

        private Integer secondaryPrivateIpAddressCount;

        private List<String> groups = DefaultSdkAutoConstructList.getInstance();

        private String subnetId;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceNetworkInterfaceSpecification model) {
            associateCarrierIpAddress(model.associateCarrierIpAddress);
            associatePublicIpAddress(model.associatePublicIpAddress);
            connectionTrackingSpecification(model.connectionTrackingSpecification);
            description(model.description);
            deviceIndex(model.deviceIndex);
            enaSrdSpecification(model.enaSrdSpecification);
            interfaceType(model.interfaceType);
            ipv4Prefixes(model.ipv4Prefixes);
            ipv4PrefixCount(model.ipv4PrefixCount);
            ipv6AddressCount(model.ipv6AddressCount);
            ipv6Addresses(model.ipv6Addresses);
            ipv6Prefixes(model.ipv6Prefixes);
            ipv6PrefixCount(model.ipv6PrefixCount);
            networkCardIndex(model.networkCardIndex);
            networkInterfaceId(model.networkInterfaceId);
            primaryIpv6(model.primaryIpv6);
            privateIpAddress(model.privateIpAddress);
            privateIpAddresses(model.privateIpAddresses);
            secondaryPrivateIpAddressCount(model.secondaryPrivateIpAddressCount);
            groups(model.groups);
            subnetId(model.subnetId);
        }

        public final Boolean getAssociateCarrierIpAddress() {
            return associateCarrierIpAddress;
        }

        public final void setAssociateCarrierIpAddress(Boolean associateCarrierIpAddress) {
            this.associateCarrierIpAddress = associateCarrierIpAddress;
        }

        @Override
        public final Builder associateCarrierIpAddress(Boolean associateCarrierIpAddress) {
            this.associateCarrierIpAddress = associateCarrierIpAddress;
            return this;
        }

        public final Boolean getAssociatePublicIpAddress() {
            return associatePublicIpAddress;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final ConnectionTrackingSpecificationRequest.Builder getConnectionTrackingSpecification() {
            return connectionTrackingSpecification != null ? connectionTrackingSpecification.toBuilder() : null;
        }

        public final void setConnectionTrackingSpecification(
                ConnectionTrackingSpecificationRequest.BuilderImpl connectionTrackingSpecification) {
            this.connectionTrackingSpecification = connectionTrackingSpecification != null ? connectionTrackingSpecification
                    .build() : null;
        }

        @Override
        public final Builder connectionTrackingSpecification(
                ConnectionTrackingSpecificationRequest connectionTrackingSpecification) {
            this.connectionTrackingSpecification = connectionTrackingSpecification;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getDeviceIndex() {
            return deviceIndex;
        }

        public final void setDeviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
        }

        @Override
        public final Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        public final EnaSrdSpecificationRequest.Builder getEnaSrdSpecification() {
            return enaSrdSpecification != null ? enaSrdSpecification.toBuilder() : null;
        }

        public final void setEnaSrdSpecification(EnaSrdSpecificationRequest.BuilderImpl enaSrdSpecification) {
            this.enaSrdSpecification = enaSrdSpecification != null ? enaSrdSpecification.build() : null;
        }

        @Override
        public final Builder enaSrdSpecification(EnaSrdSpecificationRequest enaSrdSpecification) {
            this.enaSrdSpecification = enaSrdSpecification;
            return this;
        }

        public final String getInterfaceType() {
            return interfaceType;
        }

        public final void setInterfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
        }

        @Override
        public final Builder interfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
            return this;
        }

        @Override
        public final Builder interfaceType(InterfaceTypeEnum interfaceType) {
            this.interfaceType(interfaceType == null ? null : interfaceType.toString());
            return this;
        }

        public final List<Ipv4PrefixSpecificationRequest.Builder> getIpv4Prefixes() {
            List<Ipv4PrefixSpecificationRequest.Builder> result = Ipv4PrefixesCopier.copyToBuilder(this.ipv4Prefixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv4Prefixes(Collection<Ipv4PrefixSpecificationRequest.BuilderImpl> ipv4Prefixes) {
            this.ipv4Prefixes = Ipv4PrefixesCopier.copyFromBuilder(ipv4Prefixes);
        }

        @Override
        public final Builder ipv4Prefixes(Collection<Ipv4PrefixSpecificationRequest> ipv4Prefixes) {
            this.ipv4Prefixes = Ipv4PrefixesCopier.copy(ipv4Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Prefixes(Ipv4PrefixSpecificationRequest... ipv4Prefixes) {
            ipv4Prefixes(Arrays.asList(ipv4Prefixes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Prefixes(Consumer<Ipv4PrefixSpecificationRequest.Builder>... ipv4Prefixes) {
            ipv4Prefixes(Stream.of(ipv4Prefixes).map(c -> Ipv4PrefixSpecificationRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getIpv4PrefixCount() {
            return ipv4PrefixCount;
        }

        public final void setIpv4PrefixCount(Integer ipv4PrefixCount) {
            this.ipv4PrefixCount = ipv4PrefixCount;
        }

        @Override
        public final Builder ipv4PrefixCount(Integer ipv4PrefixCount) {
            this.ipv4PrefixCount = ipv4PrefixCount;
            return this;
        }

        public final Integer getIpv6AddressCount() {
            return ipv6AddressCount;
        }

        public final void setIpv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
        }

        @Override
        public final Builder ipv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        public final List<InstanceIpv6Address.Builder> getIpv6Addresses() {
            List<InstanceIpv6Address.Builder> result = Ipv6AddressesCopier.copyToBuilder(this.ipv6Addresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6Addresses(Collection<InstanceIpv6Address.BuilderImpl> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressesCopier.copyFromBuilder(ipv6Addresses);
        }

        @Override
        public final Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressesCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(InstanceIpv6Address... ipv6Addresses) {
            ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder>... ipv6Addresses) {
            ipv6Addresses(Stream.of(ipv6Addresses).map(c -> InstanceIpv6Address.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Ipv6PrefixSpecificationRequest.Builder> getIpv6Prefixes() {
            List<Ipv6PrefixSpecificationRequest.Builder> result = Ipv6PrefixesCopier.copyToBuilder(this.ipv6Prefixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6Prefixes(Collection<Ipv6PrefixSpecificationRequest.BuilderImpl> ipv6Prefixes) {
            this.ipv6Prefixes = Ipv6PrefixesCopier.copyFromBuilder(ipv6Prefixes);
        }

        @Override
        public final Builder ipv6Prefixes(Collection<Ipv6PrefixSpecificationRequest> ipv6Prefixes) {
            this.ipv6Prefixes = Ipv6PrefixesCopier.copy(ipv6Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Prefixes(Ipv6PrefixSpecificationRequest... ipv6Prefixes) {
            ipv6Prefixes(Arrays.asList(ipv6Prefixes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Prefixes(Consumer<Ipv6PrefixSpecificationRequest.Builder>... ipv6Prefixes) {
            ipv6Prefixes(Stream.of(ipv6Prefixes).map(c -> Ipv6PrefixSpecificationRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getIpv6PrefixCount() {
            return ipv6PrefixCount;
        }

        public final void setIpv6PrefixCount(Integer ipv6PrefixCount) {
            this.ipv6PrefixCount = ipv6PrefixCount;
        }

        @Override
        public final Builder ipv6PrefixCount(Integer ipv6PrefixCount) {
            this.ipv6PrefixCount = ipv6PrefixCount;
            return this;
        }

        public final Integer getNetworkCardIndex() {
            return networkCardIndex;
        }

        public final void setNetworkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
        }

        @Override
        public final Builder networkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final Boolean getPrimaryIpv6() {
            return primaryIpv6;
        }

        public final void setPrimaryIpv6(Boolean primaryIpv6) {
            this.primaryIpv6 = primaryIpv6;
        }

        @Override
        public final Builder primaryIpv6(Boolean primaryIpv6) {
            this.primaryIpv6 = primaryIpv6;
            return this;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final List<PrivateIpAddressSpecification.Builder> getPrivateIpAddresses() {
            List<PrivateIpAddressSpecification.Builder> result = PrivateIpAddressesCopier.copyToBuilder(this.privateIpAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrivateIpAddresses(Collection<PrivateIpAddressSpecification.BuilderImpl> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressesCopier.copyFromBuilder(privateIpAddresses);
        }

        @Override
        public final Builder privateIpAddresses(Collection<PrivateIpAddressSpecification> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressesCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(PrivateIpAddressSpecification... privateIpAddresses) {
            privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(Consumer<PrivateIpAddressSpecification.Builder>... privateIpAddresses) {
            privateIpAddresses(Stream.of(privateIpAddresses)
                    .map(c -> PrivateIpAddressSpecification.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getSecondaryPrivateIpAddressCount() {
            return secondaryPrivateIpAddressCount;
        }

        public final void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
        }

        @Override
        public final Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        public final Collection<String> getGroups() {
            if (groups instanceof SdkAutoConstructList) {
                return null;
            }
            return groups;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = SecurityGroupIdsCopier.copy(groups);
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = SecurityGroupIdsCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        @Override
        public InstanceNetworkInterfaceSpecification build() {
            return new InstanceNetworkInterfaceSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
