/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesinstances.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures marketplace-specific instance deployment options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceMarketOptionsRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceMarketOptionsRequest.Builder, InstanceMarketOptionsRequest> {
    private static final SdkField<String> MARKET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MarketType").getter(getter(InstanceMarketOptionsRequest::marketTypeAsString))
            .setter(setter(Builder::marketType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MarketType").build()).build();

    private static final SdkField<SpotMarketOptions> SPOT_OPTIONS_FIELD = SdkField
            .<SpotMarketOptions> builder(MarshallingType.SDK_POJO).memberName("SpotOptions")
            .getter(getter(InstanceMarketOptionsRequest::spotOptions)).setter(setter(Builder::spotOptions))
            .constructor(SpotMarketOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKET_TYPE_FIELD,
            SPOT_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String marketType;

    private final SpotMarketOptions spotOptions;

    private InstanceMarketOptionsRequest(BuilderImpl builder) {
        this.marketType = builder.marketType;
        this.spotOptions = builder.spotOptions;
    }

    /**
     * <p>
     * Specifies the type of marketplace for instance deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #marketType} will
     * return {@link MarketTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #marketTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of marketplace for instance deployment.
     * @see MarketTypeEnum
     */
    public final MarketTypeEnum marketType() {
        return MarketTypeEnum.fromValue(marketType);
    }

    /**
     * <p>
     * Specifies the type of marketplace for instance deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #marketType} will
     * return {@link MarketTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #marketTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of marketplace for instance deployment.
     * @see MarketTypeEnum
     */
    public final String marketTypeAsString() {
        return marketType;
    }

    /**
     * <p>
     * Configuration options for spot instance deployment.
     * </p>
     * 
     * @return Configuration options for spot instance deployment.
     */
    public final SpotMarketOptions spotOptions() {
        return spotOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(marketTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(spotOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceMarketOptionsRequest)) {
            return false;
        }
        InstanceMarketOptionsRequest other = (InstanceMarketOptionsRequest) obj;
        return Objects.equals(marketTypeAsString(), other.marketTypeAsString())
                && Objects.equals(spotOptions(), other.spotOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceMarketOptionsRequest").add("MarketType", marketTypeAsString())
                .add("SpotOptions", spotOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MarketType":
            return Optional.ofNullable(clazz.cast(marketTypeAsString()));
        case "SpotOptions":
            return Optional.ofNullable(clazz.cast(spotOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MarketType", MARKET_TYPE_FIELD);
        map.put("SpotOptions", SPOT_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceMarketOptionsRequest, T> g) {
        return obj -> g.apply((InstanceMarketOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceMarketOptionsRequest> {
        /**
         * <p>
         * Specifies the type of marketplace for instance deployment.
         * </p>
         * 
         * @param marketType
         *        Specifies the type of marketplace for instance deployment.
         * @see MarketTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MarketTypeEnum
         */
        Builder marketType(String marketType);

        /**
         * <p>
         * Specifies the type of marketplace for instance deployment.
         * </p>
         * 
         * @param marketType
         *        Specifies the type of marketplace for instance deployment.
         * @see MarketTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MarketTypeEnum
         */
        Builder marketType(MarketTypeEnum marketType);

        /**
         * <p>
         * Configuration options for spot instance deployment.
         * </p>
         * 
         * @param spotOptions
         *        Configuration options for spot instance deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotOptions(SpotMarketOptions spotOptions);

        /**
         * <p>
         * Configuration options for spot instance deployment.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpotMarketOptions.Builder} avoiding the
         * need to create one manually via {@link SpotMarketOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpotMarketOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #spotOptions(SpotMarketOptions)}.
         * 
         * @param spotOptions
         *        a consumer that will call methods on {@link SpotMarketOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spotOptions(SpotMarketOptions)
         */
        default Builder spotOptions(Consumer<SpotMarketOptions.Builder> spotOptions) {
            return spotOptions(SpotMarketOptions.builder().applyMutation(spotOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String marketType;

        private SpotMarketOptions spotOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceMarketOptionsRequest model) {
            marketType(model.marketType);
            spotOptions(model.spotOptions);
        }

        public final String getMarketType() {
            return marketType;
        }

        public final void setMarketType(String marketType) {
            this.marketType = marketType;
        }

        @Override
        public final Builder marketType(String marketType) {
            this.marketType = marketType;
            return this;
        }

        @Override
        public final Builder marketType(MarketTypeEnum marketType) {
            this.marketType(marketType == null ? null : marketType.toString());
            return this;
        }

        public final SpotMarketOptions.Builder getSpotOptions() {
            return spotOptions != null ? spotOptions.toBuilder() : null;
        }

        public final void setSpotOptions(SpotMarketOptions.BuilderImpl spotOptions) {
            this.spotOptions = spotOptions != null ? spotOptions.build() : null;
        }

        @Override
        public final Builder spotOptions(SpotMarketOptions spotOptions) {
            this.spotOptions = spotOptions;
            return this;
        }

        @Override
        public InstanceMarketOptionsRequest build() {
            return new InstanceMarketOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
