/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesinstances.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the configuration parameters for creating a new WorkSpaces Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkspaceInstanceRequest extends WorkspacesInstancesRequest implements
        ToCopyableBuilder<CreateWorkspaceInstanceRequest.Builder, CreateWorkspaceInstanceRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateWorkspaceInstanceRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateWorkspaceInstanceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ManagedInstanceRequest> MANAGED_INSTANCE_FIELD = SdkField
            .<ManagedInstanceRequest> builder(MarshallingType.SDK_POJO).memberName("ManagedInstance")
            .getter(getter(CreateWorkspaceInstanceRequest::managedInstance)).setter(setter(Builder::managedInstance))
            .constructor(ManagedInstanceRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedInstance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            TAGS_FIELD, MANAGED_INSTANCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final List<Tag> tags;

    private final ManagedInstanceRequest managedInstance;

    private CreateWorkspaceInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
        this.managedInstance = builder.managedInstance;
    }

    /**
     * <p>
     * Unique token to ensure idempotent instance creation, preventing duplicate workspace launches.
     * </p>
     * 
     * @return Unique token to ensure idempotent instance creation, preventing duplicate workspace launches.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional metadata tags for categorizing and managing WorkSpaces Instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Optional metadata tags for categorizing and managing WorkSpaces Instances.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Comprehensive configuration settings for the WorkSpaces Instance, including network, compute, and storage
     * parameters.
     * </p>
     * 
     * @return Comprehensive configuration settings for the WorkSpaces Instance, including network, compute, and storage
     *         parameters.
     */
    public final ManagedInstanceRequest managedInstance() {
        return managedInstance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(managedInstance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspaceInstanceRequest)) {
            return false;
        }
        CreateWorkspaceInstanceRequest other = (CreateWorkspaceInstanceRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(managedInstance(), other.managedInstance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkspaceInstanceRequest")
                .add("ClientToken", clientToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Tags", hasTags() ? tags() : null).add("ManagedInstance", managedInstance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ManagedInstance":
            return Optional.ofNullable(clazz.cast(managedInstance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ManagedInstance", MANAGED_INSTANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkspaceInstanceRequest, T> g) {
        return obj -> g.apply((CreateWorkspaceInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkspacesInstancesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateWorkspaceInstanceRequest> {
        /**
         * <p>
         * Unique token to ensure idempotent instance creation, preventing duplicate workspace launches.
         * </p>
         * 
         * @param clientToken
         *        Unique token to ensure idempotent instance creation, preventing duplicate workspace launches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Optional metadata tags for categorizing and managing WorkSpaces Instances.
         * </p>
         * 
         * @param tags
         *        Optional metadata tags for categorizing and managing WorkSpaces Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Optional metadata tags for categorizing and managing WorkSpaces Instances.
         * </p>
         * 
         * @param tags
         *        Optional metadata tags for categorizing and managing WorkSpaces Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Optional metadata tags for categorizing and managing WorkSpaces Instances.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspacesinstances.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.workspacesinstances.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspacesinstances.model.Tag.Builder#build()} is called immediately
         * and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspacesinstances.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Comprehensive configuration settings for the WorkSpaces Instance, including network, compute, and storage
         * parameters.
         * </p>
         * 
         * @param managedInstance
         *        Comprehensive configuration settings for the WorkSpaces Instance, including network, compute, and
         *        storage parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedInstance(ManagedInstanceRequest managedInstance);

        /**
         * <p>
         * Comprehensive configuration settings for the WorkSpaces Instance, including network, compute, and storage
         * parameters.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManagedInstanceRequest.Builder} avoiding
         * the need to create one manually via {@link ManagedInstanceRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedInstanceRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #managedInstance(ManagedInstanceRequest)}.
         * 
         * @param managedInstance
         *        a consumer that will call methods on {@link ManagedInstanceRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedInstance(ManagedInstanceRequest)
         */
        default Builder managedInstance(Consumer<ManagedInstanceRequest.Builder> managedInstance) {
            return managedInstance(ManagedInstanceRequest.builder().applyMutation(managedInstance).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkspacesInstancesRequest.BuilderImpl implements Builder {
        private String clientToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private ManagedInstanceRequest managedInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkspaceInstanceRequest model) {
            super(model);
            clientToken(model.clientToken);
            tags(model.tags);
            managedInstance(model.managedInstance);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ManagedInstanceRequest.Builder getManagedInstance() {
            return managedInstance != null ? managedInstance.toBuilder() : null;
        }

        public final void setManagedInstance(ManagedInstanceRequest.BuilderImpl managedInstance) {
            this.managedInstance = managedInstance != null ? managedInstance.build() : null;
        }

        @Override
        public final Builder managedInstance(ManagedInstanceRequest managedInstance) {
            this.managedInstance = managedInstance;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkspaceInstanceRequest build() {
            return new CreateWorkspaceInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
