/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesinstances.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MarketTypeEnum {
    SPOT("spot"),
    CAPACITY_BLOCK("capacity-block"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MarketTypeEnum> VALUE_MAP;
    private final String value;

    private MarketTypeEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MarketTypeEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MarketTypeEnum> knownValues() {
        EnumSet<MarketTypeEnum> knownValues = EnumSet.allOf(MarketTypeEnum.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MarketTypeEnum.class, MarketTypeEnum::toString);
    }
}

