/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesinstances.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspacesinstances.model.BlockDeviceMappingRequest;
import software.amazon.awssdk.services.workspacesinstances.model.BlockDeviceMappingsCopier;
import software.amazon.awssdk.services.workspacesinstances.model.CapacityReservationSpecification;
import software.amazon.awssdk.services.workspacesinstances.model.CpuOptionsRequest;
import software.amazon.awssdk.services.workspacesinstances.model.CreditSpecificationRequest;
import software.amazon.awssdk.services.workspacesinstances.model.EnclaveOptionsRequest;
import software.amazon.awssdk.services.workspacesinstances.model.HibernationOptionsRequest;
import software.amazon.awssdk.services.workspacesinstances.model.IamInstanceProfileSpecification;
import software.amazon.awssdk.services.workspacesinstances.model.InstanceIpv6Address;
import software.amazon.awssdk.services.workspacesinstances.model.InstanceMaintenanceOptionsRequest;
import software.amazon.awssdk.services.workspacesinstances.model.InstanceMarketOptionsRequest;
import software.amazon.awssdk.services.workspacesinstances.model.InstanceMetadataOptionsRequest;
import software.amazon.awssdk.services.workspacesinstances.model.InstanceNetworkInterfaceSpecification;
import software.amazon.awssdk.services.workspacesinstances.model.InstanceNetworkPerformanceOptionsRequest;
import software.amazon.awssdk.services.workspacesinstances.model.Ipv6AddressesCopier;
import software.amazon.awssdk.services.workspacesinstances.model.LicenseConfigurationRequest;
import software.amazon.awssdk.services.workspacesinstances.model.LicenseSpecificationsCopier;
import software.amazon.awssdk.services.workspacesinstances.model.NetworkInterfacesCopier;
import software.amazon.awssdk.services.workspacesinstances.model.Placement;
import software.amazon.awssdk.services.workspacesinstances.model.PrivateDnsNameOptionsRequest;
import software.amazon.awssdk.services.workspacesinstances.model.RunInstancesMonitoringEnabled;
import software.amazon.awssdk.services.workspacesinstances.model.SecurityGroupIdsCopier;
import software.amazon.awssdk.services.workspacesinstances.model.SecurityGroupNamesCopier;
import software.amazon.awssdk.services.workspacesinstances.model.TagSpecification;
import software.amazon.awssdk.services.workspacesinstances.model.TagSpecificationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedInstanceRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedInstanceRequest> {
    private static final SdkField<List<BlockDeviceMappingRequest>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BlockDeviceMappings").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::blockDeviceMappings)).setter(ManagedInstanceRequest.setter(Builder::blockDeviceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BlockDeviceMappingRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CapacityReservationSpecification> CAPACITY_RESERVATION_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CapacityReservationSpecification").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::capacityReservationSpecification)).setter(ManagedInstanceRequest.setter(Builder::capacityReservationSpecification)).constructor(CapacityReservationSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationSpecification").build()}).build();
    private static final SdkField<CpuOptionsRequest> CPU_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CpuOptions").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::cpuOptions)).setter(ManagedInstanceRequest.setter(Builder::cpuOptions)).constructor(CpuOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpuOptions").build()}).build();
    private static final SdkField<CreditSpecificationRequest> CREDIT_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreditSpecification").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::creditSpecification)).setter(ManagedInstanceRequest.setter(Builder::creditSpecification)).constructor(CreditSpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreditSpecification").build()}).build();
    private static final SdkField<Boolean> DISABLE_API_STOP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DisableApiStop").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::disableApiStop)).setter(ManagedInstanceRequest.setter(Builder::disableApiStop)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableApiStop").build()}).build();
    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EbsOptimized").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::ebsOptimized)).setter(ManagedInstanceRequest.setter(Builder::ebsOptimized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").build()}).build();
    private static final SdkField<Boolean> ENABLE_PRIMARY_IPV6_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnablePrimaryIpv6").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::enablePrimaryIpv6)).setter(ManagedInstanceRequest.setter(Builder::enablePrimaryIpv6)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePrimaryIpv6").build()}).build();
    private static final SdkField<EnclaveOptionsRequest> ENCLAVE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnclaveOptions").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::enclaveOptions)).setter(ManagedInstanceRequest.setter(Builder::enclaveOptions)).constructor(EnclaveOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnclaveOptions").build()}).build();
    private static final SdkField<HibernationOptionsRequest> HIBERNATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HibernationOptions").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::hibernationOptions)).setter(ManagedInstanceRequest.setter(Builder::hibernationOptions)).constructor(HibernationOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HibernationOptions").build()}).build();
    private static final SdkField<IamInstanceProfileSpecification> IAM_INSTANCE_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IamInstanceProfile").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::iamInstanceProfile)).setter(ManagedInstanceRequest.setter(Builder::iamInstanceProfile)).constructor(IamInstanceProfileSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::imageId)).setter(ManagedInstanceRequest.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()}).build();
    private static final SdkField<InstanceMarketOptionsRequest> INSTANCE_MARKET_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceMarketOptions").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::instanceMarketOptions)).setter(ManagedInstanceRequest.setter(Builder::instanceMarketOptions)).constructor(InstanceMarketOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMarketOptions").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::instanceType)).setter(ManagedInstanceRequest.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<List<InstanceIpv6Address>> IPV6_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv6Addresses").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::ipv6Addresses)).setter(ManagedInstanceRequest.setter(Builder::ipv6Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Addresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceIpv6Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> IPV6_ADDRESS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Ipv6AddressCount").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::ipv6AddressCount)).setter(ManagedInstanceRequest.setter(Builder::ipv6AddressCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressCount").build()}).build();
    private static final SdkField<String> KERNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KernelId").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::kernelId)).setter(ManagedInstanceRequest.setter(Builder::kernelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId").build()}).build();
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyName").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::keyName)).setter(ManagedInstanceRequest.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").build()}).build();
    private static final SdkField<List<LicenseConfigurationRequest>> LICENSE_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LicenseSpecifications").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::licenseSpecifications)).setter(ManagedInstanceRequest.setter(Builder::licenseSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseSpecifications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LicenseConfigurationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InstanceMaintenanceOptionsRequest> MAINTENANCE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaintenanceOptions").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::maintenanceOptions)).setter(ManagedInstanceRequest.setter(Builder::maintenanceOptions)).constructor(InstanceMaintenanceOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceOptions").build()}).build();
    private static final SdkField<InstanceMetadataOptionsRequest> METADATA_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetadataOptions").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::metadataOptions)).setter(ManagedInstanceRequest.setter(Builder::metadataOptions)).constructor(InstanceMetadataOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataOptions").build()}).build();
    private static final SdkField<RunInstancesMonitoringEnabled> MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Monitoring").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::monitoring)).setter(ManagedInstanceRequest.setter(Builder::monitoring)).constructor(RunInstancesMonitoringEnabled::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitoring").build()}).build();
    private static final SdkField<List<InstanceNetworkInterfaceSpecification>> NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkInterfaces").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::networkInterfaces)).setter(ManagedInstanceRequest.setter(Builder::networkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceNetworkInterfaceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InstanceNetworkPerformanceOptionsRequest> NETWORK_PERFORMANCE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkPerformanceOptions").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::networkPerformanceOptions)).setter(ManagedInstanceRequest.setter(Builder::networkPerformanceOptions)).constructor(InstanceNetworkPerformanceOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkPerformanceOptions").build()}).build();
    private static final SdkField<Placement> PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Placement").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::placement)).setter(ManagedInstanceRequest.setter(Builder::placement)).constructor(Placement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement").build()}).build();
    private static final SdkField<PrivateDnsNameOptionsRequest> PRIVATE_DNS_NAME_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrivateDnsNameOptions").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::privateDnsNameOptions)).setter(ManagedInstanceRequest.setter(Builder::privateDnsNameOptions)).constructor(PrivateDnsNameOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsNameOptions").build()}).build();
    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateIpAddress").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::privateIpAddress)).setter(ManagedInstanceRequest.setter(Builder::privateIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress").build()}).build();
    private static final SdkField<String> RAMDISK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RamdiskId").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::ramdiskId)).setter(ManagedInstanceRequest.setter(Builder::ramdiskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamdiskId").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::securityGroupIds)).setter(ManagedInstanceRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::securityGroups)).setter(ManagedInstanceRequest.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::subnetId)).setter(ManagedInstanceRequest.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::tagSpecifications)).setter(ManagedInstanceRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecifications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> USER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserData").getter(ManagedInstanceRequest.getter(ManagedInstanceRequest::userData)).setter(ManagedInstanceRequest.setter(Builder::userData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_DEVICE_MAPPINGS_FIELD, CAPACITY_RESERVATION_SPECIFICATION_FIELD, CPU_OPTIONS_FIELD, CREDIT_SPECIFICATION_FIELD, DISABLE_API_STOP_FIELD, EBS_OPTIMIZED_FIELD, ENABLE_PRIMARY_IPV6_FIELD, ENCLAVE_OPTIONS_FIELD, HIBERNATION_OPTIONS_FIELD, IAM_INSTANCE_PROFILE_FIELD, IMAGE_ID_FIELD, INSTANCE_MARKET_OPTIONS_FIELD, INSTANCE_TYPE_FIELD, IPV6_ADDRESSES_FIELD, IPV6_ADDRESS_COUNT_FIELD, KERNEL_ID_FIELD, KEY_NAME_FIELD, LICENSE_SPECIFICATIONS_FIELD, MAINTENANCE_OPTIONS_FIELD, METADATA_OPTIONS_FIELD, MONITORING_FIELD, NETWORK_INTERFACES_FIELD, NETWORK_PERFORMANCE_OPTIONS_FIELD, PLACEMENT_FIELD, PRIVATE_DNS_NAME_OPTIONS_FIELD, PRIVATE_IP_ADDRESS_FIELD, RAMDISK_ID_FIELD, SECURITY_GROUP_IDS_FIELD, SECURITY_GROUPS_FIELD, SUBNET_ID_FIELD, TAG_SPECIFICATIONS_FIELD, USER_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ManagedInstanceRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<BlockDeviceMappingRequest> blockDeviceMappings;
    private final CapacityReservationSpecification capacityReservationSpecification;
    private final CpuOptionsRequest cpuOptions;
    private final CreditSpecificationRequest creditSpecification;
    private final Boolean disableApiStop;
    private final Boolean ebsOptimized;
    private final Boolean enablePrimaryIpv6;
    private final EnclaveOptionsRequest enclaveOptions;
    private final HibernationOptionsRequest hibernationOptions;
    private final IamInstanceProfileSpecification iamInstanceProfile;
    private final String imageId;
    private final InstanceMarketOptionsRequest instanceMarketOptions;
    private final String instanceType;
    private final List<InstanceIpv6Address> ipv6Addresses;
    private final Integer ipv6AddressCount;
    private final String kernelId;
    private final String keyName;
    private final List<LicenseConfigurationRequest> licenseSpecifications;
    private final InstanceMaintenanceOptionsRequest maintenanceOptions;
    private final InstanceMetadataOptionsRequest metadataOptions;
    private final RunInstancesMonitoringEnabled monitoring;
    private final List<InstanceNetworkInterfaceSpecification> networkInterfaces;
    private final InstanceNetworkPerformanceOptionsRequest networkPerformanceOptions;
    private final Placement placement;
    private final PrivateDnsNameOptionsRequest privateDnsNameOptions;
    private final String privateIpAddress;
    private final String ramdiskId;
    private final List<String> securityGroupIds;
    private final List<String> securityGroups;
    private final String subnetId;
    private final List<TagSpecification> tagSpecifications;
    private final String userData;

    private ManagedInstanceRequest(BuilderImpl builder) {
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.capacityReservationSpecification = builder.capacityReservationSpecification;
        this.cpuOptions = builder.cpuOptions;
        this.creditSpecification = builder.creditSpecification;
        this.disableApiStop = builder.disableApiStop;
        this.ebsOptimized = builder.ebsOptimized;
        this.enablePrimaryIpv6 = builder.enablePrimaryIpv6;
        this.enclaveOptions = builder.enclaveOptions;
        this.hibernationOptions = builder.hibernationOptions;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.imageId = builder.imageId;
        this.instanceMarketOptions = builder.instanceMarketOptions;
        this.instanceType = builder.instanceType;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.ipv6AddressCount = builder.ipv6AddressCount;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.licenseSpecifications = builder.licenseSpecifications;
        this.maintenanceOptions = builder.maintenanceOptions;
        this.metadataOptions = builder.metadataOptions;
        this.monitoring = builder.monitoring;
        this.networkInterfaces = builder.networkInterfaces;
        this.networkPerformanceOptions = builder.networkPerformanceOptions;
        this.placement = builder.placement;
        this.privateDnsNameOptions = builder.privateDnsNameOptions;
        this.privateIpAddress = builder.privateIpAddress;
        this.ramdiskId = builder.ramdiskId;
        this.securityGroupIds = builder.securityGroupIds;
        this.securityGroups = builder.securityGroups;
        this.subnetId = builder.subnetId;
        this.tagSpecifications = builder.tagSpecifications;
        this.userData = builder.userData;
    }

    public final boolean hasBlockDeviceMappings() {
        return this.blockDeviceMappings != null && !(this.blockDeviceMappings instanceof SdkAutoConstructList);
    }

    public final List<BlockDeviceMappingRequest> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public final CapacityReservationSpecification capacityReservationSpecification() {
        return this.capacityReservationSpecification;
    }

    public final CpuOptionsRequest cpuOptions() {
        return this.cpuOptions;
    }

    public final CreditSpecificationRequest creditSpecification() {
        return this.creditSpecification;
    }

    public final Boolean disableApiStop() {
        return this.disableApiStop;
    }

    public final Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public final Boolean enablePrimaryIpv6() {
        return this.enablePrimaryIpv6;
    }

    public final EnclaveOptionsRequest enclaveOptions() {
        return this.enclaveOptions;
    }

    public final HibernationOptionsRequest hibernationOptions() {
        return this.hibernationOptions;
    }

    public final IamInstanceProfileSpecification iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final InstanceMarketOptionsRequest instanceMarketOptions() {
        return this.instanceMarketOptions;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final boolean hasIpv6Addresses() {
        return this.ipv6Addresses != null && !(this.ipv6Addresses instanceof SdkAutoConstructList);
    }

    public final List<InstanceIpv6Address> ipv6Addresses() {
        return this.ipv6Addresses;
    }

    public final Integer ipv6AddressCount() {
        return this.ipv6AddressCount;
    }

    public final String kernelId() {
        return this.kernelId;
    }

    public final String keyName() {
        return this.keyName;
    }

    public final boolean hasLicenseSpecifications() {
        return this.licenseSpecifications != null && !(this.licenseSpecifications instanceof SdkAutoConstructList);
    }

    public final List<LicenseConfigurationRequest> licenseSpecifications() {
        return this.licenseSpecifications;
    }

    public final InstanceMaintenanceOptionsRequest maintenanceOptions() {
        return this.maintenanceOptions;
    }

    public final InstanceMetadataOptionsRequest metadataOptions() {
        return this.metadataOptions;
    }

    public final RunInstancesMonitoringEnabled monitoring() {
        return this.monitoring;
    }

    public final boolean hasNetworkInterfaces() {
        return this.networkInterfaces != null && !(this.networkInterfaces instanceof SdkAutoConstructList);
    }

    public final List<InstanceNetworkInterfaceSpecification> networkInterfaces() {
        return this.networkInterfaces;
    }

    public final InstanceNetworkPerformanceOptionsRequest networkPerformanceOptions() {
        return this.networkPerformanceOptions;
    }

    public final Placement placement() {
        return this.placement;
    }

    public final PrivateDnsNameOptionsRequest privateDnsNameOptions() {
        return this.privateDnsNameOptions;
    }

    public final String privateIpAddress() {
        return this.privateIpAddress;
    }

    public final String ramdiskId() {
        return this.ramdiskId;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroups() {
        return this.securityGroups;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final String userData() {
        return this.userData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.creditSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableApiStop());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePrimaryIpv6());
        hashCode = 31 * hashCode + Objects.hashCode(this.enclaveOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hibernationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMarketOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv6Addresses() ? this.ipv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6AddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenseSpecifications() ? this.licenseSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoring());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInterfaces() ? this.networkInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.networkPerformanceOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.placement());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsNameOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedInstanceRequest)) {
            return false;
        }
        ManagedInstanceRequest other = (ManagedInstanceRequest)obj;
        return this.hasBlockDeviceMappings() == other.hasBlockDeviceMappings() && Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(this.capacityReservationSpecification(), other.capacityReservationSpecification()) && Objects.equals(this.cpuOptions(), other.cpuOptions()) && Objects.equals(this.creditSpecification(), other.creditSpecification()) && Objects.equals(this.disableApiStop(), other.disableApiStop()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized()) && Objects.equals(this.enablePrimaryIpv6(), other.enablePrimaryIpv6()) && Objects.equals(this.enclaveOptions(), other.enclaveOptions()) && Objects.equals(this.hibernationOptions(), other.hibernationOptions()) && Objects.equals(this.iamInstanceProfile(), other.iamInstanceProfile()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.instanceMarketOptions(), other.instanceMarketOptions()) && Objects.equals(this.instanceType(), other.instanceType()) && this.hasIpv6Addresses() == other.hasIpv6Addresses() && Objects.equals(this.ipv6Addresses(), other.ipv6Addresses()) && Objects.equals(this.ipv6AddressCount(), other.ipv6AddressCount()) && Objects.equals(this.kernelId(), other.kernelId()) && Objects.equals(this.keyName(), other.keyName()) && this.hasLicenseSpecifications() == other.hasLicenseSpecifications() && Objects.equals(this.licenseSpecifications(), other.licenseSpecifications()) && Objects.equals(this.maintenanceOptions(), other.maintenanceOptions()) && Objects.equals(this.metadataOptions(), other.metadataOptions()) && Objects.equals(this.monitoring(), other.monitoring()) && this.hasNetworkInterfaces() == other.hasNetworkInterfaces() && Objects.equals(this.networkInterfaces(), other.networkInterfaces()) && Objects.equals(this.networkPerformanceOptions(), other.networkPerformanceOptions()) && Objects.equals(this.placement(), other.placement()) && Objects.equals(this.privateDnsNameOptions(), other.privateDnsNameOptions()) && Objects.equals(this.privateIpAddress(), other.privateIpAddress()) && Objects.equals(this.ramdiskId(), other.ramdiskId()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.subnetId(), other.subnetId()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.userData(), other.userData());
    }

    public final String toString() {
        return ToString.builder((String)"ManagedInstanceRequest").add("BlockDeviceMappings", this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null).add("CapacityReservationSpecification", (Object)this.capacityReservationSpecification()).add("CpuOptions", (Object)this.cpuOptions()).add("CreditSpecification", (Object)this.creditSpecification()).add("DisableApiStop", (Object)this.disableApiStop()).add("EbsOptimized", (Object)this.ebsOptimized()).add("EnablePrimaryIpv6", (Object)this.enablePrimaryIpv6()).add("EnclaveOptions", (Object)this.enclaveOptions()).add("HibernationOptions", (Object)this.hibernationOptions()).add("IamInstanceProfile", (Object)this.iamInstanceProfile()).add("ImageId", (Object)this.imageId()).add("InstanceMarketOptions", (Object)this.instanceMarketOptions()).add("InstanceType", (Object)this.instanceType()).add("Ipv6Addresses", this.hasIpv6Addresses() ? this.ipv6Addresses() : null).add("Ipv6AddressCount", (Object)this.ipv6AddressCount()).add("KernelId", (Object)this.kernelId()).add("KeyName", (Object)this.keyName()).add("LicenseSpecifications", this.hasLicenseSpecifications() ? this.licenseSpecifications() : null).add("MaintenanceOptions", (Object)this.maintenanceOptions()).add("MetadataOptions", (Object)this.metadataOptions()).add("Monitoring", (Object)this.monitoring()).add("NetworkInterfaces", this.hasNetworkInterfaces() ? this.networkInterfaces() : null).add("NetworkPerformanceOptions", (Object)this.networkPerformanceOptions()).add("Placement", (Object)this.placement()).add("PrivateDnsNameOptions", (Object)this.privateDnsNameOptions()).add("PrivateIpAddress", (Object)(this.privateIpAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("RamdiskId", (Object)this.ramdiskId()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("SubnetId", (Object)this.subnetId()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("UserData", (Object)(this.userData() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlockDeviceMappings": {
                return Optional.ofNullable(clazz.cast(this.blockDeviceMappings()));
            }
            case "CapacityReservationSpecification": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationSpecification()));
            }
            case "CpuOptions": {
                return Optional.ofNullable(clazz.cast(this.cpuOptions()));
            }
            case "CreditSpecification": {
                return Optional.ofNullable(clazz.cast(this.creditSpecification()));
            }
            case "DisableApiStop": {
                return Optional.ofNullable(clazz.cast(this.disableApiStop()));
            }
            case "EbsOptimized": {
                return Optional.ofNullable(clazz.cast(this.ebsOptimized()));
            }
            case "EnablePrimaryIpv6": {
                return Optional.ofNullable(clazz.cast(this.enablePrimaryIpv6()));
            }
            case "EnclaveOptions": {
                return Optional.ofNullable(clazz.cast(this.enclaveOptions()));
            }
            case "HibernationOptions": {
                return Optional.ofNullable(clazz.cast(this.hibernationOptions()));
            }
            case "IamInstanceProfile": {
                return Optional.ofNullable(clazz.cast(this.iamInstanceProfile()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "InstanceMarketOptions": {
                return Optional.ofNullable(clazz.cast(this.instanceMarketOptions()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "Ipv6Addresses": {
                return Optional.ofNullable(clazz.cast(this.ipv6Addresses()));
            }
            case "Ipv6AddressCount": {
                return Optional.ofNullable(clazz.cast(this.ipv6AddressCount()));
            }
            case "KernelId": {
                return Optional.ofNullable(clazz.cast(this.kernelId()));
            }
            case "KeyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "LicenseSpecifications": {
                return Optional.ofNullable(clazz.cast(this.licenseSpecifications()));
            }
            case "MaintenanceOptions": {
                return Optional.ofNullable(clazz.cast(this.maintenanceOptions()));
            }
            case "MetadataOptions": {
                return Optional.ofNullable(clazz.cast(this.metadataOptions()));
            }
            case "Monitoring": {
                return Optional.ofNullable(clazz.cast(this.monitoring()));
            }
            case "NetworkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaces()));
            }
            case "NetworkPerformanceOptions": {
                return Optional.ofNullable(clazz.cast(this.networkPerformanceOptions()));
            }
            case "Placement": {
                return Optional.ofNullable(clazz.cast(this.placement()));
            }
            case "PrivateDnsNameOptions": {
                return Optional.ofNullable(clazz.cast(this.privateDnsNameOptions()));
            }
            case "PrivateIpAddress": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddress()));
            }
            case "RamdiskId": {
                return Optional.ofNullable(clazz.cast(this.ramdiskId()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "UserData": {
                return Optional.ofNullable(clazz.cast(this.userData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BlockDeviceMappings", BLOCK_DEVICE_MAPPINGS_FIELD);
        map.put("CapacityReservationSpecification", CAPACITY_RESERVATION_SPECIFICATION_FIELD);
        map.put("CpuOptions", CPU_OPTIONS_FIELD);
        map.put("CreditSpecification", CREDIT_SPECIFICATION_FIELD);
        map.put("DisableApiStop", DISABLE_API_STOP_FIELD);
        map.put("EbsOptimized", EBS_OPTIMIZED_FIELD);
        map.put("EnablePrimaryIpv6", ENABLE_PRIMARY_IPV6_FIELD);
        map.put("EnclaveOptions", ENCLAVE_OPTIONS_FIELD);
        map.put("HibernationOptions", HIBERNATION_OPTIONS_FIELD);
        map.put("IamInstanceProfile", IAM_INSTANCE_PROFILE_FIELD);
        map.put("ImageId", IMAGE_ID_FIELD);
        map.put("InstanceMarketOptions", INSTANCE_MARKET_OPTIONS_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("Ipv6Addresses", IPV6_ADDRESSES_FIELD);
        map.put("Ipv6AddressCount", IPV6_ADDRESS_COUNT_FIELD);
        map.put("KernelId", KERNEL_ID_FIELD);
        map.put("KeyName", KEY_NAME_FIELD);
        map.put("LicenseSpecifications", LICENSE_SPECIFICATIONS_FIELD);
        map.put("MaintenanceOptions", MAINTENANCE_OPTIONS_FIELD);
        map.put("MetadataOptions", METADATA_OPTIONS_FIELD);
        map.put("Monitoring", MONITORING_FIELD);
        map.put("NetworkInterfaces", NETWORK_INTERFACES_FIELD);
        map.put("NetworkPerformanceOptions", NETWORK_PERFORMANCE_OPTIONS_FIELD);
        map.put("Placement", PLACEMENT_FIELD);
        map.put("PrivateDnsNameOptions", PRIVATE_DNS_NAME_OPTIONS_FIELD);
        map.put("PrivateIpAddress", PRIVATE_IP_ADDRESS_FIELD);
        map.put("RamdiskId", RAMDISK_ID_FIELD);
        map.put("SecurityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("SecurityGroups", SECURITY_GROUPS_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("TagSpecifications", TAG_SPECIFICATIONS_FIELD);
        map.put("UserData", USER_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedInstanceRequest, T> g) {
        return obj -> g.apply((ManagedInstanceRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<BlockDeviceMappingRequest> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();
        private CapacityReservationSpecification capacityReservationSpecification;
        private CpuOptionsRequest cpuOptions;
        private CreditSpecificationRequest creditSpecification;
        private Boolean disableApiStop;
        private Boolean ebsOptimized;
        private Boolean enablePrimaryIpv6;
        private EnclaveOptionsRequest enclaveOptions;
        private HibernationOptionsRequest hibernationOptions;
        private IamInstanceProfileSpecification iamInstanceProfile;
        private String imageId;
        private InstanceMarketOptionsRequest instanceMarketOptions;
        private String instanceType;
        private List<InstanceIpv6Address> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();
        private Integer ipv6AddressCount;
        private String kernelId;
        private String keyName;
        private List<LicenseConfigurationRequest> licenseSpecifications = DefaultSdkAutoConstructList.getInstance();
        private InstanceMaintenanceOptionsRequest maintenanceOptions;
        private InstanceMetadataOptionsRequest metadataOptions;
        private RunInstancesMonitoringEnabled monitoring;
        private List<InstanceNetworkInterfaceSpecification> networkInterfaces = DefaultSdkAutoConstructList.getInstance();
        private InstanceNetworkPerformanceOptionsRequest networkPerformanceOptions;
        private Placement placement;
        private PrivateDnsNameOptionsRequest privateDnsNameOptions;
        private String privateIpAddress;
        private String ramdiskId;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private String subnetId;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String userData;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedInstanceRequest model) {
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.capacityReservationSpecification(model.capacityReservationSpecification);
            this.cpuOptions(model.cpuOptions);
            this.creditSpecification(model.creditSpecification);
            this.disableApiStop(model.disableApiStop);
            this.ebsOptimized(model.ebsOptimized);
            this.enablePrimaryIpv6(model.enablePrimaryIpv6);
            this.enclaveOptions(model.enclaveOptions);
            this.hibernationOptions(model.hibernationOptions);
            this.iamInstanceProfile(model.iamInstanceProfile);
            this.imageId(model.imageId);
            this.instanceMarketOptions(model.instanceMarketOptions);
            this.instanceType(model.instanceType);
            this.ipv6Addresses(model.ipv6Addresses);
            this.ipv6AddressCount(model.ipv6AddressCount);
            this.kernelId(model.kernelId);
            this.keyName(model.keyName);
            this.licenseSpecifications(model.licenseSpecifications);
            this.maintenanceOptions(model.maintenanceOptions);
            this.metadataOptions(model.metadataOptions);
            this.monitoring(model.monitoring);
            this.networkInterfaces(model.networkInterfaces);
            this.networkPerformanceOptions(model.networkPerformanceOptions);
            this.placement(model.placement);
            this.privateDnsNameOptions(model.privateDnsNameOptions);
            this.privateIpAddress(model.privateIpAddress);
            this.ramdiskId(model.ramdiskId);
            this.securityGroupIds(model.securityGroupIds);
            this.securityGroups(model.securityGroups);
            this.subnetId(model.subnetId);
            this.tagSpecifications(model.tagSpecifications);
            this.userData(model.userData);
        }

        public final List<BlockDeviceMappingRequest.Builder> getBlockDeviceMappings() {
            List<BlockDeviceMappingRequest.Builder> result = BlockDeviceMappingsCopier.copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMappingRequest.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMappingRequest> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMappingRequest ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMappingRequest.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (BlockDeviceMappingRequest)((BlockDeviceMappingRequest.Builder)BlockDeviceMappingRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CapacityReservationSpecification.Builder getCapacityReservationSpecification() {
            return this.capacityReservationSpecification != null ? this.capacityReservationSpecification.toBuilder() : null;
        }

        public final void setCapacityReservationSpecification(CapacityReservationSpecification.BuilderImpl capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification != null ? capacityReservationSpecification.build() : null;
        }

        @Override
        public final Builder capacityReservationSpecification(CapacityReservationSpecification capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification;
            return this;
        }

        public final CpuOptionsRequest.Builder getCpuOptions() {
            return this.cpuOptions != null ? this.cpuOptions.toBuilder() : null;
        }

        public final void setCpuOptions(CpuOptionsRequest.BuilderImpl cpuOptions) {
            this.cpuOptions = cpuOptions != null ? cpuOptions.build() : null;
        }

        @Override
        public final Builder cpuOptions(CpuOptionsRequest cpuOptions) {
            this.cpuOptions = cpuOptions;
            return this;
        }

        public final CreditSpecificationRequest.Builder getCreditSpecification() {
            return this.creditSpecification != null ? this.creditSpecification.toBuilder() : null;
        }

        public final void setCreditSpecification(CreditSpecificationRequest.BuilderImpl creditSpecification) {
            this.creditSpecification = creditSpecification != null ? creditSpecification.build() : null;
        }

        @Override
        public final Builder creditSpecification(CreditSpecificationRequest creditSpecification) {
            this.creditSpecification = creditSpecification;
            return this;
        }

        public final Boolean getDisableApiStop() {
            return this.disableApiStop;
        }

        public final void setDisableApiStop(Boolean disableApiStop) {
            this.disableApiStop = disableApiStop;
        }

        @Override
        public final Builder disableApiStop(Boolean disableApiStop) {
            this.disableApiStop = disableApiStop;
            return this;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final Boolean getEnablePrimaryIpv6() {
            return this.enablePrimaryIpv6;
        }

        public final void setEnablePrimaryIpv6(Boolean enablePrimaryIpv6) {
            this.enablePrimaryIpv6 = enablePrimaryIpv6;
        }

        @Override
        public final Builder enablePrimaryIpv6(Boolean enablePrimaryIpv6) {
            this.enablePrimaryIpv6 = enablePrimaryIpv6;
            return this;
        }

        public final EnclaveOptionsRequest.Builder getEnclaveOptions() {
            return this.enclaveOptions != null ? this.enclaveOptions.toBuilder() : null;
        }

        public final void setEnclaveOptions(EnclaveOptionsRequest.BuilderImpl enclaveOptions) {
            this.enclaveOptions = enclaveOptions != null ? enclaveOptions.build() : null;
        }

        @Override
        public final Builder enclaveOptions(EnclaveOptionsRequest enclaveOptions) {
            this.enclaveOptions = enclaveOptions;
            return this;
        }

        public final HibernationOptionsRequest.Builder getHibernationOptions() {
            return this.hibernationOptions != null ? this.hibernationOptions.toBuilder() : null;
        }

        public final void setHibernationOptions(HibernationOptionsRequest.BuilderImpl hibernationOptions) {
            this.hibernationOptions = hibernationOptions != null ? hibernationOptions.build() : null;
        }

        @Override
        public final Builder hibernationOptions(HibernationOptionsRequest hibernationOptions) {
            this.hibernationOptions = hibernationOptions;
            return this;
        }

        public final IamInstanceProfileSpecification.Builder getIamInstanceProfile() {
            return this.iamInstanceProfile != null ? this.iamInstanceProfile.toBuilder() : null;
        }

        public final void setIamInstanceProfile(IamInstanceProfileSpecification.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        @Override
        public final Builder iamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final InstanceMarketOptionsRequest.Builder getInstanceMarketOptions() {
            return this.instanceMarketOptions != null ? this.instanceMarketOptions.toBuilder() : null;
        }

        public final void setInstanceMarketOptions(InstanceMarketOptionsRequest.BuilderImpl instanceMarketOptions) {
            this.instanceMarketOptions = instanceMarketOptions != null ? instanceMarketOptions.build() : null;
        }

        @Override
        public final Builder instanceMarketOptions(InstanceMarketOptionsRequest instanceMarketOptions) {
            this.instanceMarketOptions = instanceMarketOptions;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final List<InstanceIpv6Address.Builder> getIpv6Addresses() {
            List<InstanceIpv6Address.Builder> result = Ipv6AddressesCopier.copyToBuilder(this.ipv6Addresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6Addresses(Collection<InstanceIpv6Address.BuilderImpl> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressesCopier.copyFromBuilder(ipv6Addresses);
        }

        @Override
        public final Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressesCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(InstanceIpv6Address ... ipv6Addresses) {
            this.ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder> ... ipv6Addresses) {
            this.ipv6Addresses(Stream.of(ipv6Addresses).map(c -> (InstanceIpv6Address)((InstanceIpv6Address.Builder)InstanceIpv6Address.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getIpv6AddressCount() {
            return this.ipv6AddressCount;
        }

        public final void setIpv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
        }

        @Override
        public final Builder ipv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final List<LicenseConfigurationRequest.Builder> getLicenseSpecifications() {
            List<LicenseConfigurationRequest.Builder> result = LicenseSpecificationsCopier.copyToBuilder(this.licenseSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseSpecifications(Collection<LicenseConfigurationRequest.BuilderImpl> licenseSpecifications) {
            this.licenseSpecifications = LicenseSpecificationsCopier.copyFromBuilder(licenseSpecifications);
        }

        @Override
        public final Builder licenseSpecifications(Collection<LicenseConfigurationRequest> licenseSpecifications) {
            this.licenseSpecifications = LicenseSpecificationsCopier.copy(licenseSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(LicenseConfigurationRequest ... licenseSpecifications) {
            this.licenseSpecifications(Arrays.asList(licenseSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(Consumer<LicenseConfigurationRequest.Builder> ... licenseSpecifications) {
            this.licenseSpecifications(Stream.of(licenseSpecifications).map(c -> (LicenseConfigurationRequest)((LicenseConfigurationRequest.Builder)LicenseConfigurationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final InstanceMaintenanceOptionsRequest.Builder getMaintenanceOptions() {
            return this.maintenanceOptions != null ? this.maintenanceOptions.toBuilder() : null;
        }

        public final void setMaintenanceOptions(InstanceMaintenanceOptionsRequest.BuilderImpl maintenanceOptions) {
            this.maintenanceOptions = maintenanceOptions != null ? maintenanceOptions.build() : null;
        }

        @Override
        public final Builder maintenanceOptions(InstanceMaintenanceOptionsRequest maintenanceOptions) {
            this.maintenanceOptions = maintenanceOptions;
            return this;
        }

        public final InstanceMetadataOptionsRequest.Builder getMetadataOptions() {
            return this.metadataOptions != null ? this.metadataOptions.toBuilder() : null;
        }

        public final void setMetadataOptions(InstanceMetadataOptionsRequest.BuilderImpl metadataOptions) {
            this.metadataOptions = metadataOptions != null ? metadataOptions.build() : null;
        }

        @Override
        public final Builder metadataOptions(InstanceMetadataOptionsRequest metadataOptions) {
            this.metadataOptions = metadataOptions;
            return this;
        }

        public final RunInstancesMonitoringEnabled.Builder getMonitoring() {
            return this.monitoring != null ? this.monitoring.toBuilder() : null;
        }

        public final void setMonitoring(RunInstancesMonitoringEnabled.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        @Override
        public final Builder monitoring(RunInstancesMonitoringEnabled monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final List<InstanceNetworkInterfaceSpecification.Builder> getNetworkInterfaces() {
            List<InstanceNetworkInterfaceSpecification.Builder> result = NetworkInterfacesCopier.copyToBuilder(this.networkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInterfaces(Collection<InstanceNetworkInterfaceSpecification.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = NetworkInterfacesCopier.copyFromBuilder(networkInterfaces);
        }

        @Override
        public final Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
            this.networkInterfaces = NetworkInterfacesCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(InstanceNetworkInterfaceSpecification ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<InstanceNetworkInterfaceSpecification.Builder> ... networkInterfaces) {
            this.networkInterfaces(Stream.of(networkInterfaces).map(c -> (InstanceNetworkInterfaceSpecification)((InstanceNetworkInterfaceSpecification.Builder)InstanceNetworkInterfaceSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final InstanceNetworkPerformanceOptionsRequest.Builder getNetworkPerformanceOptions() {
            return this.networkPerformanceOptions != null ? this.networkPerformanceOptions.toBuilder() : null;
        }

        public final void setNetworkPerformanceOptions(InstanceNetworkPerformanceOptionsRequest.BuilderImpl networkPerformanceOptions) {
            this.networkPerformanceOptions = networkPerformanceOptions != null ? networkPerformanceOptions.build() : null;
        }

        @Override
        public final Builder networkPerformanceOptions(InstanceNetworkPerformanceOptionsRequest networkPerformanceOptions) {
            this.networkPerformanceOptions = networkPerformanceOptions;
            return this;
        }

        public final Placement.Builder getPlacement() {
            return this.placement != null ? this.placement.toBuilder() : null;
        }

        public final void setPlacement(Placement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        @Override
        public final Builder placement(Placement placement) {
            this.placement = placement;
            return this;
        }

        public final PrivateDnsNameOptionsRequest.Builder getPrivateDnsNameOptions() {
            return this.privateDnsNameOptions != null ? this.privateDnsNameOptions.toBuilder() : null;
        }

        public final void setPrivateDnsNameOptions(PrivateDnsNameOptionsRequest.BuilderImpl privateDnsNameOptions) {
            this.privateDnsNameOptions = privateDnsNameOptions != null ? privateDnsNameOptions.build() : null;
        }

        @Override
        public final Builder privateDnsNameOptions(PrivateDnsNameOptionsRequest privateDnsNameOptions) {
            this.privateDnsNameOptions = privateDnsNameOptions;
            return this;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final String getRamdiskId() {
            return this.ramdiskId;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (this.securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupNamesCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupNamesCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationsCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationsCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationsCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUserData() {
            return this.userData;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public ManagedInstanceRequest build() {
            return new ManagedInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedInstanceRequest> {
        public Builder blockDeviceMappings(Collection<BlockDeviceMappingRequest> var1);

        public Builder blockDeviceMappings(BlockDeviceMappingRequest ... var1);

        public Builder blockDeviceMappings(Consumer<BlockDeviceMappingRequest.Builder> ... var1);

        public Builder capacityReservationSpecification(CapacityReservationSpecification var1);

        default public Builder capacityReservationSpecification(Consumer<CapacityReservationSpecification.Builder> capacityReservationSpecification) {
            return this.capacityReservationSpecification((CapacityReservationSpecification)((CapacityReservationSpecification.Builder)CapacityReservationSpecification.builder().applyMutation(capacityReservationSpecification)).build());
        }

        public Builder cpuOptions(CpuOptionsRequest var1);

        default public Builder cpuOptions(Consumer<CpuOptionsRequest.Builder> cpuOptions) {
            return this.cpuOptions((CpuOptionsRequest)((CpuOptionsRequest.Builder)CpuOptionsRequest.builder().applyMutation(cpuOptions)).build());
        }

        public Builder creditSpecification(CreditSpecificationRequest var1);

        default public Builder creditSpecification(Consumer<CreditSpecificationRequest.Builder> creditSpecification) {
            return this.creditSpecification((CreditSpecificationRequest)((CreditSpecificationRequest.Builder)CreditSpecificationRequest.builder().applyMutation(creditSpecification)).build());
        }

        public Builder disableApiStop(Boolean var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder enablePrimaryIpv6(Boolean var1);

        public Builder enclaveOptions(EnclaveOptionsRequest var1);

        default public Builder enclaveOptions(Consumer<EnclaveOptionsRequest.Builder> enclaveOptions) {
            return this.enclaveOptions((EnclaveOptionsRequest)((EnclaveOptionsRequest.Builder)EnclaveOptionsRequest.builder().applyMutation(enclaveOptions)).build());
        }

        public Builder hibernationOptions(HibernationOptionsRequest var1);

        default public Builder hibernationOptions(Consumer<HibernationOptionsRequest.Builder> hibernationOptions) {
            return this.hibernationOptions((HibernationOptionsRequest)((HibernationOptionsRequest.Builder)HibernationOptionsRequest.builder().applyMutation(hibernationOptions)).build());
        }

        public Builder iamInstanceProfile(IamInstanceProfileSpecification var1);

        default public Builder iamInstanceProfile(Consumer<IamInstanceProfileSpecification.Builder> iamInstanceProfile) {
            return this.iamInstanceProfile((IamInstanceProfileSpecification)((IamInstanceProfileSpecification.Builder)IamInstanceProfileSpecification.builder().applyMutation(iamInstanceProfile)).build());
        }

        public Builder imageId(String var1);

        public Builder instanceMarketOptions(InstanceMarketOptionsRequest var1);

        default public Builder instanceMarketOptions(Consumer<InstanceMarketOptionsRequest.Builder> instanceMarketOptions) {
            return this.instanceMarketOptions((InstanceMarketOptionsRequest)((InstanceMarketOptionsRequest.Builder)InstanceMarketOptionsRequest.builder().applyMutation(instanceMarketOptions)).build());
        }

        public Builder instanceType(String var1);

        public Builder ipv6Addresses(Collection<InstanceIpv6Address> var1);

        public Builder ipv6Addresses(InstanceIpv6Address ... var1);

        public Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder> ... var1);

        public Builder ipv6AddressCount(Integer var1);

        public Builder kernelId(String var1);

        public Builder keyName(String var1);

        public Builder licenseSpecifications(Collection<LicenseConfigurationRequest> var1);

        public Builder licenseSpecifications(LicenseConfigurationRequest ... var1);

        public Builder licenseSpecifications(Consumer<LicenseConfigurationRequest.Builder> ... var1);

        public Builder maintenanceOptions(InstanceMaintenanceOptionsRequest var1);

        default public Builder maintenanceOptions(Consumer<InstanceMaintenanceOptionsRequest.Builder> maintenanceOptions) {
            return this.maintenanceOptions((InstanceMaintenanceOptionsRequest)((InstanceMaintenanceOptionsRequest.Builder)InstanceMaintenanceOptionsRequest.builder().applyMutation(maintenanceOptions)).build());
        }

        public Builder metadataOptions(InstanceMetadataOptionsRequest var1);

        default public Builder metadataOptions(Consumer<InstanceMetadataOptionsRequest.Builder> metadataOptions) {
            return this.metadataOptions((InstanceMetadataOptionsRequest)((InstanceMetadataOptionsRequest.Builder)InstanceMetadataOptionsRequest.builder().applyMutation(metadataOptions)).build());
        }

        public Builder monitoring(RunInstancesMonitoringEnabled var1);

        default public Builder monitoring(Consumer<RunInstancesMonitoringEnabled.Builder> monitoring) {
            return this.monitoring((RunInstancesMonitoringEnabled)((RunInstancesMonitoringEnabled.Builder)RunInstancesMonitoringEnabled.builder().applyMutation(monitoring)).build());
        }

        public Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> var1);

        public Builder networkInterfaces(InstanceNetworkInterfaceSpecification ... var1);

        public Builder networkInterfaces(Consumer<InstanceNetworkInterfaceSpecification.Builder> ... var1);

        public Builder networkPerformanceOptions(InstanceNetworkPerformanceOptionsRequest var1);

        default public Builder networkPerformanceOptions(Consumer<InstanceNetworkPerformanceOptionsRequest.Builder> networkPerformanceOptions) {
            return this.networkPerformanceOptions((InstanceNetworkPerformanceOptionsRequest)((InstanceNetworkPerformanceOptionsRequest.Builder)InstanceNetworkPerformanceOptionsRequest.builder().applyMutation(networkPerformanceOptions)).build());
        }

        public Builder placement(Placement var1);

        default public Builder placement(Consumer<Placement.Builder> placement) {
            return this.placement((Placement)((Placement.Builder)Placement.builder().applyMutation(placement)).build());
        }

        public Builder privateDnsNameOptions(PrivateDnsNameOptionsRequest var1);

        default public Builder privateDnsNameOptions(Consumer<PrivateDnsNameOptionsRequest.Builder> privateDnsNameOptions) {
            return this.privateDnsNameOptions((PrivateDnsNameOptionsRequest)((PrivateDnsNameOptionsRequest.Builder)PrivateDnsNameOptionsRequest.builder().applyMutation(privateDnsNameOptions)).build());
        }

        public Builder privateIpAddress(String var1);

        public Builder ramdiskId(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder subnetId(String var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder userData(String var1);
    }
}

