/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesinstances.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspacesinstances.model.VolumeTypeEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EbsBlockDevice
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EbsBlockDevice> {
    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeType").getter(EbsBlockDevice.getter(EbsBlockDevice::volumeTypeAsString)).setter(EbsBlockDevice.setter(Builder::volumeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Encrypted").getter(EbsBlockDevice.getter(EbsBlockDevice::encrypted)).setter(EbsBlockDevice.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(EbsBlockDevice.getter(EbsBlockDevice::kmsKeyId)).setter(EbsBlockDevice.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Iops").getter(EbsBlockDevice.getter(EbsBlockDevice::iops)).setter(EbsBlockDevice.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()}).build();
    private static final SdkField<Integer> THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Throughput").getter(EbsBlockDevice.getter(EbsBlockDevice::throughput)).setter(EbsBlockDevice.setter(Builder::throughput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Throughput").build()}).build();
    private static final SdkField<Integer> VOLUME_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VolumeSize").getter(EbsBlockDevice.getter(EbsBlockDevice::volumeSize)).setter(EbsBlockDevice.setter(Builder::volumeSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_TYPE_FIELD, ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, IOPS_FIELD, THROUGHPUT_FIELD, VOLUME_SIZE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EbsBlockDevice.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String volumeType;
    private final Boolean encrypted;
    private final String kmsKeyId;
    private final Integer iops;
    private final Integer throughput;
    private final Integer volumeSize;

    private EbsBlockDevice(BuilderImpl builder) {
        this.volumeType = builder.volumeType;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.iops = builder.iops;
        this.throughput = builder.throughput;
        this.volumeSize = builder.volumeSize;
    }

    public final VolumeTypeEnum volumeType() {
        return VolumeTypeEnum.fromValue(this.volumeType);
    }

    public final String volumeTypeAsString() {
        return this.volumeType;
    }

    public final Boolean encrypted() {
        return this.encrypted;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final Integer iops() {
        return this.iops;
    }

    public final Integer throughput() {
        return this.throughput;
    }

    public final Integer volumeSize() {
        return this.volumeSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsBlockDevice)) {
            return false;
        }
        EbsBlockDevice other = (EbsBlockDevice)obj;
        return Objects.equals(this.volumeTypeAsString(), other.volumeTypeAsString()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.throughput(), other.throughput()) && Objects.equals(this.volumeSize(), other.volumeSize());
    }

    public final String toString() {
        return ToString.builder((String)"EbsBlockDevice").add("VolumeType", (Object)this.volumeTypeAsString()).add("Encrypted", (Object)this.encrypted()).add("KmsKeyId", (Object)(this.kmsKeyId() == null ? null : "*** Sensitive Data Redacted ***")).add("Iops", (Object)this.iops()).add("Throughput", (Object)this.throughput()).add("VolumeSize", (Object)this.volumeSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumeType": {
                return Optional.ofNullable(clazz.cast(this.volumeTypeAsString()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "Throughput": {
                return Optional.ofNullable(clazz.cast(this.throughput()));
            }
            case "VolumeSize": {
                return Optional.ofNullable(clazz.cast(this.volumeSize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VolumeType", VOLUME_TYPE_FIELD);
        map.put("Encrypted", ENCRYPTED_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("Iops", IOPS_FIELD);
        map.put("Throughput", THROUGHPUT_FIELD);
        map.put("VolumeSize", VOLUME_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EbsBlockDevice, T> g) {
        return obj -> g.apply((EbsBlockDevice)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String volumeType;
        private Boolean encrypted;
        private String kmsKeyId;
        private Integer iops;
        private Integer throughput;
        private Integer volumeSize;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsBlockDevice model) {
            this.volumeType(model.volumeType);
            this.encrypted(model.encrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.iops(model.iops);
            this.throughput(model.throughput);
            this.volumeSize(model.volumeSize);
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeTypeEnum volumeType) {
            this.volumeType(volumeType == null ? null : volumeType.toString());
            return this;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Integer getIops() {
            return this.iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final Integer getThroughput() {
            return this.throughput;
        }

        public final void setThroughput(Integer throughput) {
            this.throughput = throughput;
        }

        @Override
        public final Builder throughput(Integer throughput) {
            this.throughput = throughput;
            return this;
        }

        public final Integer getVolumeSize() {
            return this.volumeSize;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public EbsBlockDevice build() {
            return new EbsBlockDevice(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EbsBlockDevice> {
        public Builder volumeType(String var1);

        public Builder volumeType(VolumeTypeEnum var1);

        public Builder encrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder iops(Integer var1);

        public Builder throughput(Integer var1);

        public Builder volumeSize(Integer var1);
    }
}

