/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.WorkSpaceAssociatedResourceType;
import software.amazon.awssdk.services.workspaces.model.WorkSpaceAssociatedResourceTypeListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorkspaceAssociationsRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, DescribeWorkspaceAssociationsRequest> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkspaceId").getter(DescribeWorkspaceAssociationsRequest.getter(DescribeWorkspaceAssociationsRequest::workspaceId)).setter(DescribeWorkspaceAssociationsRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceId").build()}).build();
    private static final SdkField<List<String>> ASSOCIATED_RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedResourceTypes").getter(DescribeWorkspaceAssociationsRequest.getter(DescribeWorkspaceAssociationsRequest::associatedResourceTypesAsStrings)).setter(DescribeWorkspaceAssociationsRequest.setter(Builder::associatedResourceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD, ASSOCIATED_RESOURCE_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeWorkspaceAssociationsRequest.memberNameToFieldInitializer();
    private final String workspaceId;
    private final List<String> associatedResourceTypes;

    private DescribeWorkspaceAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceId = builder.workspaceId;
        this.associatedResourceTypes = builder.associatedResourceTypes;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public final List<WorkSpaceAssociatedResourceType> associatedResourceTypes() {
        return WorkSpaceAssociatedResourceTypeListCopier.copyStringToEnum(this.associatedResourceTypes);
    }

    public final boolean hasAssociatedResourceTypes() {
        return this.associatedResourceTypes != null && !(this.associatedResourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> associatedResourceTypesAsStrings() {
        return this.associatedResourceTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedResourceTypes() ? this.associatedResourceTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspaceAssociationsRequest)) {
            return false;
        }
        DescribeWorkspaceAssociationsRequest other = (DescribeWorkspaceAssociationsRequest)((Object)obj);
        return Objects.equals(this.workspaceId(), other.workspaceId()) && this.hasAssociatedResourceTypes() == other.hasAssociatedResourceTypes() && Objects.equals(this.associatedResourceTypesAsStrings(), other.associatedResourceTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeWorkspaceAssociationsRequest").add("WorkspaceId", (Object)this.workspaceId()).add("AssociatedResourceTypes", this.hasAssociatedResourceTypes() ? this.associatedResourceTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
            case "AssociatedResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.associatedResourceTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WorkspaceId", WORKSPACE_ID_FIELD);
        map.put("AssociatedResourceTypes", ASSOCIATED_RESOURCE_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspaceAssociationsRequest, T> g) {
        return obj -> g.apply((DescribeWorkspaceAssociationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private String workspaceId;
        private List<String> associatedResourceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspaceAssociationsRequest model) {
            super(model);
            this.workspaceId(model.workspaceId);
            this.associatedResourceTypesWithStrings(model.associatedResourceTypes);
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final Collection<String> getAssociatedResourceTypes() {
            if (this.associatedResourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedResourceTypes;
        }

        public final void setAssociatedResourceTypes(Collection<String> associatedResourceTypes) {
            this.associatedResourceTypes = WorkSpaceAssociatedResourceTypeListCopier.copy(associatedResourceTypes);
        }

        @Override
        public final Builder associatedResourceTypesWithStrings(Collection<String> associatedResourceTypes) {
            this.associatedResourceTypes = WorkSpaceAssociatedResourceTypeListCopier.copy(associatedResourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedResourceTypesWithStrings(String ... associatedResourceTypes) {
            this.associatedResourceTypesWithStrings(Arrays.asList(associatedResourceTypes));
            return this;
        }

        @Override
        public final Builder associatedResourceTypes(Collection<WorkSpaceAssociatedResourceType> associatedResourceTypes) {
            this.associatedResourceTypes = WorkSpaceAssociatedResourceTypeListCopier.copyEnumToString(associatedResourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedResourceTypes(WorkSpaceAssociatedResourceType ... associatedResourceTypes) {
            this.associatedResourceTypes(Arrays.asList(associatedResourceTypes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeWorkspaceAssociationsRequest build() {
            return new DescribeWorkspaceAssociationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorkspaceAssociationsRequest> {
        public Builder workspaceId(String var1);

        public Builder associatedResourceTypesWithStrings(Collection<String> var1);

        public Builder associatedResourceTypesWithStrings(String ... var1);

        public Builder associatedResourceTypes(Collection<WorkSpaceAssociatedResourceType> var1);

        public Builder associatedResourceTypes(WorkSpaceAssociatedResourceType ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

