/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.CustomWorkspaceImageImportErrorDetails;
import software.amazon.awssdk.services.workspaces.model.CustomWorkspaceImageImportErrorDetailsListCopier;
import software.amazon.awssdk.services.workspaces.model.CustomWorkspaceImageImportState;
import software.amazon.awssdk.services.workspaces.model.ImageSourceIdentifier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCustomWorkspaceImageImportResponse
extends WorkSpacesResponse
implements ToCopyableBuilder<Builder, DescribeCustomWorkspaceImageImportResponse> {
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(DescribeCustomWorkspaceImageImportResponse.getter(DescribeCustomWorkspaceImageImportResponse::imageId)).setter(DescribeCustomWorkspaceImageImportResponse.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()}).build();
    private static final SdkField<String> INFRASTRUCTURE_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InfrastructureConfigurationArn").getter(DescribeCustomWorkspaceImageImportResponse.getter(DescribeCustomWorkspaceImageImportResponse::infrastructureConfigurationArn)).setter(DescribeCustomWorkspaceImageImportResponse.setter(Builder::infrastructureConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InfrastructureConfigurationArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(DescribeCustomWorkspaceImageImportResponse.getter(DescribeCustomWorkspaceImageImportResponse::stateAsString)).setter(DescribeCustomWorkspaceImageImportResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Created").getter(DescribeCustomWorkspaceImageImportResponse.getter(DescribeCustomWorkspaceImageImportResponse::created)).setter(DescribeCustomWorkspaceImageImportResponse.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Created").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(DescribeCustomWorkspaceImageImportResponse.getter(DescribeCustomWorkspaceImageImportResponse::lastUpdatedTime)).setter(DescribeCustomWorkspaceImageImportResponse.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<ImageSourceIdentifier> IMAGE_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImageSource").getter(DescribeCustomWorkspaceImageImportResponse.getter(DescribeCustomWorkspaceImageImportResponse::imageSource)).setter(DescribeCustomWorkspaceImageImportResponse.setter(Builder::imageSource)).constructor(ImageSourceIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageSource").build()}).build();
    private static final SdkField<String> IMAGE_BUILDER_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageBuilderInstanceId").getter(DescribeCustomWorkspaceImageImportResponse.getter(DescribeCustomWorkspaceImageImportResponse::imageBuilderInstanceId)).setter(DescribeCustomWorkspaceImageImportResponse.setter(Builder::imageBuilderInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageBuilderInstanceId").build()}).build();
    private static final SdkField<List<CustomWorkspaceImageImportErrorDetails>> ERROR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ErrorDetails").getter(DescribeCustomWorkspaceImageImportResponse.getter(DescribeCustomWorkspaceImageImportResponse::errorDetails)).setter(DescribeCustomWorkspaceImageImportResponse.setter(Builder::errorDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomWorkspaceImageImportErrorDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_ID_FIELD, INFRASTRUCTURE_CONFIGURATION_ARN_FIELD, STATE_FIELD, CREATED_FIELD, LAST_UPDATED_TIME_FIELD, IMAGE_SOURCE_FIELD, IMAGE_BUILDER_INSTANCE_ID_FIELD, ERROR_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeCustomWorkspaceImageImportResponse.memberNameToFieldInitializer();
    private final String imageId;
    private final String infrastructureConfigurationArn;
    private final String state;
    private final Instant created;
    private final Instant lastUpdatedTime;
    private final ImageSourceIdentifier imageSource;
    private final String imageBuilderInstanceId;
    private final List<CustomWorkspaceImageImportErrorDetails> errorDetails;

    private DescribeCustomWorkspaceImageImportResponse(BuilderImpl builder) {
        super(builder);
        this.imageId = builder.imageId;
        this.infrastructureConfigurationArn = builder.infrastructureConfigurationArn;
        this.state = builder.state;
        this.created = builder.created;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.imageSource = builder.imageSource;
        this.imageBuilderInstanceId = builder.imageBuilderInstanceId;
        this.errorDetails = builder.errorDetails;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final String infrastructureConfigurationArn() {
        return this.infrastructureConfigurationArn;
    }

    public final CustomWorkspaceImageImportState state() {
        return CustomWorkspaceImageImportState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant created() {
        return this.created;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final ImageSourceIdentifier imageSource() {
        return this.imageSource;
    }

    public final String imageBuilderInstanceId() {
        return this.imageBuilderInstanceId;
    }

    public final boolean hasErrorDetails() {
        return this.errorDetails != null && !(this.errorDetails instanceof SdkAutoConstructList);
    }

    public final List<CustomWorkspaceImageImportErrorDetails> errorDetails() {
        return this.errorDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.infrastructureConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageBuilderInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorDetails() ? this.errorDetails() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCustomWorkspaceImageImportResponse)) {
            return false;
        }
        DescribeCustomWorkspaceImageImportResponse other = (DescribeCustomWorkspaceImageImportResponse)((Object)obj);
        return Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.infrastructureConfigurationArn(), other.infrastructureConfigurationArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.imageSource(), other.imageSource()) && Objects.equals(this.imageBuilderInstanceId(), other.imageBuilderInstanceId()) && this.hasErrorDetails() == other.hasErrorDetails() && Objects.equals(this.errorDetails(), other.errorDetails());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCustomWorkspaceImageImportResponse").add("ImageId", (Object)this.imageId()).add("InfrastructureConfigurationArn", (Object)this.infrastructureConfigurationArn()).add("State", (Object)this.stateAsString()).add("Created", (Object)this.created()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("ImageSource", (Object)this.imageSource()).add("ImageBuilderInstanceId", (Object)this.imageBuilderInstanceId()).add("ErrorDetails", this.hasErrorDetails() ? this.errorDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "InfrastructureConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.infrastructureConfigurationArn()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "ImageSource": {
                return Optional.ofNullable(clazz.cast(this.imageSource()));
            }
            case "ImageBuilderInstanceId": {
                return Optional.ofNullable(clazz.cast(this.imageBuilderInstanceId()));
            }
            case "ErrorDetails": {
                return Optional.ofNullable(clazz.cast(this.errorDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ImageId", IMAGE_ID_FIELD);
        map.put("InfrastructureConfigurationArn", INFRASTRUCTURE_CONFIGURATION_ARN_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Created", CREATED_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("ImageSource", IMAGE_SOURCE_FIELD);
        map.put("ImageBuilderInstanceId", IMAGE_BUILDER_INSTANCE_ID_FIELD);
        map.put("ErrorDetails", ERROR_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCustomWorkspaceImageImportResponse, T> g) {
        return obj -> g.apply((DescribeCustomWorkspaceImageImportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesResponse.BuilderImpl
    implements Builder {
        private String imageId;
        private String infrastructureConfigurationArn;
        private String state;
        private Instant created;
        private Instant lastUpdatedTime;
        private ImageSourceIdentifier imageSource;
        private String imageBuilderInstanceId;
        private List<CustomWorkspaceImageImportErrorDetails> errorDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCustomWorkspaceImageImportResponse model) {
            super(model);
            this.imageId(model.imageId);
            this.infrastructureConfigurationArn(model.infrastructureConfigurationArn);
            this.state(model.state);
            this.created(model.created);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.imageSource(model.imageSource);
            this.imageBuilderInstanceId(model.imageBuilderInstanceId);
            this.errorDetails(model.errorDetails);
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getInfrastructureConfigurationArn() {
            return this.infrastructureConfigurationArn;
        }

        public final void setInfrastructureConfigurationArn(String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
        }

        @Override
        public final Builder infrastructureConfigurationArn(String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CustomWorkspaceImageImportState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getCreated() {
            return this.created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final ImageSourceIdentifier.Builder getImageSource() {
            return this.imageSource != null ? this.imageSource.toBuilder() : null;
        }

        public final void setImageSource(ImageSourceIdentifier.BuilderImpl imageSource) {
            this.imageSource = imageSource != null ? imageSource.build() : null;
        }

        @Override
        public final Builder imageSource(ImageSourceIdentifier imageSource) {
            this.imageSource = imageSource;
            return this;
        }

        public final String getImageBuilderInstanceId() {
            return this.imageBuilderInstanceId;
        }

        public final void setImageBuilderInstanceId(String imageBuilderInstanceId) {
            this.imageBuilderInstanceId = imageBuilderInstanceId;
        }

        @Override
        public final Builder imageBuilderInstanceId(String imageBuilderInstanceId) {
            this.imageBuilderInstanceId = imageBuilderInstanceId;
            return this;
        }

        public final List<CustomWorkspaceImageImportErrorDetails.Builder> getErrorDetails() {
            List<CustomWorkspaceImageImportErrorDetails.Builder> result = CustomWorkspaceImageImportErrorDetailsListCopier.copyToBuilder(this.errorDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorDetails(Collection<CustomWorkspaceImageImportErrorDetails.BuilderImpl> errorDetails) {
            this.errorDetails = CustomWorkspaceImageImportErrorDetailsListCopier.copyFromBuilder(errorDetails);
        }

        @Override
        public final Builder errorDetails(Collection<CustomWorkspaceImageImportErrorDetails> errorDetails) {
            this.errorDetails = CustomWorkspaceImageImportErrorDetailsListCopier.copy(errorDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetails(CustomWorkspaceImageImportErrorDetails ... errorDetails) {
            this.errorDetails(Arrays.asList(errorDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetails(Consumer<CustomWorkspaceImageImportErrorDetails.Builder> ... errorDetails) {
            this.errorDetails(Stream.of(errorDetails).map(c -> (CustomWorkspaceImageImportErrorDetails)((CustomWorkspaceImageImportErrorDetails.Builder)CustomWorkspaceImageImportErrorDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeCustomWorkspaceImageImportResponse build() {
            return new DescribeCustomWorkspaceImageImportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCustomWorkspaceImageImportResponse> {
        public Builder imageId(String var1);

        public Builder infrastructureConfigurationArn(String var1);

        public Builder state(String var1);

        public Builder state(CustomWorkspaceImageImportState var1);

        public Builder created(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder imageSource(ImageSourceIdentifier var1);

        default public Builder imageSource(Consumer<ImageSourceIdentifier.Builder> imageSource) {
            return this.imageSource((ImageSourceIdentifier)((ImageSourceIdentifier.Builder)ImageSourceIdentifier.builder().applyMutation(imageSource)).build());
        }

        public Builder imageBuilderInstanceId(String var1);

        public Builder errorDetails(Collection<CustomWorkspaceImageImportErrorDetails> var1);

        public Builder errorDetails(CustomWorkspaceImageImportErrorDetails ... var1);

        public Builder errorDetails(Consumer<CustomWorkspaceImageImportErrorDetails.Builder> ... var1);
    }
}

