/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a pool of WorkSpaces.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkspacesPool implements SdkPojo, Serializable, ToCopyableBuilder<WorkspacesPool.Builder, WorkspacesPool> {
    private static final SdkField<String> POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PoolId")
            .getter(getter(WorkspacesPool::poolId)).setter(setter(Builder::poolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()).build();

    private static final SdkField<String> POOL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoolArn").getter(getter(WorkspacesPool::poolArn)).setter(setter(Builder::poolArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolArn").build()).build();

    private static final SdkField<CapacityStatus> CAPACITY_STATUS_FIELD = SdkField
            .<CapacityStatus> builder(MarshallingType.SDK_POJO).memberName("CapacityStatus")
            .getter(getter(WorkspacesPool::capacityStatus)).setter(setter(Builder::capacityStatus))
            .constructor(CapacityStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityStatus").build()).build();

    private static final SdkField<String> POOL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoolName").getter(getter(WorkspacesPool::poolName)).setter(setter(Builder::poolName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(WorkspacesPool::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(WorkspacesPool::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(WorkspacesPool::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BundleId").getter(getter(WorkspacesPool::bundleId)).setter(setter(Builder::bundleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleId").build()).build();

    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(WorkspacesPool::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<List<WorkspacesPoolError>> ERRORS_FIELD = SdkField
            .<List<WorkspacesPoolError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(WorkspacesPool::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkspacesPoolError> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkspacesPoolError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ApplicationSettingsResponse> APPLICATION_SETTINGS_FIELD = SdkField
            .<ApplicationSettingsResponse> builder(MarshallingType.SDK_POJO).memberName("ApplicationSettings")
            .getter(getter(WorkspacesPool::applicationSettings)).setter(setter(Builder::applicationSettings))
            .constructor(ApplicationSettingsResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSettings").build())
            .build();

    private static final SdkField<TimeoutSettings> TIMEOUT_SETTINGS_FIELD = SdkField
            .<TimeoutSettings> builder(MarshallingType.SDK_POJO).memberName("TimeoutSettings")
            .getter(getter(WorkspacesPool::timeoutSettings)).setter(setter(Builder::timeoutSettings))
            .constructor(TimeoutSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutSettings").build()).build();

    private static final SdkField<String> RUNNING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RunningMode").getter(getter(WorkspacesPool::runningModeAsString)).setter(setter(Builder::runningMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunningMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_ID_FIELD, POOL_ARN_FIELD,
            CAPACITY_STATUS_FIELD, POOL_NAME_FIELD, DESCRIPTION_FIELD, STATE_FIELD, CREATED_AT_FIELD, BUNDLE_ID_FIELD,
            DIRECTORY_ID_FIELD, ERRORS_FIELD, APPLICATION_SETTINGS_FIELD, TIMEOUT_SETTINGS_FIELD, RUNNING_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String poolId;

    private final String poolArn;

    private final CapacityStatus capacityStatus;

    private final String poolName;

    private final String description;

    private final String state;

    private final Instant createdAt;

    private final String bundleId;

    private final String directoryId;

    private final List<WorkspacesPoolError> errors;

    private final ApplicationSettingsResponse applicationSettings;

    private final TimeoutSettings timeoutSettings;

    private final String runningMode;

    private WorkspacesPool(BuilderImpl builder) {
        this.poolId = builder.poolId;
        this.poolArn = builder.poolArn;
        this.capacityStatus = builder.capacityStatus;
        this.poolName = builder.poolName;
        this.description = builder.description;
        this.state = builder.state;
        this.createdAt = builder.createdAt;
        this.bundleId = builder.bundleId;
        this.directoryId = builder.directoryId;
        this.errors = builder.errors;
        this.applicationSettings = builder.applicationSettings;
        this.timeoutSettings = builder.timeoutSettings;
        this.runningMode = builder.runningMode;
    }

    /**
     * <p>
     * The identifier of a pool.
     * </p>
     * 
     * @return The identifier of a pool.
     */
    public final String poolId() {
        return poolId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the pool.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the pool.
     */
    public final String poolArn() {
        return poolArn;
    }

    /**
     * <p>
     * The capacity status for the pool
     * </p>
     * 
     * @return The capacity status for the pool
     */
    public final CapacityStatus capacityStatus() {
        return capacityStatus;
    }

    /**
     * <p>
     * The name of the pool.
     * </p>
     * 
     * @return The name of the pool.
     */
    public final String poolName() {
        return poolName;
    }

    /**
     * <p>
     * The description of the pool.
     * </p>
     * 
     * @return The description of the pool.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The current state of the pool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link WorkspacesPoolState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the pool.
     * @see WorkspacesPoolState
     */
    public final WorkspacesPoolState state() {
        return WorkspacesPoolState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the pool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link WorkspacesPoolState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the pool.
     * @see WorkspacesPoolState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The time the pool was created.
     * </p>
     * 
     * @return The time the pool was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The identifier of the bundle used by the pool.
     * </p>
     * 
     * @return The identifier of the bundle used by the pool.
     */
    public final String bundleId() {
        return bundleId;
    }

    /**
     * <p>
     * The identifier of the directory used by the pool.
     * </p>
     * 
     * @return The identifier of the directory used by the pool.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The pool errors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return The pool errors.
     */
    public final List<WorkspacesPoolError> errors() {
        return errors;
    }

    /**
     * <p>
     * The persistent application settings for users of the pool.
     * </p>
     * 
     * @return The persistent application settings for users of the pool.
     */
    public final ApplicationSettingsResponse applicationSettings() {
        return applicationSettings;
    }

    /**
     * <p>
     * The amount of time that a pool session remains active after users disconnect. If they try to reconnect to the
     * pool session after a disconnection or network interruption within this time interval, they are connected to their
     * previous session. Otherwise, they are connected to a new session with a new pool instance.
     * </p>
     * 
     * @return The amount of time that a pool session remains active after users disconnect. If they try to reconnect to
     *         the pool session after a disconnection or network interruption within this time interval, they are
     *         connected to their previous session. Otherwise, they are connected to a new session with a new pool
     *         instance.
     */
    public final TimeoutSettings timeoutSettings() {
        return timeoutSettings;
    }

    /**
     * <p>
     * The running mode of the pool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runningMode} will
     * return {@link PoolsRunningMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runningModeAsString}.
     * </p>
     * 
     * @return The running mode of the pool.
     * @see PoolsRunningMode
     */
    public final PoolsRunningMode runningMode() {
        return PoolsRunningMode.fromValue(runningMode);
    }

    /**
     * <p>
     * The running mode of the pool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runningMode} will
     * return {@link PoolsRunningMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runningModeAsString}.
     * </p>
     * 
     * @return The running mode of the pool.
     * @see PoolsRunningMode
     */
    public final String runningModeAsString() {
        return runningMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(poolId());
        hashCode = 31 * hashCode + Objects.hashCode(poolArn());
        hashCode = 31 * hashCode + Objects.hashCode(capacityStatus());
        hashCode = 31 * hashCode + Objects.hashCode(poolName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(applicationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutSettings());
        hashCode = 31 * hashCode + Objects.hashCode(runningModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspacesPool)) {
            return false;
        }
        WorkspacesPool other = (WorkspacesPool) obj;
        return Objects.equals(poolId(), other.poolId()) && Objects.equals(poolArn(), other.poolArn())
                && Objects.equals(capacityStatus(), other.capacityStatus()) && Objects.equals(poolName(), other.poolName())
                && Objects.equals(description(), other.description()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(bundleId(), other.bundleId())
                && Objects.equals(directoryId(), other.directoryId()) && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors()) && Objects.equals(applicationSettings(), other.applicationSettings())
                && Objects.equals(timeoutSettings(), other.timeoutSettings())
                && Objects.equals(runningModeAsString(), other.runningModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkspacesPool").add("PoolId", poolId()).add("PoolArn", poolArn())
                .add("CapacityStatus", capacityStatus()).add("PoolName", poolName()).add("Description", description())
                .add("State", stateAsString()).add("CreatedAt", createdAt()).add("BundleId", bundleId())
                .add("DirectoryId", directoryId()).add("Errors", hasErrors() ? errors() : null)
                .add("ApplicationSettings", applicationSettings()).add("TimeoutSettings", timeoutSettings())
                .add("RunningMode", runningModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PoolId":
            return Optional.ofNullable(clazz.cast(poolId()));
        case "PoolArn":
            return Optional.ofNullable(clazz.cast(poolArn()));
        case "CapacityStatus":
            return Optional.ofNullable(clazz.cast(capacityStatus()));
        case "PoolName":
            return Optional.ofNullable(clazz.cast(poolName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "BundleId":
            return Optional.ofNullable(clazz.cast(bundleId()));
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "ApplicationSettings":
            return Optional.ofNullable(clazz.cast(applicationSettings()));
        case "TimeoutSettings":
            return Optional.ofNullable(clazz.cast(timeoutSettings()));
        case "RunningMode":
            return Optional.ofNullable(clazz.cast(runningModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PoolId", POOL_ID_FIELD);
        map.put("PoolArn", POOL_ARN_FIELD);
        map.put("CapacityStatus", CAPACITY_STATUS_FIELD);
        map.put("PoolName", POOL_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("State", STATE_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("BundleId", BUNDLE_ID_FIELD);
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("Errors", ERRORS_FIELD);
        map.put("ApplicationSettings", APPLICATION_SETTINGS_FIELD);
        map.put("TimeoutSettings", TIMEOUT_SETTINGS_FIELD);
        map.put("RunningMode", RUNNING_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkspacesPool, T> g) {
        return obj -> g.apply((WorkspacesPool) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkspacesPool> {
        /**
         * <p>
         * The identifier of a pool.
         * </p>
         * 
         * @param poolId
         *        The identifier of a pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolId(String poolId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the pool.
         * </p>
         * 
         * @param poolArn
         *        The Amazon Resource Name (ARN) for the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolArn(String poolArn);

        /**
         * <p>
         * The capacity status for the pool
         * </p>
         * 
         * @param capacityStatus
         *        The capacity status for the pool
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityStatus(CapacityStatus capacityStatus);

        /**
         * <p>
         * The capacity status for the pool
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacityStatus.Builder} avoiding the need
         * to create one manually via {@link CapacityStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #capacityStatus(CapacityStatus)}.
         * 
         * @param capacityStatus
         *        a consumer that will call methods on {@link CapacityStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityStatus(CapacityStatus)
         */
        default Builder capacityStatus(Consumer<CapacityStatus.Builder> capacityStatus) {
            return capacityStatus(CapacityStatus.builder().applyMutation(capacityStatus).build());
        }

        /**
         * <p>
         * The name of the pool.
         * </p>
         * 
         * @param poolName
         *        The name of the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolName(String poolName);

        /**
         * <p>
         * The description of the pool.
         * </p>
         * 
         * @param description
         *        The description of the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The current state of the pool.
         * </p>
         * 
         * @param state
         *        The current state of the pool.
         * @see WorkspacesPoolState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkspacesPoolState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the pool.
         * </p>
         * 
         * @param state
         *        The current state of the pool.
         * @see WorkspacesPoolState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkspacesPoolState
         */
        Builder state(WorkspacesPoolState state);

        /**
         * <p>
         * The time the pool was created.
         * </p>
         * 
         * @param createdAt
         *        The time the pool was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The identifier of the bundle used by the pool.
         * </p>
         * 
         * @param bundleId
         *        The identifier of the bundle used by the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        /**
         * <p>
         * The identifier of the directory used by the pool.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the directory used by the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The pool errors.
         * </p>
         * 
         * @param errors
         *        The pool errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<WorkspacesPoolError> errors);

        /**
         * <p>
         * The pool errors.
         * </p>
         * 
         * @param errors
         *        The pool errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(WorkspacesPoolError... errors);

        /**
         * <p>
         * The pool errors.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspaces.model.WorkspacesPoolError.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.workspaces.model.WorkspacesPoolError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspaces.model.WorkspacesPoolError.Builder#build()} is called
         * immediately and its result is passed to {@link #errors(List<WorkspacesPoolError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspaces.model.WorkspacesPoolError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<WorkspacesPoolError>)
         */
        Builder errors(Consumer<WorkspacesPoolError.Builder>... errors);

        /**
         * <p>
         * The persistent application settings for users of the pool.
         * </p>
         * 
         * @param applicationSettings
         *        The persistent application settings for users of the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSettings(ApplicationSettingsResponse applicationSettings);

        /**
         * <p>
         * The persistent application settings for users of the pool.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApplicationSettingsResponse.Builder}
         * avoiding the need to create one manually via {@link ApplicationSettingsResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationSettingsResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #applicationSettings(ApplicationSettingsResponse)}.
         * 
         * @param applicationSettings
         *        a consumer that will call methods on {@link ApplicationSettingsResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationSettings(ApplicationSettingsResponse)
         */
        default Builder applicationSettings(Consumer<ApplicationSettingsResponse.Builder> applicationSettings) {
            return applicationSettings(ApplicationSettingsResponse.builder().applyMutation(applicationSettings).build());
        }

        /**
         * <p>
         * The amount of time that a pool session remains active after users disconnect. If they try to reconnect to the
         * pool session after a disconnection or network interruption within this time interval, they are connected to
         * their previous session. Otherwise, they are connected to a new session with a new pool instance.
         * </p>
         * 
         * @param timeoutSettings
         *        The amount of time that a pool session remains active after users disconnect. If they try to reconnect
         *        to the pool session after a disconnection or network interruption within this time interval, they are
         *        connected to their previous session. Otherwise, they are connected to a new session with a new pool
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutSettings(TimeoutSettings timeoutSettings);

        /**
         * <p>
         * The amount of time that a pool session remains active after users disconnect. If they try to reconnect to the
         * pool session after a disconnection or network interruption within this time interval, they are connected to
         * their previous session. Otherwise, they are connected to a new session with a new pool instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeoutSettings.Builder} avoiding the
         * need to create one manually via {@link TimeoutSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeoutSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #timeoutSettings(TimeoutSettings)}.
         * 
         * @param timeoutSettings
         *        a consumer that will call methods on {@link TimeoutSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeoutSettings(TimeoutSettings)
         */
        default Builder timeoutSettings(Consumer<TimeoutSettings.Builder> timeoutSettings) {
            return timeoutSettings(TimeoutSettings.builder().applyMutation(timeoutSettings).build());
        }

        /**
         * <p>
         * The running mode of the pool.
         * </p>
         * 
         * @param runningMode
         *        The running mode of the pool.
         * @see PoolsRunningMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PoolsRunningMode
         */
        Builder runningMode(String runningMode);

        /**
         * <p>
         * The running mode of the pool.
         * </p>
         * 
         * @param runningMode
         *        The running mode of the pool.
         * @see PoolsRunningMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PoolsRunningMode
         */
        Builder runningMode(PoolsRunningMode runningMode);
    }

    static final class BuilderImpl implements Builder {
        private String poolId;

        private String poolArn;

        private CapacityStatus capacityStatus;

        private String poolName;

        private String description;

        private String state;

        private Instant createdAt;

        private String bundleId;

        private String directoryId;

        private List<WorkspacesPoolError> errors = DefaultSdkAutoConstructList.getInstance();

        private ApplicationSettingsResponse applicationSettings;

        private TimeoutSettings timeoutSettings;

        private String runningMode;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspacesPool model) {
            poolId(model.poolId);
            poolArn(model.poolArn);
            capacityStatus(model.capacityStatus);
            poolName(model.poolName);
            description(model.description);
            state(model.state);
            createdAt(model.createdAt);
            bundleId(model.bundleId);
            directoryId(model.directoryId);
            errors(model.errors);
            applicationSettings(model.applicationSettings);
            timeoutSettings(model.timeoutSettings);
            runningMode(model.runningMode);
        }

        public final String getPoolId() {
            return poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final String getPoolArn() {
            return poolArn;
        }

        public final void setPoolArn(String poolArn) {
            this.poolArn = poolArn;
        }

        @Override
        public final Builder poolArn(String poolArn) {
            this.poolArn = poolArn;
            return this;
        }

        public final CapacityStatus.Builder getCapacityStatus() {
            return capacityStatus != null ? capacityStatus.toBuilder() : null;
        }

        public final void setCapacityStatus(CapacityStatus.BuilderImpl capacityStatus) {
            this.capacityStatus = capacityStatus != null ? capacityStatus.build() : null;
        }

        @Override
        public final Builder capacityStatus(CapacityStatus capacityStatus) {
            this.capacityStatus = capacityStatus;
            return this;
        }

        public final String getPoolName() {
            return poolName;
        }

        public final void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        @Override
        public final Builder poolName(String poolName) {
            this.poolName = poolName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(WorkspacesPoolState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getBundleId() {
            return bundleId;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final List<WorkspacesPoolError.Builder> getErrors() {
            List<WorkspacesPoolError.Builder> result = WorkspacesPoolErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<WorkspacesPoolError.BuilderImpl> errors) {
            this.errors = WorkspacesPoolErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<WorkspacesPoolError> errors) {
            this.errors = WorkspacesPoolErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(WorkspacesPoolError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<WorkspacesPoolError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> WorkspacesPoolError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ApplicationSettingsResponse.Builder getApplicationSettings() {
            return applicationSettings != null ? applicationSettings.toBuilder() : null;
        }

        public final void setApplicationSettings(ApplicationSettingsResponse.BuilderImpl applicationSettings) {
            this.applicationSettings = applicationSettings != null ? applicationSettings.build() : null;
        }

        @Override
        public final Builder applicationSettings(ApplicationSettingsResponse applicationSettings) {
            this.applicationSettings = applicationSettings;
            return this;
        }

        public final TimeoutSettings.Builder getTimeoutSettings() {
            return timeoutSettings != null ? timeoutSettings.toBuilder() : null;
        }

        public final void setTimeoutSettings(TimeoutSettings.BuilderImpl timeoutSettings) {
            this.timeoutSettings = timeoutSettings != null ? timeoutSettings.build() : null;
        }

        @Override
        public final Builder timeoutSettings(TimeoutSettings timeoutSettings) {
            this.timeoutSettings = timeoutSettings;
            return this;
        }

        public final String getRunningMode() {
            return runningMode;
        }

        public final void setRunningMode(String runningMode) {
            this.runningMode = runningMode;
        }

        @Override
        public final Builder runningMode(String runningMode) {
            this.runningMode = runningMode;
            return this;
        }

        @Override
        public final Builder runningMode(PoolsRunningMode runningMode) {
            this.runningMode(runningMode == null ? null : runningMode.toString());
            return this;
        }

        @Override
        public WorkspacesPool build() {
            return new WorkspacesPool(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
