/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the enablement status, user access URL, and relay state parameter name that are used for configuring
 * federation with an SAML 2.0 identity provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SamlProperties implements SdkPojo, Serializable, ToCopyableBuilder<SamlProperties.Builder, SamlProperties> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(SamlProperties::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> USER_ACCESS_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserAccessUrl").getter(getter(SamlProperties::userAccessUrl)).setter(setter(Builder::userAccessUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAccessUrl").build()).build();

    private static final SdkField<String> RELAY_STATE_PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelayStateParameterName").getter(getter(SamlProperties::relayStateParameterName))
            .setter(setter(Builder::relayStateParameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelayStateParameterName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            USER_ACCESS_URL_FIELD, RELAY_STATE_PARAMETER_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String userAccessUrl;

    private final String relayStateParameterName;

    private SamlProperties(BuilderImpl builder) {
        this.status = builder.status;
        this.userAccessUrl = builder.userAccessUrl;
        this.relayStateParameterName = builder.relayStateParameterName;
    }

    /**
     * <p>
     * Indicates the status of SAML 2.0 authentication. These statuses include the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the setting is <code>DISABLED</code>, end users will be directed to login with their directory credentials.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the setting is <code>ENABLED</code>, end users will be directed to login via the user access URL. Users
     * attempting to connect to WorkSpaces from a client application that does not support SAML 2.0 authentication will
     * not be able to connect.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the setting is <code>ENABLED_WITH_DIRECTORY_LOGIN_FALLBACK</code>, end users will be directed to login via the
     * user access URL on supported client applications, but will not prevent clients that do not support SAML 2.0
     * authentication from connecting as if SAML 2.0 authentication was disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SamlStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of SAML 2.0 authentication. These statuses include the following.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the setting is <code>DISABLED</code>, end users will be directed to login with their directory
     *         credentials.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the setting is <code>ENABLED</code>, end users will be directed to login via the user access URL.
     *         Users attempting to connect to WorkSpaces from a client application that does not support SAML 2.0
     *         authentication will not be able to connect.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the setting is <code>ENABLED_WITH_DIRECTORY_LOGIN_FALLBACK</code>, end users will be directed to login
     *         via the user access URL on supported client applications, but will not prevent clients that do not
     *         support SAML 2.0 authentication from connecting as if SAML 2.0 authentication was disabled.
     *         </p>
     *         </li>
     * @see SamlStatusEnum
     */
    public final SamlStatusEnum status() {
        return SamlStatusEnum.fromValue(status);
    }

    /**
     * <p>
     * Indicates the status of SAML 2.0 authentication. These statuses include the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the setting is <code>DISABLED</code>, end users will be directed to login with their directory credentials.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the setting is <code>ENABLED</code>, end users will be directed to login via the user access URL. Users
     * attempting to connect to WorkSpaces from a client application that does not support SAML 2.0 authentication will
     * not be able to connect.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the setting is <code>ENABLED_WITH_DIRECTORY_LOGIN_FALLBACK</code>, end users will be directed to login via the
     * user access URL on supported client applications, but will not prevent clients that do not support SAML 2.0
     * authentication from connecting as if SAML 2.0 authentication was disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SamlStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of SAML 2.0 authentication. These statuses include the following.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the setting is <code>DISABLED</code>, end users will be directed to login with their directory
     *         credentials.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the setting is <code>ENABLED</code>, end users will be directed to login via the user access URL.
     *         Users attempting to connect to WorkSpaces from a client application that does not support SAML 2.0
     *         authentication will not be able to connect.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the setting is <code>ENABLED_WITH_DIRECTORY_LOGIN_FALLBACK</code>, end users will be directed to login
     *         via the user access URL on supported client applications, but will not prevent clients that do not
     *         support SAML 2.0 authentication from connecting as if SAML 2.0 authentication was disabled.
     *         </p>
     *         </li>
     * @see SamlStatusEnum
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The SAML 2.0 identity provider (IdP) user access URL is the URL a user would navigate to in their web browser in
     * order to federate from the IdP and directly access the application, without any SAML 2.0 service provider (SP)
     * bindings.
     * </p>
     * 
     * @return The SAML 2.0 identity provider (IdP) user access URL is the URL a user would navigate to in their web
     *         browser in order to federate from the IdP and directly access the application, without any SAML 2.0
     *         service provider (SP) bindings.
     */
    public final String userAccessUrl() {
        return userAccessUrl;
    }

    /**
     * <p>
     * The relay state parameter name supported by the SAML 2.0 identity provider (IdP). When the end user is redirected
     * to the user access URL from the WorkSpaces client application, this relay state parameter name is appended as a
     * query parameter to the URL along with the relay state endpoint to return the user to the client application
     * session.
     * </p>
     * <p>
     * To use SAML 2.0 authentication with WorkSpaces, the IdP must support IdP-initiated deep linking for the relay
     * state URL. Consult your IdP documentation for more information.
     * </p>
     * 
     * @return The relay state parameter name supported by the SAML 2.0 identity provider (IdP). When the end user is
     *         redirected to the user access URL from the WorkSpaces client application, this relay state parameter name
     *         is appended as a query parameter to the URL along with the relay state endpoint to return the user to the
     *         client application session.</p>
     *         <p>
     *         To use SAML 2.0 authentication with WorkSpaces, the IdP must support IdP-initiated deep linking for the
     *         relay state URL. Consult your IdP documentation for more information.
     */
    public final String relayStateParameterName() {
        return relayStateParameterName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userAccessUrl());
        hashCode = 31 * hashCode + Objects.hashCode(relayStateParameterName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamlProperties)) {
            return false;
        }
        SamlProperties other = (SamlProperties) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(userAccessUrl(), other.userAccessUrl())
                && Objects.equals(relayStateParameterName(), other.relayStateParameterName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SamlProperties").add("Status", statusAsString()).add("UserAccessUrl", userAccessUrl())
                .add("RelayStateParameterName", relayStateParameterName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "UserAccessUrl":
            return Optional.ofNullable(clazz.cast(userAccessUrl()));
        case "RelayStateParameterName":
            return Optional.ofNullable(clazz.cast(relayStateParameterName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("UserAccessUrl", USER_ACCESS_URL_FIELD);
        map.put("RelayStateParameterName", RELAY_STATE_PARAMETER_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SamlProperties, T> g) {
        return obj -> g.apply((SamlProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SamlProperties> {
        /**
         * <p>
         * Indicates the status of SAML 2.0 authentication. These statuses include the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the setting is <code>DISABLED</code>, end users will be directed to login with their directory
         * credentials.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the setting is <code>ENABLED</code>, end users will be directed to login via the user access URL. Users
         * attempting to connect to WorkSpaces from a client application that does not support SAML 2.0 authentication
         * will not be able to connect.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the setting is <code>ENABLED_WITH_DIRECTORY_LOGIN_FALLBACK</code>, end users will be directed to login via
         * the user access URL on supported client applications, but will not prevent clients that do not support SAML
         * 2.0 authentication from connecting as if SAML 2.0 authentication was disabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Indicates the status of SAML 2.0 authentication. These statuses include the following.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the setting is <code>DISABLED</code>, end users will be directed to login with their directory
         *        credentials.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the setting is <code>ENABLED</code>, end users will be directed to login via the user access URL.
         *        Users attempting to connect to WorkSpaces from a client application that does not support SAML 2.0
         *        authentication will not be able to connect.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the setting is <code>ENABLED_WITH_DIRECTORY_LOGIN_FALLBACK</code>, end users will be directed to
         *        login via the user access URL on supported client applications, but will not prevent clients that do
         *        not support SAML 2.0 authentication from connecting as if SAML 2.0 authentication was disabled.
         *        </p>
         *        </li>
         * @see SamlStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SamlStatusEnum
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates the status of SAML 2.0 authentication. These statuses include the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the setting is <code>DISABLED</code>, end users will be directed to login with their directory
         * credentials.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the setting is <code>ENABLED</code>, end users will be directed to login via the user access URL. Users
         * attempting to connect to WorkSpaces from a client application that does not support SAML 2.0 authentication
         * will not be able to connect.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the setting is <code>ENABLED_WITH_DIRECTORY_LOGIN_FALLBACK</code>, end users will be directed to login via
         * the user access URL on supported client applications, but will not prevent clients that do not support SAML
         * 2.0 authentication from connecting as if SAML 2.0 authentication was disabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Indicates the status of SAML 2.0 authentication. These statuses include the following.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the setting is <code>DISABLED</code>, end users will be directed to login with their directory
         *        credentials.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the setting is <code>ENABLED</code>, end users will be directed to login via the user access URL.
         *        Users attempting to connect to WorkSpaces from a client application that does not support SAML 2.0
         *        authentication will not be able to connect.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the setting is <code>ENABLED_WITH_DIRECTORY_LOGIN_FALLBACK</code>, end users will be directed to
         *        login via the user access URL on supported client applications, but will not prevent clients that do
         *        not support SAML 2.0 authentication from connecting as if SAML 2.0 authentication was disabled.
         *        </p>
         *        </li>
         * @see SamlStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SamlStatusEnum
         */
        Builder status(SamlStatusEnum status);

        /**
         * <p>
         * The SAML 2.0 identity provider (IdP) user access URL is the URL a user would navigate to in their web browser
         * in order to federate from the IdP and directly access the application, without any SAML 2.0 service provider
         * (SP) bindings.
         * </p>
         * 
         * @param userAccessUrl
         *        The SAML 2.0 identity provider (IdP) user access URL is the URL a user would navigate to in their web
         *        browser in order to federate from the IdP and directly access the application, without any SAML 2.0
         *        service provider (SP) bindings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAccessUrl(String userAccessUrl);

        /**
         * <p>
         * The relay state parameter name supported by the SAML 2.0 identity provider (IdP). When the end user is
         * redirected to the user access URL from the WorkSpaces client application, this relay state parameter name is
         * appended as a query parameter to the URL along with the relay state endpoint to return the user to the client
         * application session.
         * </p>
         * <p>
         * To use SAML 2.0 authentication with WorkSpaces, the IdP must support IdP-initiated deep linking for the relay
         * state URL. Consult your IdP documentation for more information.
         * </p>
         * 
         * @param relayStateParameterName
         *        The relay state parameter name supported by the SAML 2.0 identity provider (IdP). When the end user is
         *        redirected to the user access URL from the WorkSpaces client application, this relay state parameter
         *        name is appended as a query parameter to the URL along with the relay state endpoint to return the
         *        user to the client application session.</p>
         *        <p>
         *        To use SAML 2.0 authentication with WorkSpaces, the IdP must support IdP-initiated deep linking for
         *        the relay state URL. Consult your IdP documentation for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relayStateParameterName(String relayStateParameterName);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String userAccessUrl;

        private String relayStateParameterName;

        private BuilderImpl() {
        }

        private BuilderImpl(SamlProperties model) {
            status(model.status);
            userAccessUrl(model.userAccessUrl);
            relayStateParameterName(model.relayStateParameterName);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SamlStatusEnum status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getUserAccessUrl() {
            return userAccessUrl;
        }

        public final void setUserAccessUrl(String userAccessUrl) {
            this.userAccessUrl = userAccessUrl;
        }

        @Override
        public final Builder userAccessUrl(String userAccessUrl) {
            this.userAccessUrl = userAccessUrl;
            return this;
        }

        public final String getRelayStateParameterName() {
            return relayStateParameterName;
        }

        public final void setRelayStateParameterName(String relayStateParameterName) {
            this.relayStateParameterName = relayStateParameterName;
        }

        @Override
        public final Builder relayStateParameterName(String relayStateParameterName) {
            this.relayStateParameterName = relayStateParameterName;
            return this;
        }

        @Override
        public SamlProperties build() {
            return new SamlProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
