/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyStreamingPropertiesRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<ModifyStreamingPropertiesRequest.Builder, ModifyStreamingPropertiesRequest> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(ModifyStreamingPropertiesRequest::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<StreamingProperties> STREAMING_PROPERTIES_FIELD = SdkField
            .<StreamingProperties> builder(MarshallingType.SDK_POJO).memberName("StreamingProperties")
            .getter(getter(ModifyStreamingPropertiesRequest::streamingProperties)).setter(setter(Builder::streamingProperties))
            .constructor(StreamingProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            STREAMING_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceId;

    private final StreamingProperties streamingProperties;

    private ModifyStreamingPropertiesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.streamingProperties = builder.streamingProperties;
    }

    /**
     * <p>
     * The identifier of the resource.
     * </p>
     * 
     * @return The identifier of the resource.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The streaming properties to configure.
     * </p>
     * 
     * @return The streaming properties to configure.
     */
    public final StreamingProperties streamingProperties() {
        return streamingProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(streamingProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyStreamingPropertiesRequest)) {
            return false;
        }
        ModifyStreamingPropertiesRequest other = (ModifyStreamingPropertiesRequest) obj;
        return Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(streamingProperties(), other.streamingProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyStreamingPropertiesRequest").add("ResourceId", resourceId())
                .add("StreamingProperties", streamingProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "StreamingProperties":
            return Optional.ofNullable(clazz.cast(streamingProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("StreamingProperties", STREAMING_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyStreamingPropertiesRequest, T> g) {
        return obj -> g.apply((ModifyStreamingPropertiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyStreamingPropertiesRequest> {
        /**
         * <p>
         * The identifier of the resource.
         * </p>
         * 
         * @param resourceId
         *        The identifier of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The streaming properties to configure.
         * </p>
         * 
         * @param streamingProperties
         *        The streaming properties to configure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingProperties(StreamingProperties streamingProperties);

        /**
         * <p>
         * The streaming properties to configure.
         * </p>
         * This is a convenience method that creates an instance of the {@link StreamingProperties.Builder} avoiding the
         * need to create one manually via {@link StreamingProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StreamingProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #streamingProperties(StreamingProperties)}.
         * 
         * @param streamingProperties
         *        a consumer that will call methods on {@link StreamingProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamingProperties(StreamingProperties)
         */
        default Builder streamingProperties(Consumer<StreamingProperties.Builder> streamingProperties) {
            return streamingProperties(StreamingProperties.builder().applyMutation(streamingProperties).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String resourceId;

        private StreamingProperties streamingProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyStreamingPropertiesRequest model) {
            super(model);
            resourceId(model.resourceId);
            streamingProperties(model.streamingProperties);
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final StreamingProperties.Builder getStreamingProperties() {
            return streamingProperties != null ? streamingProperties.toBuilder() : null;
        }

        public final void setStreamingProperties(StreamingProperties.BuilderImpl streamingProperties) {
            this.streamingProperties = streamingProperties != null ? streamingProperties.build() : null;
        }

        @Override
        public final Builder streamingProperties(StreamingProperties streamingProperties) {
            this.streamingProperties = streamingProperties;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyStreamingPropertiesRequest build() {
            return new ModifyStreamingPropertiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
