/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The client branding attributes for iOS device types. These attributes are displayed on the iOS client login screen
 * only.
 * </p>
 * <important>
 * <p>
 * Client branding attributes are public facing. Ensure you do not include sensitive information.
 * </p>
 * </important>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IosClientBrandingAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<IosClientBrandingAttributes.Builder, IosClientBrandingAttributes> {
    private static final SdkField<String> LOGO_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogoUrl").getter(getter(IosClientBrandingAttributes::logoUrl)).setter(setter(Builder::logoUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogoUrl").build()).build();

    private static final SdkField<String> LOGO2_X_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Logo2xUrl").getter(getter(IosClientBrandingAttributes::logo2xUrl)).setter(setter(Builder::logo2xUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Logo2xUrl").build()).build();

    private static final SdkField<String> LOGO3_X_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Logo3xUrl").getter(getter(IosClientBrandingAttributes::logo3xUrl)).setter(setter(Builder::logo3xUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Logo3xUrl").build()).build();

    private static final SdkField<String> SUPPORT_EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SupportEmail").getter(getter(IosClientBrandingAttributes::supportEmail))
            .setter(setter(Builder::supportEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportEmail").build()).build();

    private static final SdkField<String> SUPPORT_LINK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SupportLink").getter(getter(IosClientBrandingAttributes::supportLink))
            .setter(setter(Builder::supportLink))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportLink").build()).build();

    private static final SdkField<String> FORGOT_PASSWORD_LINK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ForgotPasswordLink").getter(getter(IosClientBrandingAttributes::forgotPasswordLink))
            .setter(setter(Builder::forgotPasswordLink))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForgotPasswordLink").build())
            .build();

    private static final SdkField<Map<String, String>> LOGIN_MESSAGE_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("LoginMessage")
            .getter(getter(IosClientBrandingAttributes::loginMessage))
            .setter(setter(Builder::loginMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoginMessage").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGO_URL_FIELD,
            LOGO2_X_URL_FIELD, LOGO3_X_URL_FIELD, SUPPORT_EMAIL_FIELD, SUPPORT_LINK_FIELD, FORGOT_PASSWORD_LINK_FIELD,
            LOGIN_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String logoUrl;

    private final String logo2xUrl;

    private final String logo3xUrl;

    private final String supportEmail;

    private final String supportLink;

    private final String forgotPasswordLink;

    private final Map<String, String> loginMessage;

    private IosClientBrandingAttributes(BuilderImpl builder) {
        this.logoUrl = builder.logoUrl;
        this.logo2xUrl = builder.logo2xUrl;
        this.logo3xUrl = builder.logo3xUrl;
        this.supportEmail = builder.supportEmail;
        this.supportLink = builder.supportLink;
        this.forgotPasswordLink = builder.forgotPasswordLink;
        this.loginMessage = builder.loginMessage;
    }

    /**
     * <p>
     * The logo. This is the standard-resolution display that has a 1:1 pixel density (or @1x), where one pixel is equal
     * to one point. The only image format accepted is a binary data object that is converted from a <code>.png</code>
     * file.
     * </p>
     * 
     * @return The logo. This is the standard-resolution display that has a 1:1 pixel density (or @1x), where one pixel
     *         is equal to one point. The only image format accepted is a binary data object that is converted from a
     *         <code>.png</code> file.
     */
    public final String logoUrl() {
        return logoUrl;
    }

    /**
     * <p>
     * The @2x version of the logo. This is the higher resolution display that offers a scale factor of 2.0 (or @2x).
     * The only image format accepted is a binary data object that is converted from a <code>.png</code> file.
     * </p>
     * <note>
     * <p>
     * For more information about iOS image size and resolution, see <a href=
     * "https://developer.apple.com/design/human-interface-guidelines/ios/icons-and-images/image-size-and-resolution/"
     * >Image Size and Resolution </a> in the <i>Apple Human Interface Guidelines</i>.
     * </p>
     * </note>
     * 
     * @return The @2x version of the logo. This is the higher resolution display that offers a scale factor of 2.0 (or
     *         @2x). The only image format accepted is a binary data object that is converted from a <code>.png</code>
     *         file.</p> <note>
     *         <p>
     *         For more information about iOS image size and resolution, see <a href=
     *         "https://developer.apple.com/design/human-interface-guidelines/ios/icons-and-images/image-size-and-resolution/"
     *         >Image Size and Resolution </a> in the <i>Apple Human Interface Guidelines</i>.
     *         </p>
     */
    public final String logo2xUrl() {
        return logo2xUrl;
    }

    /**
     * <p>
     * The @3x version of the logo. This is the higher resolution display that offers a scale factor of 3.0 (or @3x).The
     * only image format accepted is a binary data object that is converted from a <code>.png</code> file.
     * </p>
     * <note>
     * <p>
     * For more information about iOS image size and resolution, see <a href=
     * "https://developer.apple.com/design/human-interface-guidelines/ios/icons-and-images/image-size-and-resolution/"
     * >Image Size and Resolution </a> in the <i>Apple Human Interface Guidelines</i>.
     * </p>
     * </note>
     * 
     * @return The @3x version of the logo. This is the higher resolution display that offers a scale factor of 3.0 (or
     *         @3x).The only image format accepted is a binary data object that is converted from a <code>.png</code>
     *         file.</p> <note>
     *         <p>
     *         For more information about iOS image size and resolution, see <a href=
     *         "https://developer.apple.com/design/human-interface-guidelines/ios/icons-and-images/image-size-and-resolution/"
     *         >Image Size and Resolution </a> in the <i>Apple Human Interface Guidelines</i>.
     *         </p>
     */
    public final String logo3xUrl() {
        return logo3xUrl;
    }

    /**
     * <p>
     * The support email. The company's customer support email address.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are mutually
     * exclusive. You can specify one parameter for each platform type, but not both.
     * </p>
     * </li>
     * <li>
     * <p>
     * The default email is <code>workspaces-feedback@amazon.com</code>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * 
     * @return The support email. The company's customer support email address.</p> <note>
     *         <ul>
     *         <li>
     *         <p>
     *         In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are mutually
     *         exclusive. You can specify one parameter for each platform type, but not both.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The default email is <code>workspaces-feedback@amazon.com</code>.
     *         </p>
     *         </li>
     *         </ul>
     */
    public final String supportEmail() {
        return supportEmail;
    }

    /**
     * <p>
     * The support link. The link for the company's customer support page for their WorkSpace.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are mutually
     * exclusive. You can specify one parameter for each platform type, but not both.
     * </p>
     * </li>
     * <li>
     * <p>
     * The default support link is <code>workspaces-feedback@amazon.com</code>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * 
     * @return The support link. The link for the company's customer support page for their WorkSpace.</p> <note>
     *         <ul>
     *         <li>
     *         <p>
     *         In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are mutually
     *         exclusive. You can specify one parameter for each platform type, but not both.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The default support link is <code>workspaces-feedback@amazon.com</code>.
     *         </p>
     *         </li>
     *         </ul>
     */
    public final String supportLink() {
        return supportLink;
    }

    /**
     * <p>
     * The forgotten password link. This is the web address that users can go to if they forget the password for their
     * WorkSpace.
     * </p>
     * 
     * @return The forgotten password link. This is the web address that users can go to if they forget the password for
     *         their WorkSpace.
     */
    public final String forgotPasswordLink() {
        return forgotPasswordLink;
    }

    /**
     * For responses, this returns true if the service returned a value for the LoginMessage property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLoginMessage() {
        return loginMessage != null && !(loginMessage instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The login message. Specified as a key value pair, in which the key is a locale and the value is the localized
     * message for that locale. The only key supported is <code>en_US</code>. The HTML tags supported include the
     * following:
     * <code>a, b, blockquote, br, cite, code, dd, dl, dt, div, em, i, li, ol, p, pre, q, small, span, strike, strong, sub, sup, u, ul</code>
     * .
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLoginMessage} method.
     * </p>
     * 
     * @return The login message. Specified as a key value pair, in which the key is a locale and the value is the
     *         localized message for that locale. The only key supported is <code>en_US</code>. The HTML tags supported
     *         include the following:
     *         <code>a, b, blockquote, br, cite, code, dd, dl, dt, div, em, i, li, ol, p, pre, q, small, span, strike, strong, sub, sup, u, ul</code>
     *         .
     */
    public final Map<String, String> loginMessage() {
        return loginMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logoUrl());
        hashCode = 31 * hashCode + Objects.hashCode(logo2xUrl());
        hashCode = 31 * hashCode + Objects.hashCode(logo3xUrl());
        hashCode = 31 * hashCode + Objects.hashCode(supportEmail());
        hashCode = 31 * hashCode + Objects.hashCode(supportLink());
        hashCode = 31 * hashCode + Objects.hashCode(forgotPasswordLink());
        hashCode = 31 * hashCode + Objects.hashCode(hasLoginMessage() ? loginMessage() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IosClientBrandingAttributes)) {
            return false;
        }
        IosClientBrandingAttributes other = (IosClientBrandingAttributes) obj;
        return Objects.equals(logoUrl(), other.logoUrl()) && Objects.equals(logo2xUrl(), other.logo2xUrl())
                && Objects.equals(logo3xUrl(), other.logo3xUrl()) && Objects.equals(supportEmail(), other.supportEmail())
                && Objects.equals(supportLink(), other.supportLink())
                && Objects.equals(forgotPasswordLink(), other.forgotPasswordLink())
                && hasLoginMessage() == other.hasLoginMessage() && Objects.equals(loginMessage(), other.loginMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IosClientBrandingAttributes").add("LogoUrl", logoUrl()).add("Logo2xUrl", logo2xUrl())
                .add("Logo3xUrl", logo3xUrl()).add("SupportEmail", supportEmail()).add("SupportLink", supportLink())
                .add("ForgotPasswordLink", forgotPasswordLink()).add("LoginMessage", hasLoginMessage() ? loginMessage() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogoUrl":
            return Optional.ofNullable(clazz.cast(logoUrl()));
        case "Logo2xUrl":
            return Optional.ofNullable(clazz.cast(logo2xUrl()));
        case "Logo3xUrl":
            return Optional.ofNullable(clazz.cast(logo3xUrl()));
        case "SupportEmail":
            return Optional.ofNullable(clazz.cast(supportEmail()));
        case "SupportLink":
            return Optional.ofNullable(clazz.cast(supportLink()));
        case "ForgotPasswordLink":
            return Optional.ofNullable(clazz.cast(forgotPasswordLink()));
        case "LoginMessage":
            return Optional.ofNullable(clazz.cast(loginMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LogoUrl", LOGO_URL_FIELD);
        map.put("Logo2xUrl", LOGO2_X_URL_FIELD);
        map.put("Logo3xUrl", LOGO3_X_URL_FIELD);
        map.put("SupportEmail", SUPPORT_EMAIL_FIELD);
        map.put("SupportLink", SUPPORT_LINK_FIELD);
        map.put("ForgotPasswordLink", FORGOT_PASSWORD_LINK_FIELD);
        map.put("LoginMessage", LOGIN_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IosClientBrandingAttributes, T> g) {
        return obj -> g.apply((IosClientBrandingAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IosClientBrandingAttributes> {
        /**
         * <p>
         * The logo. This is the standard-resolution display that has a 1:1 pixel density (or @1x), where one pixel is
         * equal to one point. The only image format accepted is a binary data object that is converted from a
         * <code>.png</code> file.
         * </p>
         * 
         * @param logoUrl
         *        The logo. This is the standard-resolution display that has a 1:1 pixel density (or @1x), where one
         *        pixel is equal to one point. The only image format accepted is a binary data object that is converted
         *        from a <code>.png</code> file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logoUrl(String logoUrl);

        /**
         * <p>
         * The @2x version of the logo. This is the higher resolution display that offers a scale factor of 2.0 (or
         * @2x). The only image format accepted is a binary data object that is converted from a <code>.png</code> file.
         * </p>
         * <note>
         * <p>
         * For more information about iOS image size and resolution, see <a href=
         * "https://developer.apple.com/design/human-interface-guidelines/ios/icons-and-images/image-size-and-resolution/"
         * >Image Size and Resolution </a> in the <i>Apple Human Interface Guidelines</i>.
         * </p>
         * </note>
         * 
         * @param logo2xUrl
         *        The @2x version of the logo. This is the higher resolution display that offers a scale factor of 2.0
         *        (or @2x). The only image format accepted is a binary data object that is converted from a
         *        <code>.png</code> file.</p> <note>
         *        <p>
         *        For more information about iOS image size and resolution, see <a href=
         *        "https://developer.apple.com/design/human-interface-guidelines/ios/icons-and-images/image-size-and-resolution/"
         *        >Image Size and Resolution </a> in the <i>Apple Human Interface Guidelines</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logo2xUrl(String logo2xUrl);

        /**
         * <p>
         * The @3x version of the logo. This is the higher resolution display that offers a scale factor of 3.0 (or
         * @3x).The only image format accepted is a binary data object that is converted from a <code>.png</code> file.
         * </p>
         * <note>
         * <p>
         * For more information about iOS image size and resolution, see <a href=
         * "https://developer.apple.com/design/human-interface-guidelines/ios/icons-and-images/image-size-and-resolution/"
         * >Image Size and Resolution </a> in the <i>Apple Human Interface Guidelines</i>.
         * </p>
         * </note>
         * 
         * @param logo3xUrl
         *        The @3x version of the logo. This is the higher resolution display that offers a scale factor of 3.0
         *        (or @3x).The only image format accepted is a binary data object that is converted from a
         *        <code>.png</code> file.</p> <note>
         *        <p>
         *        For more information about iOS image size and resolution, see <a href=
         *        "https://developer.apple.com/design/human-interface-guidelines/ios/icons-and-images/image-size-and-resolution/"
         *        >Image Size and Resolution </a> in the <i>Apple Human Interface Guidelines</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logo3xUrl(String logo3xUrl);

        /**
         * <p>
         * The support email. The company's customer support email address.
         * </p>
         * <note>
         * <ul>
         * <li>
         * <p>
         * In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are mutually
         * exclusive. You can specify one parameter for each platform type, but not both.
         * </p>
         * </li>
         * <li>
         * <p>
         * The default email is <code>workspaces-feedback@amazon.com</code>.
         * </p>
         * </li>
         * </ul>
         * </note>
         * 
         * @param supportEmail
         *        The support email. The company's customer support email address.</p> <note>
         *        <ul>
         *        <li>
         *        <p>
         *        In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are
         *        mutually exclusive. You can specify one parameter for each platform type, but not both.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The default email is <code>workspaces-feedback@amazon.com</code>.
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportEmail(String supportEmail);

        /**
         * <p>
         * The support link. The link for the company's customer support page for their WorkSpace.
         * </p>
         * <note>
         * <ul>
         * <li>
         * <p>
         * In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are mutually
         * exclusive. You can specify one parameter for each platform type, but not both.
         * </p>
         * </li>
         * <li>
         * <p>
         * The default support link is <code>workspaces-feedback@amazon.com</code>.
         * </p>
         * </li>
         * </ul>
         * </note>
         * 
         * @param supportLink
         *        The support link. The link for the company's customer support page for their WorkSpace.</p> <note>
         *        <ul>
         *        <li>
         *        <p>
         *        In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are
         *        mutually exclusive. You can specify one parameter for each platform type, but not both.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The default support link is <code>workspaces-feedback@amazon.com</code>.
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportLink(String supportLink);

        /**
         * <p>
         * The forgotten password link. This is the web address that users can go to if they forget the password for
         * their WorkSpace.
         * </p>
         * 
         * @param forgotPasswordLink
         *        The forgotten password link. This is the web address that users can go to if they forget the password
         *        for their WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forgotPasswordLink(String forgotPasswordLink);

        /**
         * <p>
         * The login message. Specified as a key value pair, in which the key is a locale and the value is the localized
         * message for that locale. The only key supported is <code>en_US</code>. The HTML tags supported include the
         * following:
         * <code>a, b, blockquote, br, cite, code, dd, dl, dt, div, em, i, li, ol, p, pre, q, small, span, strike, strong, sub, sup, u, ul</code>
         * .
         * </p>
         * 
         * @param loginMessage
         *        The login message. Specified as a key value pair, in which the key is a locale and the value is the
         *        localized message for that locale. The only key supported is <code>en_US</code>. The HTML tags
         *        supported include the following:
         *        <code>a, b, blockquote, br, cite, code, dd, dl, dt, div, em, i, li, ol, p, pre, q, small, span, strike, strong, sub, sup, u, ul</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loginMessage(Map<String, String> loginMessage);
    }

    static final class BuilderImpl implements Builder {
        private String logoUrl;

        private String logo2xUrl;

        private String logo3xUrl;

        private String supportEmail;

        private String supportLink;

        private String forgotPasswordLink;

        private Map<String, String> loginMessage = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IosClientBrandingAttributes model) {
            logoUrl(model.logoUrl);
            logo2xUrl(model.logo2xUrl);
            logo3xUrl(model.logo3xUrl);
            supportEmail(model.supportEmail);
            supportLink(model.supportLink);
            forgotPasswordLink(model.forgotPasswordLink);
            loginMessage(model.loginMessage);
        }

        public final String getLogoUrl() {
            return logoUrl;
        }

        public final void setLogoUrl(String logoUrl) {
            this.logoUrl = logoUrl;
        }

        @Override
        public final Builder logoUrl(String logoUrl) {
            this.logoUrl = logoUrl;
            return this;
        }

        public final String getLogo2xUrl() {
            return logo2xUrl;
        }

        public final void setLogo2xUrl(String logo2xUrl) {
            this.logo2xUrl = logo2xUrl;
        }

        @Override
        public final Builder logo2xUrl(String logo2xUrl) {
            this.logo2xUrl = logo2xUrl;
            return this;
        }

        public final String getLogo3xUrl() {
            return logo3xUrl;
        }

        public final void setLogo3xUrl(String logo3xUrl) {
            this.logo3xUrl = logo3xUrl;
        }

        @Override
        public final Builder logo3xUrl(String logo3xUrl) {
            this.logo3xUrl = logo3xUrl;
            return this;
        }

        public final String getSupportEmail() {
            return supportEmail;
        }

        public final void setSupportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
        }

        @Override
        public final Builder supportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
            return this;
        }

        public final String getSupportLink() {
            return supportLink;
        }

        public final void setSupportLink(String supportLink) {
            this.supportLink = supportLink;
        }

        @Override
        public final Builder supportLink(String supportLink) {
            this.supportLink = supportLink;
            return this;
        }

        public final String getForgotPasswordLink() {
            return forgotPasswordLink;
        }

        public final void setForgotPasswordLink(String forgotPasswordLink) {
            this.forgotPasswordLink = forgotPasswordLink;
        }

        @Override
        public final Builder forgotPasswordLink(String forgotPasswordLink) {
            this.forgotPasswordLink = forgotPasswordLink;
            return this;
        }

        public final Map<String, String> getLoginMessage() {
            if (loginMessage instanceof SdkAutoConstructMap) {
                return null;
            }
            return loginMessage;
        }

        public final void setLoginMessage(Map<String, String> loginMessage) {
            this.loginMessage = LoginMessageCopier.copy(loginMessage);
        }

        @Override
        public final Builder loginMessage(Map<String, String> loginMessage) {
            this.loginMessage = LoginMessageCopier.copy(loginMessage);
            return this;
        }

        @Override
        public IosClientBrandingAttributes build() {
            return new IosClientBrandingAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
