/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWorkspacesPoolSessionsRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<DescribeWorkspacesPoolSessionsRequest.Builder, DescribeWorkspacesPoolSessionsRequest> {
    private static final SdkField<String> POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PoolId")
            .getter(getter(DescribeWorkspacesPoolSessionsRequest::poolId)).setter(setter(Builder::poolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(DescribeWorkspacesPoolSessionsRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(DescribeWorkspacesPoolSessionsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeWorkspacesPoolSessionsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_ID_FIELD, USER_ID_FIELD,
            LIMIT_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String poolId;

    private final String userId;

    private final Integer limit;

    private final String nextToken;

    private DescribeWorkspacesPoolSessionsRequest(BuilderImpl builder) {
        super(builder);
        this.poolId = builder.poolId;
        this.userId = builder.userId;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The identifier of the pool.
     * </p>
     * 
     * @return The identifier of the pool.
     */
    public final String poolId() {
        return poolId;
    }

    /**
     * <p>
     * The identifier of the user.
     * </p>
     * 
     * @return The identifier of the user.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The maximum size of each page of results. The default value is 20 and the maximum value is 50.
     * </p>
     * 
     * @return The maximum size of each page of results. The default value is 20 and the maximum value is 50.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive
     * the next set of results.
     * </p>
     * 
     * @return If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to
     *         receive the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(poolId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspacesPoolSessionsRequest)) {
            return false;
        }
        DescribeWorkspacesPoolSessionsRequest other = (DescribeWorkspacesPoolSessionsRequest) obj;
        return Objects.equals(poolId(), other.poolId()) && Objects.equals(userId(), other.userId())
                && Objects.equals(limit(), other.limit()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWorkspacesPoolSessionsRequest").add("PoolId", poolId()).add("UserId", userId())
                .add("Limit", limit()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PoolId":
            return Optional.ofNullable(clazz.cast(poolId()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PoolId", POOL_ID_FIELD);
        map.put("UserId", USER_ID_FIELD);
        map.put("Limit", LIMIT_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspacesPoolSessionsRequest, T> g) {
        return obj -> g.apply((DescribeWorkspacesPoolSessionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeWorkspacesPoolSessionsRequest> {
        /**
         * <p>
         * The identifier of the pool.
         * </p>
         * 
         * @param poolId
         *        The identifier of the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolId(String poolId);

        /**
         * <p>
         * The identifier of the user.
         * </p>
         * 
         * @param userId
         *        The identifier of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The maximum size of each page of results. The default value is 20 and the maximum value is 50.
         * </p>
         * 
         * @param limit
         *        The maximum size of each page of results. The default value is 20 and the maximum value is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to
         * receive the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If you received a <code>NextToken</code> from a previous call that was paginated, provide this token
         *        to receive the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String poolId;

        private String userId;

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspacesPoolSessionsRequest model) {
            super(model);
            poolId(model.poolId);
            userId(model.userId);
            limit(model.limit);
            nextToken(model.nextToken);
        }

        public final String getPoolId() {
            return poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeWorkspacesPoolSessionsRequest build() {
            return new DescribeWorkspacesPoolSessionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
