/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWorkspacesConnectionStatusResponse extends WorkSpacesResponse implements
        ToCopyableBuilder<DescribeWorkspacesConnectionStatusResponse.Builder, DescribeWorkspacesConnectionStatusResponse> {
    private static final SdkField<List<WorkspaceConnectionStatus>> WORKSPACES_CONNECTION_STATUS_FIELD = SdkField
            .<List<WorkspaceConnectionStatus>> builder(MarshallingType.LIST)
            .memberName("WorkspacesConnectionStatus")
            .getter(getter(DescribeWorkspacesConnectionStatusResponse::workspacesConnectionStatus))
            .setter(setter(Builder::workspacesConnectionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspacesConnectionStatus").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkspaceConnectionStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkspaceConnectionStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeWorkspacesConnectionStatusResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            WORKSPACES_CONNECTION_STATUS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<WorkspaceConnectionStatus> workspacesConnectionStatus;

    private final String nextToken;

    private DescribeWorkspacesConnectionStatusResponse(BuilderImpl builder) {
        super(builder);
        this.workspacesConnectionStatus = builder.workspacesConnectionStatus;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkspacesConnectionStatus property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasWorkspacesConnectionStatus() {
        return workspacesConnectionStatus != null && !(workspacesConnectionStatus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the connection status of the WorkSpace.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkspacesConnectionStatus} method.
     * </p>
     * 
     * @return Information about the connection status of the WorkSpace.
     */
    public final List<WorkspaceConnectionStatus> workspacesConnectionStatus() {
        return workspacesConnectionStatus;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is null when there are no more results to
     * return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is null when there are no more results
     *         to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkspacesConnectionStatus() ? workspacesConnectionStatus() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspacesConnectionStatusResponse)) {
            return false;
        }
        DescribeWorkspacesConnectionStatusResponse other = (DescribeWorkspacesConnectionStatusResponse) obj;
        return hasWorkspacesConnectionStatus() == other.hasWorkspacesConnectionStatus()
                && Objects.equals(workspacesConnectionStatus(), other.workspacesConnectionStatus())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWorkspacesConnectionStatusResponse")
                .add("WorkspacesConnectionStatus", hasWorkspacesConnectionStatus() ? workspacesConnectionStatus() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkspacesConnectionStatus":
            return Optional.ofNullable(clazz.cast(workspacesConnectionStatus()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkspacesConnectionStatus", WORKSPACES_CONNECTION_STATUS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspacesConnectionStatusResponse, T> g) {
        return obj -> g.apply((DescribeWorkspacesConnectionStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeWorkspacesConnectionStatusResponse> {
        /**
         * <p>
         * Information about the connection status of the WorkSpace.
         * </p>
         * 
         * @param workspacesConnectionStatus
         *        Information about the connection status of the WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspacesConnectionStatus(Collection<WorkspaceConnectionStatus> workspacesConnectionStatus);

        /**
         * <p>
         * Information about the connection status of the WorkSpace.
         * </p>
         * 
         * @param workspacesConnectionStatus
         *        Information about the connection status of the WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspacesConnectionStatus(WorkspaceConnectionStatus... workspacesConnectionStatus);

        /**
         * <p>
         * Information about the connection status of the WorkSpace.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspaces.model.WorkspaceConnectionStatus.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.workspaces.model.WorkspaceConnectionStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspaces.model.WorkspaceConnectionStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #workspacesConnectionStatus(List<WorkspaceConnectionStatus>)}.
         * 
         * @param workspacesConnectionStatus
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspaces.model.WorkspaceConnectionStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workspacesConnectionStatus(java.util.Collection<WorkspaceConnectionStatus>)
         */
        Builder workspacesConnectionStatus(Consumer<WorkspaceConnectionStatus.Builder>... workspacesConnectionStatus);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is null when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is null when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends WorkSpacesResponse.BuilderImpl implements Builder {
        private List<WorkspaceConnectionStatus> workspacesConnectionStatus = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspacesConnectionStatusResponse model) {
            super(model);
            workspacesConnectionStatus(model.workspacesConnectionStatus);
            nextToken(model.nextToken);
        }

        public final List<WorkspaceConnectionStatus.Builder> getWorkspacesConnectionStatus() {
            List<WorkspaceConnectionStatus.Builder> result = WorkspaceConnectionStatusListCopier
                    .copyToBuilder(this.workspacesConnectionStatus);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkspacesConnectionStatus(
                Collection<WorkspaceConnectionStatus.BuilderImpl> workspacesConnectionStatus) {
            this.workspacesConnectionStatus = WorkspaceConnectionStatusListCopier.copyFromBuilder(workspacesConnectionStatus);
        }

        @Override
        public final Builder workspacesConnectionStatus(Collection<WorkspaceConnectionStatus> workspacesConnectionStatus) {
            this.workspacesConnectionStatus = WorkspaceConnectionStatusListCopier.copy(workspacesConnectionStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspacesConnectionStatus(WorkspaceConnectionStatus... workspacesConnectionStatus) {
            workspacesConnectionStatus(Arrays.asList(workspacesConnectionStatus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspacesConnectionStatus(Consumer<WorkspaceConnectionStatus.Builder>... workspacesConnectionStatus) {
            workspacesConnectionStatus(Stream.of(workspacesConnectionStatus)
                    .map(c -> WorkspaceConnectionStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeWorkspacesConnectionStatusResponse build() {
            return new DescribeWorkspacesConnectionStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
