/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWorkspaceDirectoriesRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<DescribeWorkspaceDirectoriesRequest.Builder, DescribeWorkspaceDirectoriesRequest> {
    private static final SdkField<List<String>> DIRECTORY_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DirectoryIds")
            .getter(getter(DescribeWorkspaceDirectoriesRequest::directoryIds))
            .setter(setter(Builder::directoryIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> WORKSPACE_DIRECTORY_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("WorkspaceDirectoryNames")
            .getter(getter(DescribeWorkspaceDirectoriesRequest::workspaceDirectoryNames))
            .setter(setter(Builder::workspaceDirectoryNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceDirectoryNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(DescribeWorkspaceDirectoriesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeWorkspaceDirectoriesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<DescribeWorkspaceDirectoriesFilter>> FILTERS_FIELD = SdkField
            .<List<DescribeWorkspaceDirectoriesFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeWorkspaceDirectoriesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DescribeWorkspaceDirectoriesFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DescribeWorkspaceDirectoriesFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_IDS_FIELD,
            WORKSPACE_DIRECTORY_NAMES_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD, FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> directoryIds;

    private final List<String> workspaceDirectoryNames;

    private final Integer limit;

    private final String nextToken;

    private final List<DescribeWorkspaceDirectoriesFilter> filters;

    private DescribeWorkspaceDirectoriesRequest(BuilderImpl builder) {
        super(builder);
        this.directoryIds = builder.directoryIds;
        this.workspaceDirectoryNames = builder.workspaceDirectoryNames;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
        this.filters = builder.filters;
    }

    /**
     * For responses, this returns true if the service returned a value for the DirectoryIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDirectoryIds() {
        return directoryIds != null && !(directoryIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of the directories. If the value is null, all directories are retrieved.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDirectoryIds} method.
     * </p>
     * 
     * @return The identifiers of the directories. If the value is null, all directories are retrieved.
     */
    public final List<String> directoryIds() {
        return directoryIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkspaceDirectoryNames property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasWorkspaceDirectoryNames() {
        return workspaceDirectoryNames != null && !(workspaceDirectoryNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the WorkSpace directories.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkspaceDirectoryNames} method.
     * </p>
     * 
     * @return The names of the WorkSpace directories.
     */
    public final List<String> workspaceDirectoryNames() {
        return workspaceDirectoryNames;
    }

    /**
     * <p>
     * The maximum number of directories to return.
     * </p>
     * 
     * @return The maximum number of directories to return.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive
     * the next set of results.
     * </p>
     * 
     * @return If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to
     *         receive the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filter condition for the WorkSpaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The filter condition for the WorkSpaces.
     */
    public final List<DescribeWorkspaceDirectoriesFilter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDirectoryIds() ? directoryIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkspaceDirectoryNames() ? workspaceDirectoryNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspaceDirectoriesRequest)) {
            return false;
        }
        DescribeWorkspaceDirectoriesRequest other = (DescribeWorkspaceDirectoriesRequest) obj;
        return hasDirectoryIds() == other.hasDirectoryIds() && Objects.equals(directoryIds(), other.directoryIds())
                && hasWorkspaceDirectoryNames() == other.hasWorkspaceDirectoryNames()
                && Objects.equals(workspaceDirectoryNames(), other.workspaceDirectoryNames())
                && Objects.equals(limit(), other.limit()) && Objects.equals(nextToken(), other.nextToken())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWorkspaceDirectoriesRequest")
                .add("DirectoryIds", hasDirectoryIds() ? directoryIds() : null)
                .add("WorkspaceDirectoryNames", hasWorkspaceDirectoryNames() ? workspaceDirectoryNames() : null)
                .add("Limit", limit()).add("NextToken", nextToken()).add("Filters", hasFilters() ? filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryIds":
            return Optional.ofNullable(clazz.cast(directoryIds()));
        case "WorkspaceDirectoryNames":
            return Optional.ofNullable(clazz.cast(workspaceDirectoryNames()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DirectoryIds", DIRECTORY_IDS_FIELD);
        map.put("WorkspaceDirectoryNames", WORKSPACE_DIRECTORY_NAMES_FIELD);
        map.put("Limit", LIMIT_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Filters", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspaceDirectoriesRequest, T> g) {
        return obj -> g.apply((DescribeWorkspaceDirectoriesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeWorkspaceDirectoriesRequest> {
        /**
         * <p>
         * The identifiers of the directories. If the value is null, all directories are retrieved.
         * </p>
         * 
         * @param directoryIds
         *        The identifiers of the directories. If the value is null, all directories are retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryIds(Collection<String> directoryIds);

        /**
         * <p>
         * The identifiers of the directories. If the value is null, all directories are retrieved.
         * </p>
         * 
         * @param directoryIds
         *        The identifiers of the directories. If the value is null, all directories are retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryIds(String... directoryIds);

        /**
         * <p>
         * The names of the WorkSpace directories.
         * </p>
         * 
         * @param workspaceDirectoryNames
         *        The names of the WorkSpace directories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceDirectoryNames(Collection<String> workspaceDirectoryNames);

        /**
         * <p>
         * The names of the WorkSpace directories.
         * </p>
         * 
         * @param workspaceDirectoryNames
         *        The names of the WorkSpace directories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceDirectoryNames(String... workspaceDirectoryNames);

        /**
         * <p>
         * The maximum number of directories to return.
         * </p>
         * 
         * @param limit
         *        The maximum number of directories to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to
         * receive the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If you received a <code>NextToken</code> from a previous call that was paginated, provide this token
         *        to receive the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The filter condition for the WorkSpaces.
         * </p>
         * 
         * @param filters
         *        The filter condition for the WorkSpaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<DescribeWorkspaceDirectoriesFilter> filters);

        /**
         * <p>
         * The filter condition for the WorkSpaces.
         * </p>
         * 
         * @param filters
         *        The filter condition for the WorkSpaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(DescribeWorkspaceDirectoriesFilter... filters);

        /**
         * <p>
         * The filter condition for the WorkSpaces.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesFilter.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesFilter.Builder#build()}
         * is called immediately and its result is passed to {@link #filters(List<DescribeWorkspaceDirectoriesFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<DescribeWorkspaceDirectoriesFilter>)
         */
        Builder filters(Consumer<DescribeWorkspaceDirectoriesFilter.Builder>... filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private List<String> directoryIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> workspaceDirectoryNames = DefaultSdkAutoConstructList.getInstance();

        private Integer limit;

        private String nextToken;

        private List<DescribeWorkspaceDirectoriesFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspaceDirectoriesRequest model) {
            super(model);
            directoryIds(model.directoryIds);
            workspaceDirectoryNames(model.workspaceDirectoryNames);
            limit(model.limit);
            nextToken(model.nextToken);
            filters(model.filters);
        }

        public final Collection<String> getDirectoryIds() {
            if (directoryIds instanceof SdkAutoConstructList) {
                return null;
            }
            return directoryIds;
        }

        public final void setDirectoryIds(Collection<String> directoryIds) {
            this.directoryIds = DirectoryIdListCopier.copy(directoryIds);
        }

        @Override
        public final Builder directoryIds(Collection<String> directoryIds) {
            this.directoryIds = DirectoryIdListCopier.copy(directoryIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directoryIds(String... directoryIds) {
            directoryIds(Arrays.asList(directoryIds));
            return this;
        }

        public final Collection<String> getWorkspaceDirectoryNames() {
            if (workspaceDirectoryNames instanceof SdkAutoConstructList) {
                return null;
            }
            return workspaceDirectoryNames;
        }

        public final void setWorkspaceDirectoryNames(Collection<String> workspaceDirectoryNames) {
            this.workspaceDirectoryNames = WorkspaceDirectoryNameListCopier.copy(workspaceDirectoryNames);
        }

        @Override
        public final Builder workspaceDirectoryNames(Collection<String> workspaceDirectoryNames) {
            this.workspaceDirectoryNames = WorkspaceDirectoryNameListCopier.copy(workspaceDirectoryNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceDirectoryNames(String... workspaceDirectoryNames) {
            workspaceDirectoryNames(Arrays.asList(workspaceDirectoryNames));
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<DescribeWorkspaceDirectoriesFilter.Builder> getFilters() {
            List<DescribeWorkspaceDirectoriesFilter.Builder> result = DescribeWorkspaceDirectoriesFilterListCopier
                    .copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<DescribeWorkspaceDirectoriesFilter.BuilderImpl> filters) {
            this.filters = DescribeWorkspaceDirectoriesFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<DescribeWorkspaceDirectoriesFilter> filters) {
            this.filters = DescribeWorkspaceDirectoriesFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(DescribeWorkspaceDirectoriesFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<DescribeWorkspaceDirectoriesFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> DescribeWorkspaceDirectoriesFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeWorkspaceDirectoriesRequest build() {
            return new DescribeWorkspaceDirectoriesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
