/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConnectionAliasesResponse extends WorkSpacesResponse implements
        ToCopyableBuilder<DescribeConnectionAliasesResponse.Builder, DescribeConnectionAliasesResponse> {
    private static final SdkField<List<ConnectionAlias>> CONNECTION_ALIASES_FIELD = SdkField
            .<List<ConnectionAlias>> builder(MarshallingType.LIST)
            .memberName("ConnectionAliases")
            .getter(getter(DescribeConnectionAliasesResponse::connectionAliases))
            .setter(setter(Builder::connectionAliases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionAliases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConnectionAlias> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConnectionAlias::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeConnectionAliasesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ALIASES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ConnectionAlias> connectionAliases;

    private final String nextToken;

    private DescribeConnectionAliasesResponse(BuilderImpl builder) {
        super(builder);
        this.connectionAliases = builder.connectionAliases;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectionAliases property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConnectionAliases() {
        return connectionAliases != null && !(connectionAliases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the specified connection aliases.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectionAliases} method.
     * </p>
     * 
     * @return Information about the specified connection aliases.
     */
    public final List<ConnectionAlias> connectionAliases() {
        return connectionAliases;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is null when there are no more results to
     * return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is null when there are no more results
     *         to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectionAliases() ? connectionAliases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectionAliasesResponse)) {
            return false;
        }
        DescribeConnectionAliasesResponse other = (DescribeConnectionAliasesResponse) obj;
        return hasConnectionAliases() == other.hasConnectionAliases()
                && Objects.equals(connectionAliases(), other.connectionAliases())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConnectionAliasesResponse")
                .add("ConnectionAliases", hasConnectionAliases() ? connectionAliases() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionAliases":
            return Optional.ofNullable(clazz.cast(connectionAliases()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectionAliases", CONNECTION_ALIASES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectionAliasesResponse, T> g) {
        return obj -> g.apply((DescribeConnectionAliasesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeConnectionAliasesResponse> {
        /**
         * <p>
         * Information about the specified connection aliases.
         * </p>
         * 
         * @param connectionAliases
         *        Information about the specified connection aliases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionAliases(Collection<ConnectionAlias> connectionAliases);

        /**
         * <p>
         * Information about the specified connection aliases.
         * </p>
         * 
         * @param connectionAliases
         *        Information about the specified connection aliases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionAliases(ConnectionAlias... connectionAliases);

        /**
         * <p>
         * Information about the specified connection aliases.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspaces.model.ConnectionAlias.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.workspaces.model.ConnectionAlias#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspaces.model.ConnectionAlias.Builder#build()} is called
         * immediately and its result is passed to {@link #connectionAliases(List<ConnectionAlias>)}.
         * 
         * @param connectionAliases
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspaces.model.ConnectionAlias.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionAliases(java.util.Collection<ConnectionAlias>)
         */
        Builder connectionAliases(Consumer<ConnectionAlias.Builder>... connectionAliases);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is null when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is null when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends WorkSpacesResponse.BuilderImpl implements Builder {
        private List<ConnectionAlias> connectionAliases = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectionAliasesResponse model) {
            super(model);
            connectionAliases(model.connectionAliases);
            nextToken(model.nextToken);
        }

        public final List<ConnectionAlias.Builder> getConnectionAliases() {
            List<ConnectionAlias.Builder> result = ConnectionAliasListCopier.copyToBuilder(this.connectionAliases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnectionAliases(Collection<ConnectionAlias.BuilderImpl> connectionAliases) {
            this.connectionAliases = ConnectionAliasListCopier.copyFromBuilder(connectionAliases);
        }

        @Override
        public final Builder connectionAliases(Collection<ConnectionAlias> connectionAliases) {
            this.connectionAliases = ConnectionAliasListCopier.copy(connectionAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionAliases(ConnectionAlias... connectionAliases) {
            connectionAliases(Arrays.asList(connectionAliases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionAliases(Consumer<ConnectionAlias.Builder>... connectionAliases) {
            connectionAliases(Stream.of(connectionAliases).map(c -> ConnectionAlias.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeConnectionAliasesResponse build() {
            return new DescribeConnectionAliasesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
