/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClientPropertiesResponse extends WorkSpacesResponse implements
        ToCopyableBuilder<DescribeClientPropertiesResponse.Builder, DescribeClientPropertiesResponse> {
    private static final SdkField<List<ClientPropertiesResult>> CLIENT_PROPERTIES_LIST_FIELD = SdkField
            .<List<ClientPropertiesResult>> builder(MarshallingType.LIST)
            .memberName("ClientPropertiesList")
            .getter(getter(DescribeClientPropertiesResponse::clientPropertiesList))
            .setter(setter(Builder::clientPropertiesList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientPropertiesList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClientPropertiesResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClientPropertiesResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_PROPERTIES_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ClientPropertiesResult> clientPropertiesList;

    private DescribeClientPropertiesResponse(BuilderImpl builder) {
        super(builder);
        this.clientPropertiesList = builder.clientPropertiesList;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClientPropertiesList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClientPropertiesList() {
        return clientPropertiesList != null && !(clientPropertiesList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the specified Amazon WorkSpaces clients.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClientPropertiesList} method.
     * </p>
     * 
     * @return Information about the specified Amazon WorkSpaces clients.
     */
    public final List<ClientPropertiesResult> clientPropertiesList() {
        return clientPropertiesList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasClientPropertiesList() ? clientPropertiesList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClientPropertiesResponse)) {
            return false;
        }
        DescribeClientPropertiesResponse other = (DescribeClientPropertiesResponse) obj;
        return hasClientPropertiesList() == other.hasClientPropertiesList()
                && Objects.equals(clientPropertiesList(), other.clientPropertiesList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeClientPropertiesResponse")
                .add("ClientPropertiesList", hasClientPropertiesList() ? clientPropertiesList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientPropertiesList":
            return Optional.ofNullable(clazz.cast(clientPropertiesList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientPropertiesList", CLIENT_PROPERTIES_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeClientPropertiesResponse, T> g) {
        return obj -> g.apply((DescribeClientPropertiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeClientPropertiesResponse> {
        /**
         * <p>
         * Information about the specified Amazon WorkSpaces clients.
         * </p>
         * 
         * @param clientPropertiesList
         *        Information about the specified Amazon WorkSpaces clients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientPropertiesList(Collection<ClientPropertiesResult> clientPropertiesList);

        /**
         * <p>
         * Information about the specified Amazon WorkSpaces clients.
         * </p>
         * 
         * @param clientPropertiesList
         *        Information about the specified Amazon WorkSpaces clients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientPropertiesList(ClientPropertiesResult... clientPropertiesList);

        /**
         * <p>
         * Information about the specified Amazon WorkSpaces clients.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspaces.model.ClientPropertiesResult.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.workspaces.model.ClientPropertiesResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspaces.model.ClientPropertiesResult.Builder#build()} is called
         * immediately and its result is passed to {@link #clientPropertiesList(List<ClientPropertiesResult>)}.
         * 
         * @param clientPropertiesList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspaces.model.ClientPropertiesResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientPropertiesList(java.util.Collection<ClientPropertiesResult>)
         */
        Builder clientPropertiesList(Consumer<ClientPropertiesResult.Builder>... clientPropertiesList);
    }

    static final class BuilderImpl extends WorkSpacesResponse.BuilderImpl implements Builder {
        private List<ClientPropertiesResult> clientPropertiesList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClientPropertiesResponse model) {
            super(model);
            clientPropertiesList(model.clientPropertiesList);
        }

        public final List<ClientPropertiesResult.Builder> getClientPropertiesList() {
            List<ClientPropertiesResult.Builder> result = ClientPropertiesListCopier.copyToBuilder(this.clientPropertiesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClientPropertiesList(Collection<ClientPropertiesResult.BuilderImpl> clientPropertiesList) {
            this.clientPropertiesList = ClientPropertiesListCopier.copyFromBuilder(clientPropertiesList);
        }

        @Override
        public final Builder clientPropertiesList(Collection<ClientPropertiesResult> clientPropertiesList) {
            this.clientPropertiesList = ClientPropertiesListCopier.copy(clientPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientPropertiesList(ClientPropertiesResult... clientPropertiesList) {
            clientPropertiesList(Arrays.asList(clientPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientPropertiesList(Consumer<ClientPropertiesResult.Builder>... clientPropertiesList) {
            clientPropertiesList(Stream.of(clientPropertiesList)
                    .map(c -> ClientPropertiesResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeClientPropertiesResponse build() {
            return new DescribeClientPropertiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
