/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkspacesPoolResponse extends WorkSpacesResponse implements
        ToCopyableBuilder<CreateWorkspacesPoolResponse.Builder, CreateWorkspacesPoolResponse> {
    private static final SdkField<WorkspacesPool> WORKSPACES_POOL_FIELD = SdkField
            .<WorkspacesPool> builder(MarshallingType.SDK_POJO).memberName("WorkspacesPool")
            .getter(getter(CreateWorkspacesPoolResponse::workspacesPool)).setter(setter(Builder::workspacesPool))
            .constructor(WorkspacesPool::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspacesPool").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACES_POOL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final WorkspacesPool workspacesPool;

    private CreateWorkspacesPoolResponse(BuilderImpl builder) {
        super(builder);
        this.workspacesPool = builder.workspacesPool;
    }

    /**
     * <p>
     * Indicates the pool to create.
     * </p>
     * 
     * @return Indicates the pool to create.
     */
    public final WorkspacesPool workspacesPool() {
        return workspacesPool;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workspacesPool());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspacesPoolResponse)) {
            return false;
        }
        CreateWorkspacesPoolResponse other = (CreateWorkspacesPoolResponse) obj;
        return Objects.equals(workspacesPool(), other.workspacesPool());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkspacesPoolResponse").add("WorkspacesPool", workspacesPool()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkspacesPool":
            return Optional.ofNullable(clazz.cast(workspacesPool()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkspacesPool", WORKSPACES_POOL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkspacesPoolResponse, T> g) {
        return obj -> g.apply((CreateWorkspacesPoolResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateWorkspacesPoolResponse> {
        /**
         * <p>
         * Indicates the pool to create.
         * </p>
         * 
         * @param workspacesPool
         *        Indicates the pool to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspacesPool(WorkspacesPool workspacesPool);

        /**
         * <p>
         * Indicates the pool to create.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkspacesPool.Builder} avoiding the need
         * to create one manually via {@link WorkspacesPool#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkspacesPool.Builder#build()} is called immediately and its
         * result is passed to {@link #workspacesPool(WorkspacesPool)}.
         * 
         * @param workspacesPool
         *        a consumer that will call methods on {@link WorkspacesPool.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workspacesPool(WorkspacesPool)
         */
        default Builder workspacesPool(Consumer<WorkspacesPool.Builder> workspacesPool) {
            return workspacesPool(WorkspacesPool.builder().applyMutation(workspacesPool).build());
        }
    }

    static final class BuilderImpl extends WorkSpacesResponse.BuilderImpl implements Builder {
        private WorkspacesPool workspacesPool;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkspacesPoolResponse model) {
            super(model);
            workspacesPool(model.workspacesPool);
        }

        public final WorkspacesPool.Builder getWorkspacesPool() {
            return workspacesPool != null ? workspacesPool.toBuilder() : null;
        }

        public final void setWorkspacesPool(WorkspacesPool.BuilderImpl workspacesPool) {
            this.workspacesPool = workspacesPool != null ? workspacesPool.build() : null;
        }

        @Override
        public final Builder workspacesPool(WorkspacesPool workspacesPool) {
            this.workspacesPool = workspacesPool;
            return this;
        }

        @Override
        public CreateWorkspacesPoolResponse build() {
            return new CreateWorkspacesPoolResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
