/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkspaceBundleResponse extends WorkSpacesResponse implements
        ToCopyableBuilder<CreateWorkspaceBundleResponse.Builder, CreateWorkspaceBundleResponse> {
    private static final SdkField<WorkspaceBundle> WORKSPACE_BUNDLE_FIELD = SdkField
            .<WorkspaceBundle> builder(MarshallingType.SDK_POJO).memberName("WorkspaceBundle")
            .getter(getter(CreateWorkspaceBundleResponse::workspaceBundle)).setter(setter(Builder::workspaceBundle))
            .constructor(WorkspaceBundle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceBundle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_BUNDLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final WorkspaceBundle workspaceBundle;

    private CreateWorkspaceBundleResponse(BuilderImpl builder) {
        super(builder);
        this.workspaceBundle = builder.workspaceBundle;
    }

    /**
     * Returns the value of the WorkspaceBundle property for this object.
     * 
     * @return The value of the WorkspaceBundle property for this object.
     */
    public final WorkspaceBundle workspaceBundle() {
        return workspaceBundle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workspaceBundle());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspaceBundleResponse)) {
            return false;
        }
        CreateWorkspaceBundleResponse other = (CreateWorkspaceBundleResponse) obj;
        return Objects.equals(workspaceBundle(), other.workspaceBundle());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkspaceBundleResponse").add("WorkspaceBundle", workspaceBundle()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkspaceBundle":
            return Optional.ofNullable(clazz.cast(workspaceBundle()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkspaceBundle", WORKSPACE_BUNDLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkspaceBundleResponse, T> g) {
        return obj -> g.apply((CreateWorkspaceBundleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateWorkspaceBundleResponse> {
        /**
         * Sets the value of the WorkspaceBundle property for this object.
         *
         * @param workspaceBundle
         *        The new value for the WorkspaceBundle property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceBundle(WorkspaceBundle workspaceBundle);

        /**
         * Sets the value of the WorkspaceBundle property for this object.
         *
         * This is a convenience method that creates an instance of the {@link WorkspaceBundle.Builder} avoiding the
         * need to create one manually via {@link WorkspaceBundle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkspaceBundle.Builder#build()} is called immediately and its
         * result is passed to {@link #workspaceBundle(WorkspaceBundle)}.
         * 
         * @param workspaceBundle
         *        a consumer that will call methods on {@link WorkspaceBundle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workspaceBundle(WorkspaceBundle)
         */
        default Builder workspaceBundle(Consumer<WorkspaceBundle.Builder> workspaceBundle) {
            return workspaceBundle(WorkspaceBundle.builder().applyMutation(workspaceBundle).build());
        }
    }

    static final class BuilderImpl extends WorkSpacesResponse.BuilderImpl implements Builder {
        private WorkspaceBundle workspaceBundle;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkspaceBundleResponse model) {
            super(model);
            workspaceBundle(model.workspaceBundle);
        }

        public final WorkspaceBundle.Builder getWorkspaceBundle() {
            return workspaceBundle != null ? workspaceBundle.toBuilder() : null;
        }

        public final void setWorkspaceBundle(WorkspaceBundle.BuilderImpl workspaceBundle) {
            this.workspaceBundle = workspaceBundle != null ? workspaceBundle.build() : null;
        }

        @Override
        public final Builder workspaceBundle(WorkspaceBundle workspaceBundle) {
            this.workspaceBundle = workspaceBundle;
            return this;
        }

        @Override
        public CreateWorkspaceBundleResponse build() {
            return new CreateWorkspaceBundleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
