/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The persistent application settings for WorkSpaces Pools users.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationSettingsRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationSettingsRequest.Builder, ApplicationSettingsRequest> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ApplicationSettingsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> SETTINGS_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SettingsGroup").getter(getter(ApplicationSettingsRequest::settingsGroup))
            .setter(setter(Builder::settingsGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SettingsGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            SETTINGS_GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String settingsGroup;

    private ApplicationSettingsRequest(BuilderImpl builder) {
        this.status = builder.status;
        this.settingsGroup = builder.settingsGroup;
    }

    /**
     * <p>
     * Enables or disables persistent application settings for users during their pool sessions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationSettingsStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Enables or disables persistent application settings for users during their pool sessions.
     * @see ApplicationSettingsStatusEnum
     */
    public final ApplicationSettingsStatusEnum status() {
        return ApplicationSettingsStatusEnum.fromValue(status);
    }

    /**
     * <p>
     * Enables or disables persistent application settings for users during their pool sessions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationSettingsStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Enables or disables persistent application settings for users during their pool sessions.
     * @see ApplicationSettingsStatusEnum
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The path prefix for the S3 bucket where users’ persistent application settings are stored. You can allow the same
     * persistent application settings to be used across multiple pools by specifying the same settings group for each
     * pool.
     * </p>
     * 
     * @return The path prefix for the S3 bucket where users’ persistent application settings are stored. You can allow
     *         the same persistent application settings to be used across multiple pools by specifying the same settings
     *         group for each pool.
     */
    public final String settingsGroup() {
        return settingsGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(settingsGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSettingsRequest)) {
            return false;
        }
        ApplicationSettingsRequest other = (ApplicationSettingsRequest) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(settingsGroup(), other.settingsGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationSettingsRequest").add("Status", statusAsString())
                .add("SettingsGroup", settingsGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "SettingsGroup":
            return Optional.ofNullable(clazz.cast(settingsGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("SettingsGroup", SETTINGS_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationSettingsRequest, T> g) {
        return obj -> g.apply((ApplicationSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationSettingsRequest> {
        /**
         * <p>
         * Enables or disables persistent application settings for users during their pool sessions.
         * </p>
         * 
         * @param status
         *        Enables or disables persistent application settings for users during their pool sessions.
         * @see ApplicationSettingsStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationSettingsStatusEnum
         */
        Builder status(String status);

        /**
         * <p>
         * Enables or disables persistent application settings for users during their pool sessions.
         * </p>
         * 
         * @param status
         *        Enables or disables persistent application settings for users during their pool sessions.
         * @see ApplicationSettingsStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationSettingsStatusEnum
         */
        Builder status(ApplicationSettingsStatusEnum status);

        /**
         * <p>
         * The path prefix for the S3 bucket where users’ persistent application settings are stored. You can allow the
         * same persistent application settings to be used across multiple pools by specifying the same settings group
         * for each pool.
         * </p>
         * 
         * @param settingsGroup
         *        The path prefix for the S3 bucket where users’ persistent application settings are stored. You can
         *        allow the same persistent application settings to be used across multiple pools by specifying the same
         *        settings group for each pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settingsGroup(String settingsGroup);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String settingsGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSettingsRequest model) {
            status(model.status);
            settingsGroup(model.settingsGroup);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationSettingsStatusEnum status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSettingsGroup() {
            return settingsGroup;
        }

        public final void setSettingsGroup(String settingsGroup) {
            this.settingsGroup = settingsGroup;
        }

        @Override
        @Transient
        public final Builder settingsGroup(String settingsGroup) {
            this.settingsGroup = settingsGroup;
            return this;
        }

        @Override
        public ApplicationSettingsRequest build() {
            return new ApplicationSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
