/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the Active Directory config.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActiveDirectoryConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ActiveDirectoryConfig.Builder, ActiveDirectoryConfig> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(ActiveDirectoryConfig::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> SERVICE_ACCOUNT_SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceAccountSecretArn").getter(getter(ActiveDirectoryConfig::serviceAccountSecretArn))
            .setter(setter(Builder::serviceAccountSecretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccountSecretArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            SERVICE_ACCOUNT_SECRET_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String domainName;

    private final String serviceAccountSecretArn;

    private ActiveDirectoryConfig(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.serviceAccountSecretArn = builder.serviceAccountSecretArn;
    }

    /**
     * <p>
     * The name of the domain.
     * </p>
     * 
     * @return The name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Indicates the secret ARN on the service account.
     * </p>
     * 
     * @return Indicates the secret ARN on the service account.
     */
    public final String serviceAccountSecretArn() {
        return serviceAccountSecretArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccountSecretArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveDirectoryConfig)) {
            return false;
        }
        ActiveDirectoryConfig other = (ActiveDirectoryConfig) obj;
        return Objects.equals(domainName(), other.domainName())
                && Objects.equals(serviceAccountSecretArn(), other.serviceAccountSecretArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActiveDirectoryConfig").add("DomainName", domainName())
                .add("ServiceAccountSecretArn", serviceAccountSecretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "ServiceAccountSecretArn":
            return Optional.ofNullable(clazz.cast(serviceAccountSecretArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("ServiceAccountSecretArn", SERVICE_ACCOUNT_SECRET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActiveDirectoryConfig, T> g) {
        return obj -> g.apply((ActiveDirectoryConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActiveDirectoryConfig> {
        /**
         * <p>
         * The name of the domain.
         * </p>
         * 
         * @param domainName
         *        The name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Indicates the secret ARN on the service account.
         * </p>
         * 
         * @param serviceAccountSecretArn
         *        Indicates the secret ARN on the service account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccountSecretArn(String serviceAccountSecretArn);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private String serviceAccountSecretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveDirectoryConfig model) {
            domainName(model.domainName);
            serviceAccountSecretArn(model.serviceAccountSecretArn);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getServiceAccountSecretArn() {
            return serviceAccountSecretArn;
        }

        public final void setServiceAccountSecretArn(String serviceAccountSecretArn) {
            this.serviceAccountSecretArn = serviceAccountSecretArn;
        }

        @Override
        public final Builder serviceAccountSecretArn(String serviceAccountSecretArn) {
            this.serviceAccountSecretArn = serviceAccountSecretArn;
            return this;
        }

        @Override
        public ActiveDirectoryConfig build() {
            return new ActiveDirectoryConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
