/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EndpointEncryptionMode {
    STANDARD_TLS("STANDARD_TLS"),
    FIPS_VALIDATED("FIPS_VALIDATED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EndpointEncryptionMode> VALUE_MAP;
    private final String value;

    private EndpointEncryptionMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EndpointEncryptionMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EndpointEncryptionMode> knownValues() {
        EnumSet<EndpointEncryptionMode> knownValues = EnumSet.allOf(EndpointEncryptionMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EndpointEncryptionMode.class, EndpointEncryptionMode::toString);
    }
}

