/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.services.workspaces.model.WorkspaceIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorkspacesRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, DescribeWorkspacesRequest> {
    private static final SdkField<List<String>> WORKSPACE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WorkspaceIds").getter(DescribeWorkspacesRequest.getter(DescribeWorkspacesRequest::workspaceIds)).setter(DescribeWorkspacesRequest.setter(Builder::workspaceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(DescribeWorkspacesRequest.getter(DescribeWorkspacesRequest::directoryId)).setter(DescribeWorkspacesRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(DescribeWorkspacesRequest.getter(DescribeWorkspacesRequest::userName)).setter(DescribeWorkspacesRequest.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BundleId").getter(DescribeWorkspacesRequest.getter(DescribeWorkspacesRequest::bundleId)).setter(DescribeWorkspacesRequest.setter(Builder::bundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleId").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(DescribeWorkspacesRequest.getter(DescribeWorkspacesRequest::limit)).setter(DescribeWorkspacesRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeWorkspacesRequest.getter(DescribeWorkspacesRequest::nextToken)).setter(DescribeWorkspacesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> WORKSPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkspaceName").getter(DescribeWorkspacesRequest.getter(DescribeWorkspacesRequest::workspaceName)).setter(DescribeWorkspacesRequest.setter(Builder::workspaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_IDS_FIELD, DIRECTORY_ID_FIELD, USER_NAME_FIELD, BUNDLE_ID_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD, WORKSPACE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("WorkspaceIds", WORKSPACE_IDS_FIELD);
            this.put("DirectoryId", DIRECTORY_ID_FIELD);
            this.put("UserName", USER_NAME_FIELD);
            this.put("BundleId", BUNDLE_ID_FIELD);
            this.put("Limit", LIMIT_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("WorkspaceName", WORKSPACE_NAME_FIELD);
        }
    });
    private final List<String> workspaceIds;
    private final String directoryId;
    private final String userName;
    private final String bundleId;
    private final Integer limit;
    private final String nextToken;
    private final String workspaceName;

    private DescribeWorkspacesRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceIds = builder.workspaceIds;
        this.directoryId = builder.directoryId;
        this.userName = builder.userName;
        this.bundleId = builder.bundleId;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
        this.workspaceName = builder.workspaceName;
    }

    public final boolean hasWorkspaceIds() {
        return this.workspaceIds != null && !(this.workspaceIds instanceof SdkAutoConstructList);
    }

    public final List<String> workspaceIds() {
        return this.workspaceIds;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final String userName() {
        return this.userName;
    }

    public final String bundleId() {
        return this.bundleId;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String workspaceName() {
        return this.workspaceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkspaceIds() ? this.workspaceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspacesRequest)) {
            return false;
        }
        DescribeWorkspacesRequest other = (DescribeWorkspacesRequest)((Object)obj);
        return this.hasWorkspaceIds() == other.hasWorkspaceIds() && Objects.equals(this.workspaceIds(), other.workspaceIds()) && Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.userName(), other.userName()) && Objects.equals(this.bundleId(), other.bundleId()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.workspaceName(), other.workspaceName());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeWorkspacesRequest").add("WorkspaceIds", this.hasWorkspaceIds() ? this.workspaceIds() : null).add("DirectoryId", (Object)this.directoryId()).add("UserName", (Object)this.userName()).add("BundleId", (Object)this.bundleId()).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).add("WorkspaceName", (Object)this.workspaceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkspaceIds": {
                return Optional.ofNullable(clazz.cast(this.workspaceIds()));
            }
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "BundleId": {
                return Optional.ofNullable(clazz.cast(this.bundleId()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "WorkspaceName": {
                return Optional.ofNullable(clazz.cast(this.workspaceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspacesRequest, T> g) {
        return obj -> g.apply((DescribeWorkspacesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private List<String> workspaceIds = DefaultSdkAutoConstructList.getInstance();
        private String directoryId;
        private String userName;
        private String bundleId;
        private Integer limit;
        private String nextToken;
        private String workspaceName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspacesRequest model) {
            super(model);
            this.workspaceIds(model.workspaceIds);
            this.directoryId(model.directoryId);
            this.userName(model.userName);
            this.bundleId(model.bundleId);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
            this.workspaceName(model.workspaceName);
        }

        public final Collection<String> getWorkspaceIds() {
            if (this.workspaceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.workspaceIds;
        }

        public final void setWorkspaceIds(Collection<String> workspaceIds) {
            this.workspaceIds = WorkspaceIdListCopier.copy(workspaceIds);
        }

        @Override
        public final Builder workspaceIds(Collection<String> workspaceIds) {
            this.workspaceIds = WorkspaceIdListCopier.copy(workspaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceIds(String ... workspaceIds) {
            this.workspaceIds(Arrays.asList(workspaceIds));
            return this;
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getWorkspaceName() {
            return this.workspaceName;
        }

        public final void setWorkspaceName(String workspaceName) {
            this.workspaceName = workspaceName;
        }

        @Override
        public final Builder workspaceName(String workspaceName) {
            this.workspaceName = workspaceName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeWorkspacesRequest build() {
            return new DescribeWorkspacesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorkspacesRequest> {
        public Builder workspaceIds(Collection<String> var1);

        public Builder workspaceIds(String ... var1);

        public Builder directoryId(String var1);

        public Builder userName(String var1);

        public Builder bundleId(String var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder workspaceName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

