/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.ApplicationSettingsRequest;
import software.amazon.awssdk.services.workspaces.model.Capacity;
import software.amazon.awssdk.services.workspaces.model.TimeoutSettings;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWorkspacesPoolRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, UpdateWorkspacesPoolRequest> {
    private static final SdkField<String> POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolId").getter(UpdateWorkspacesPoolRequest.getter(UpdateWorkspacesPoolRequest::poolId)).setter(UpdateWorkspacesPoolRequest.setter(Builder::poolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateWorkspacesPoolRequest.getter(UpdateWorkspacesPoolRequest::description)).setter(UpdateWorkspacesPoolRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BundleId").getter(UpdateWorkspacesPoolRequest.getter(UpdateWorkspacesPoolRequest::bundleId)).setter(UpdateWorkspacesPoolRequest.setter(Builder::bundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleId").build()}).build();
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(UpdateWorkspacesPoolRequest.getter(UpdateWorkspacesPoolRequest::directoryId)).setter(UpdateWorkspacesPoolRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<Capacity> CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Capacity").getter(UpdateWorkspacesPoolRequest.getter(UpdateWorkspacesPoolRequest::capacity)).setter(UpdateWorkspacesPoolRequest.setter(Builder::capacity)).constructor(Capacity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capacity").build()}).build();
    private static final SdkField<ApplicationSettingsRequest> APPLICATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationSettings").getter(UpdateWorkspacesPoolRequest.getter(UpdateWorkspacesPoolRequest::applicationSettings)).setter(UpdateWorkspacesPoolRequest.setter(Builder::applicationSettings)).constructor(ApplicationSettingsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSettings").build()}).build();
    private static final SdkField<TimeoutSettings> TIMEOUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeoutSettings").getter(UpdateWorkspacesPoolRequest.getter(UpdateWorkspacesPoolRequest::timeoutSettings)).setter(UpdateWorkspacesPoolRequest.setter(Builder::timeoutSettings)).constructor(TimeoutSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_ID_FIELD, DESCRIPTION_FIELD, BUNDLE_ID_FIELD, DIRECTORY_ID_FIELD, CAPACITY_FIELD, APPLICATION_SETTINGS_FIELD, TIMEOUT_SETTINGS_FIELD));
    private final String poolId;
    private final String description;
    private final String bundleId;
    private final String directoryId;
    private final Capacity capacity;
    private final ApplicationSettingsRequest applicationSettings;
    private final TimeoutSettings timeoutSettings;

    private UpdateWorkspacesPoolRequest(BuilderImpl builder) {
        super(builder);
        this.poolId = builder.poolId;
        this.description = builder.description;
        this.bundleId = builder.bundleId;
        this.directoryId = builder.directoryId;
        this.capacity = builder.capacity;
        this.applicationSettings = builder.applicationSettings;
        this.timeoutSettings = builder.timeoutSettings;
    }

    public final String poolId() {
        return this.poolId;
    }

    public final String description() {
        return this.description;
    }

    public final String bundleId() {
        return this.bundleId;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final Capacity capacity() {
        return this.capacity;
    }

    public final ApplicationSettingsRequest applicationSettings() {
        return this.applicationSettings;
    }

    public final TimeoutSettings timeoutSettings() {
        return this.timeoutSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.poolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkspacesPoolRequest)) {
            return false;
        }
        UpdateWorkspacesPoolRequest other = (UpdateWorkspacesPoolRequest)((Object)obj);
        return Objects.equals(this.poolId(), other.poolId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.bundleId(), other.bundleId()) && Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.capacity(), other.capacity()) && Objects.equals(this.applicationSettings(), other.applicationSettings()) && Objects.equals(this.timeoutSettings(), other.timeoutSettings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWorkspacesPoolRequest").add("PoolId", (Object)this.poolId()).add("Description", (Object)this.description()).add("BundleId", (Object)this.bundleId()).add("DirectoryId", (Object)this.directoryId()).add("Capacity", (Object)this.capacity()).add("ApplicationSettings", (Object)this.applicationSettings()).add("TimeoutSettings", (Object)this.timeoutSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PoolId": {
                return Optional.ofNullable(clazz.cast(this.poolId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "BundleId": {
                return Optional.ofNullable(clazz.cast(this.bundleId()));
            }
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "Capacity": {
                return Optional.ofNullable(clazz.cast(this.capacity()));
            }
            case "ApplicationSettings": {
                return Optional.ofNullable(clazz.cast(this.applicationSettings()));
            }
            case "TimeoutSettings": {
                return Optional.ofNullable(clazz.cast(this.timeoutSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkspacesPoolRequest, T> g) {
        return obj -> g.apply((UpdateWorkspacesPoolRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private String poolId;
        private String description;
        private String bundleId;
        private String directoryId;
        private Capacity capacity;
        private ApplicationSettingsRequest applicationSettings;
        private TimeoutSettings timeoutSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkspacesPoolRequest model) {
            super(model);
            this.poolId(model.poolId);
            this.description(model.description);
            this.bundleId(model.bundleId);
            this.directoryId(model.directoryId);
            this.capacity(model.capacity);
            this.applicationSettings(model.applicationSettings);
            this.timeoutSettings(model.timeoutSettings);
        }

        public final String getPoolId() {
            return this.poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final Capacity.Builder getCapacity() {
            return this.capacity != null ? this.capacity.toBuilder() : null;
        }

        public final void setCapacity(Capacity.BuilderImpl capacity) {
            this.capacity = capacity != null ? capacity.build() : null;
        }

        @Override
        public final Builder capacity(Capacity capacity) {
            this.capacity = capacity;
            return this;
        }

        public final ApplicationSettingsRequest.Builder getApplicationSettings() {
            return this.applicationSettings != null ? this.applicationSettings.toBuilder() : null;
        }

        public final void setApplicationSettings(ApplicationSettingsRequest.BuilderImpl applicationSettings) {
            this.applicationSettings = applicationSettings != null ? applicationSettings.build() : null;
        }

        @Override
        public final Builder applicationSettings(ApplicationSettingsRequest applicationSettings) {
            this.applicationSettings = applicationSettings;
            return this;
        }

        public final TimeoutSettings.Builder getTimeoutSettings() {
            return this.timeoutSettings != null ? this.timeoutSettings.toBuilder() : null;
        }

        public final void setTimeoutSettings(TimeoutSettings.BuilderImpl timeoutSettings) {
            this.timeoutSettings = timeoutSettings != null ? timeoutSettings.build() : null;
        }

        @Override
        public final Builder timeoutSettings(TimeoutSettings timeoutSettings) {
            this.timeoutSettings = timeoutSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkspacesPoolRequest build() {
            return new UpdateWorkspacesPoolRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWorkspacesPoolRequest> {
        public Builder poolId(String var1);

        public Builder description(String var1);

        public Builder bundleId(String var1);

        public Builder directoryId(String var1);

        public Builder capacity(Capacity var1);

        default public Builder capacity(Consumer<Capacity.Builder> capacity) {
            return this.capacity((Capacity)((Capacity.Builder)Capacity.builder().applyMutation(capacity)).build());
        }

        public Builder applicationSettings(ApplicationSettingsRequest var1);

        default public Builder applicationSettings(Consumer<ApplicationSettingsRequest.Builder> applicationSettings) {
            return this.applicationSettings((ApplicationSettingsRequest)((ApplicationSettingsRequest.Builder)ApplicationSettingsRequest.builder().applyMutation(applicationSettings)).build());
        }

        public Builder timeoutSettings(TimeoutSettings var1);

        default public Builder timeoutSettings(Consumer<TimeoutSettings.Builder> timeoutSettings) {
            return this.timeoutSettings((TimeoutSettings)((TimeoutSettings.Builder)TimeoutSettings.builder().applyMutation(timeoutSettings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

