/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.SamlStatusEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SamlProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SamlProperties> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(SamlProperties.getter(SamlProperties::statusAsString)).setter(SamlProperties.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> USER_ACCESS_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserAccessUrl").getter(SamlProperties.getter(SamlProperties::userAccessUrl)).setter(SamlProperties.setter(Builder::userAccessUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAccessUrl").build()}).build();
    private static final SdkField<String> RELAY_STATE_PARAMETER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelayStateParameterName").getter(SamlProperties.getter(SamlProperties::relayStateParameterName)).setter(SamlProperties.setter(Builder::relayStateParameterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelayStateParameterName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, USER_ACCESS_URL_FIELD, RELAY_STATE_PARAMETER_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String userAccessUrl;
    private final String relayStateParameterName;

    private SamlProperties(BuilderImpl builder) {
        this.status = builder.status;
        this.userAccessUrl = builder.userAccessUrl;
        this.relayStateParameterName = builder.relayStateParameterName;
    }

    public final SamlStatusEnum status() {
        return SamlStatusEnum.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String userAccessUrl() {
        return this.userAccessUrl;
    }

    public final String relayStateParameterName() {
        return this.relayStateParameterName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userAccessUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.relayStateParameterName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamlProperties)) {
            return false;
        }
        SamlProperties other = (SamlProperties)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.userAccessUrl(), other.userAccessUrl()) && Objects.equals(this.relayStateParameterName(), other.relayStateParameterName());
    }

    public final String toString() {
        return ToString.builder((String)"SamlProperties").add("Status", (Object)this.statusAsString()).add("UserAccessUrl", (Object)this.userAccessUrl()).add("RelayStateParameterName", (Object)this.relayStateParameterName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "UserAccessUrl": {
                return Optional.ofNullable(clazz.cast(this.userAccessUrl()));
            }
            case "RelayStateParameterName": {
                return Optional.ofNullable(clazz.cast(this.relayStateParameterName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SamlProperties, T> g) {
        return obj -> g.apply((SamlProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String userAccessUrl;
        private String relayStateParameterName;

        private BuilderImpl() {
        }

        private BuilderImpl(SamlProperties model) {
            this.status(model.status);
            this.userAccessUrl(model.userAccessUrl);
            this.relayStateParameterName(model.relayStateParameterName);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SamlStatusEnum status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getUserAccessUrl() {
            return this.userAccessUrl;
        }

        public final void setUserAccessUrl(String userAccessUrl) {
            this.userAccessUrl = userAccessUrl;
        }

        @Override
        public final Builder userAccessUrl(String userAccessUrl) {
            this.userAccessUrl = userAccessUrl;
            return this;
        }

        public final String getRelayStateParameterName() {
            return this.relayStateParameterName;
        }

        public final void setRelayStateParameterName(String relayStateParameterName) {
            this.relayStateParameterName = relayStateParameterName;
        }

        @Override
        public final Builder relayStateParameterName(String relayStateParameterName) {
            this.relayStateParameterName = relayStateParameterName;
            return this;
        }

        public SamlProperties build() {
            return new SamlProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SamlProperties> {
        public Builder status(String var1);

        public Builder status(SamlStatusEnum var1);

        public Builder userAccessUrl(String var1);

        public Builder relayStateParameterName(String var1);
    }
}

