/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Application {
    MICROSOFT_OFFICE_2016("Microsoft_Office_2016"),
    MICROSOFT_OFFICE_2019("Microsoft_Office_2019"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Application> VALUE_MAP;
    private final String value;

    private Application(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Application fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Application> knownValues() {
        EnumSet<Application> knownValues = EnumSet.allOf(Application.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Application.class, Application::toString);
    }
}

