/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.DedicatedTenancyModificationStateEnum;
import software.amazon.awssdk.services.workspaces.model.DedicatedTenancySupportResultEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountModification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountModification> {
    private static final SdkField<String> MODIFICATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModificationState").getter(AccountModification.getter(AccountModification::modificationStateAsString)).setter(AccountModification.setter(Builder::modificationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationState").build()}).build();
    private static final SdkField<String> DEDICATED_TENANCY_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DedicatedTenancySupport").getter(AccountModification.getter(AccountModification::dedicatedTenancySupportAsString)).setter(AccountModification.setter(Builder::dedicatedTenancySupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedTenancySupport").build()}).build();
    private static final SdkField<String> DEDICATED_TENANCY_MANAGEMENT_CIDR_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DedicatedTenancyManagementCidrRange").getter(AccountModification.getter(AccountModification::dedicatedTenancyManagementCidrRange)).setter(AccountModification.setter(Builder::dedicatedTenancyManagementCidrRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedTenancyManagementCidrRange").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(AccountModification.getter(AccountModification::startTime)).setter(AccountModification.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(AccountModification.getter(AccountModification::errorCode)).setter(AccountModification.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(AccountModification.getter(AccountModification::errorMessage)).setter(AccountModification.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODIFICATION_STATE_FIELD, DEDICATED_TENANCY_SUPPORT_FIELD, DEDICATED_TENANCY_MANAGEMENT_CIDR_RANGE_FIELD, START_TIME_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String modificationState;
    private final String dedicatedTenancySupport;
    private final String dedicatedTenancyManagementCidrRange;
    private final Instant startTime;
    private final String errorCode;
    private final String errorMessage;

    private AccountModification(BuilderImpl builder) {
        this.modificationState = builder.modificationState;
        this.dedicatedTenancySupport = builder.dedicatedTenancySupport;
        this.dedicatedTenancyManagementCidrRange = builder.dedicatedTenancyManagementCidrRange;
        this.startTime = builder.startTime;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    public final DedicatedTenancyModificationStateEnum modificationState() {
        return DedicatedTenancyModificationStateEnum.fromValue(this.modificationState);
    }

    public final String modificationStateAsString() {
        return this.modificationState;
    }

    public final DedicatedTenancySupportResultEnum dedicatedTenancySupport() {
        return DedicatedTenancySupportResultEnum.fromValue(this.dedicatedTenancySupport);
    }

    public final String dedicatedTenancySupportAsString() {
        return this.dedicatedTenancySupport;
    }

    public final String dedicatedTenancyManagementCidrRange() {
        return this.dedicatedTenancyManagementCidrRange;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final String errorCode() {
        return this.errorCode;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modificationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dedicatedTenancySupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dedicatedTenancyManagementCidrRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountModification)) {
            return false;
        }
        AccountModification other = (AccountModification)obj;
        return Objects.equals(this.modificationStateAsString(), other.modificationStateAsString()) && Objects.equals(this.dedicatedTenancySupportAsString(), other.dedicatedTenancySupportAsString()) && Objects.equals(this.dedicatedTenancyManagementCidrRange(), other.dedicatedTenancyManagementCidrRange()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.errorMessage(), other.errorMessage());
    }

    public final String toString() {
        return ToString.builder((String)"AccountModification").add("ModificationState", (Object)this.modificationStateAsString()).add("DedicatedTenancySupport", (Object)this.dedicatedTenancySupportAsString()).add("DedicatedTenancyManagementCidrRange", (Object)this.dedicatedTenancyManagementCidrRange()).add("StartTime", (Object)this.startTime()).add("ErrorCode", (Object)this.errorCode()).add("ErrorMessage", (Object)this.errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModificationState": {
                return Optional.ofNullable(clazz.cast(this.modificationStateAsString()));
            }
            case "DedicatedTenancySupport": {
                return Optional.ofNullable(clazz.cast(this.dedicatedTenancySupportAsString()));
            }
            case "DedicatedTenancyManagementCidrRange": {
                return Optional.ofNullable(clazz.cast(this.dedicatedTenancyManagementCidrRange()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountModification, T> g) {
        return obj -> g.apply((AccountModification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modificationState;
        private String dedicatedTenancySupport;
        private String dedicatedTenancyManagementCidrRange;
        private Instant startTime;
        private String errorCode;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountModification model) {
            this.modificationState(model.modificationState);
            this.dedicatedTenancySupport(model.dedicatedTenancySupport);
            this.dedicatedTenancyManagementCidrRange(model.dedicatedTenancyManagementCidrRange);
            this.startTime(model.startTime);
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
        }

        public final String getModificationState() {
            return this.modificationState;
        }

        public final void setModificationState(String modificationState) {
            this.modificationState = modificationState;
        }

        @Override
        public final Builder modificationState(String modificationState) {
            this.modificationState = modificationState;
            return this;
        }

        @Override
        public final Builder modificationState(DedicatedTenancyModificationStateEnum modificationState) {
            this.modificationState(modificationState == null ? null : modificationState.toString());
            return this;
        }

        public final String getDedicatedTenancySupport() {
            return this.dedicatedTenancySupport;
        }

        public final void setDedicatedTenancySupport(String dedicatedTenancySupport) {
            this.dedicatedTenancySupport = dedicatedTenancySupport;
        }

        @Override
        public final Builder dedicatedTenancySupport(String dedicatedTenancySupport) {
            this.dedicatedTenancySupport = dedicatedTenancySupport;
            return this;
        }

        @Override
        public final Builder dedicatedTenancySupport(DedicatedTenancySupportResultEnum dedicatedTenancySupport) {
            this.dedicatedTenancySupport(dedicatedTenancySupport == null ? null : dedicatedTenancySupport.toString());
            return this;
        }

        public final String getDedicatedTenancyManagementCidrRange() {
            return this.dedicatedTenancyManagementCidrRange;
        }

        public final void setDedicatedTenancyManagementCidrRange(String dedicatedTenancyManagementCidrRange) {
            this.dedicatedTenancyManagementCidrRange = dedicatedTenancyManagementCidrRange;
        }

        @Override
        public final Builder dedicatedTenancyManagementCidrRange(String dedicatedTenancyManagementCidrRange) {
            this.dedicatedTenancyManagementCidrRange = dedicatedTenancyManagementCidrRange;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public AccountModification build() {
            return new AccountModification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountModification> {
        public Builder modificationState(String var1);

        public Builder modificationState(DedicatedTenancyModificationStateEnum var1);

        public Builder dedicatedTenancySupport(String var1);

        public Builder dedicatedTenancySupport(DedicatedTenancySupportResultEnum var1);

        public Builder dedicatedTenancyManagementCidrRange(String var1);

        public Builder startTime(Instant var1);

        public Builder errorCode(String var1);

        public Builder errorMessage(String var1);
    }
}

