/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkspacesRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<CreateWorkspacesRequest.Builder, CreateWorkspacesRequest> {
    private static final SdkField<List<WorkspaceRequest>> WORKSPACES_FIELD = SdkField
            .<List<WorkspaceRequest>> builder(MarshallingType.LIST)
            .memberName("Workspaces")
            .getter(getter(CreateWorkspacesRequest::workspaces))
            .setter(setter(Builder::workspaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Workspaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkspaceRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkspaceRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACES_FIELD));

    private final List<WorkspaceRequest> workspaces;

    private CreateWorkspacesRequest(BuilderImpl builder) {
        super(builder);
        this.workspaces = builder.workspaces;
    }

    /**
     * For responses, this returns true if the service returned a value for the Workspaces property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWorkspaces() {
        return workspaces != null && !(workspaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The WorkSpaces to create. You can specify up to 25 WorkSpaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkspaces} method.
     * </p>
     * 
     * @return The WorkSpaces to create. You can specify up to 25 WorkSpaces.
     */
    public final List<WorkspaceRequest> workspaces() {
        return workspaces;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkspaces() ? workspaces() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspacesRequest)) {
            return false;
        }
        CreateWorkspacesRequest other = (CreateWorkspacesRequest) obj;
        return hasWorkspaces() == other.hasWorkspaces() && Objects.equals(workspaces(), other.workspaces());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkspacesRequest").add("Workspaces", hasWorkspaces() ? workspaces() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Workspaces":
            return Optional.ofNullable(clazz.cast(workspaces()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkspacesRequest, T> g) {
        return obj -> g.apply((CreateWorkspacesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateWorkspacesRequest> {
        /**
         * <p>
         * The WorkSpaces to create. You can specify up to 25 WorkSpaces.
         * </p>
         * 
         * @param workspaces
         *        The WorkSpaces to create. You can specify up to 25 WorkSpaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaces(Collection<WorkspaceRequest> workspaces);

        /**
         * <p>
         * The WorkSpaces to create. You can specify up to 25 WorkSpaces.
         * </p>
         * 
         * @param workspaces
         *        The WorkSpaces to create. You can specify up to 25 WorkSpaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaces(WorkspaceRequest... workspaces);

        /**
         * <p>
         * The WorkSpaces to create. You can specify up to 25 WorkSpaces.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspaces.model.WorkspaceRequest.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.workspaces.model.WorkspaceRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspaces.model.WorkspaceRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #workspaces(List<WorkspaceRequest>)}.
         * 
         * @param workspaces
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspaces.model.WorkspaceRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workspaces(java.util.Collection<WorkspaceRequest>)
         */
        Builder workspaces(Consumer<WorkspaceRequest.Builder>... workspaces);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private List<WorkspaceRequest> workspaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkspacesRequest model) {
            super(model);
            workspaces(model.workspaces);
        }

        public final List<WorkspaceRequest.Builder> getWorkspaces() {
            List<WorkspaceRequest.Builder> result = WorkspaceRequestListCopier.copyToBuilder(this.workspaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkspaces(Collection<WorkspaceRequest.BuilderImpl> workspaces) {
            this.workspaces = WorkspaceRequestListCopier.copyFromBuilder(workspaces);
        }

        @Override
        public final Builder workspaces(Collection<WorkspaceRequest> workspaces) {
            this.workspaces = WorkspaceRequestListCopier.copy(workspaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaces(WorkspaceRequest... workspaces) {
            workspaces(Arrays.asList(workspaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaces(Consumer<WorkspaceRequest.Builder>... workspaces) {
            workspaces(Stream.of(workspaces).map(c -> WorkspaceRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkspacesRequest build() {
            return new CreateWorkspacesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
