/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.ConnectionAliasPermission;
import software.amazon.awssdk.services.workspaces.model.ConnectionAliasPermissionsCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConnectionAliasPermissionsResponse
extends WorkSpacesResponse
implements ToCopyableBuilder<Builder, DescribeConnectionAliasPermissionsResponse> {
    private static final SdkField<String> ALIAS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AliasId").getter(DescribeConnectionAliasPermissionsResponse.getter(DescribeConnectionAliasPermissionsResponse::aliasId)).setter(DescribeConnectionAliasPermissionsResponse.setter(Builder::aliasId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasId").build()}).build();
    private static final SdkField<List<ConnectionAliasPermission>> CONNECTION_ALIAS_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConnectionAliasPermissions").getter(DescribeConnectionAliasPermissionsResponse.getter(DescribeConnectionAliasPermissionsResponse::connectionAliasPermissions)).setter(DescribeConnectionAliasPermissionsResponse.setter(Builder::connectionAliasPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionAliasPermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConnectionAliasPermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeConnectionAliasPermissionsResponse.getter(DescribeConnectionAliasPermissionsResponse::nextToken)).setter(DescribeConnectionAliasPermissionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_ID_FIELD, CONNECTION_ALIAS_PERMISSIONS_FIELD, NEXT_TOKEN_FIELD));
    private final String aliasId;
    private final List<ConnectionAliasPermission> connectionAliasPermissions;
    private final String nextToken;

    private DescribeConnectionAliasPermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.aliasId = builder.aliasId;
        this.connectionAliasPermissions = builder.connectionAliasPermissions;
        this.nextToken = builder.nextToken;
    }

    public final String aliasId() {
        return this.aliasId;
    }

    public final boolean hasConnectionAliasPermissions() {
        return this.connectionAliasPermissions != null && !(this.connectionAliasPermissions instanceof SdkAutoConstructList);
    }

    public final List<ConnectionAliasPermission> connectionAliasPermissions() {
        return this.connectionAliasPermissions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionAliasPermissions() ? this.connectionAliasPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectionAliasPermissionsResponse)) {
            return false;
        }
        DescribeConnectionAliasPermissionsResponse other = (DescribeConnectionAliasPermissionsResponse)((Object)obj);
        return Objects.equals(this.aliasId(), other.aliasId()) && this.hasConnectionAliasPermissions() == other.hasConnectionAliasPermissions() && Objects.equals(this.connectionAliasPermissions(), other.connectionAliasPermissions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConnectionAliasPermissionsResponse").add("AliasId", (Object)this.aliasId()).add("ConnectionAliasPermissions", this.hasConnectionAliasPermissions() ? this.connectionAliasPermissions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AliasId": {
                return Optional.ofNullable(clazz.cast(this.aliasId()));
            }
            case "ConnectionAliasPermissions": {
                return Optional.ofNullable(clazz.cast(this.connectionAliasPermissions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectionAliasPermissionsResponse, T> g) {
        return obj -> g.apply((DescribeConnectionAliasPermissionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesResponse.BuilderImpl
    implements Builder {
        private String aliasId;
        private List<ConnectionAliasPermission> connectionAliasPermissions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectionAliasPermissionsResponse model) {
            super(model);
            this.aliasId(model.aliasId);
            this.connectionAliasPermissions(model.connectionAliasPermissions);
            this.nextToken(model.nextToken);
        }

        public final String getAliasId() {
            return this.aliasId;
        }

        @Override
        public final Builder aliasId(String aliasId) {
            this.aliasId = aliasId;
            return this;
        }

        public final void setAliasId(String aliasId) {
            this.aliasId = aliasId;
        }

        public final List<ConnectionAliasPermission.Builder> getConnectionAliasPermissions() {
            List<ConnectionAliasPermission.Builder> result = ConnectionAliasPermissionsCopier.copyToBuilder(this.connectionAliasPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder connectionAliasPermissions(Collection<ConnectionAliasPermission> connectionAliasPermissions) {
            this.connectionAliasPermissions = ConnectionAliasPermissionsCopier.copy(connectionAliasPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionAliasPermissions(ConnectionAliasPermission ... connectionAliasPermissions) {
            this.connectionAliasPermissions(Arrays.asList(connectionAliasPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionAliasPermissions(Consumer<ConnectionAliasPermission.Builder> ... connectionAliasPermissions) {
            this.connectionAliasPermissions(Stream.of(connectionAliasPermissions).map(c -> (ConnectionAliasPermission)((ConnectionAliasPermission.Builder)ConnectionAliasPermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConnectionAliasPermissions(Collection<ConnectionAliasPermission.BuilderImpl> connectionAliasPermissions) {
            this.connectionAliasPermissions = ConnectionAliasPermissionsCopier.copyFromBuilder(connectionAliasPermissions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeConnectionAliasPermissionsResponse build() {
            return new DescribeConnectionAliasPermissionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConnectionAliasPermissionsResponse> {
        public Builder aliasId(String var1);

        public Builder connectionAliasPermissions(Collection<ConnectionAliasPermission> var1);

        public Builder connectionAliasPermissions(ConnectionAliasPermission ... var1);

        public Builder connectionAliasPermissions(Consumer<ConnectionAliasPermission.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

