/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.Snapshot;
import software.amazon.awssdk.services.workspaces.model.SnapshotListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorkspaceSnapshotsResponse
extends WorkSpacesResponse
implements ToCopyableBuilder<Builder, DescribeWorkspaceSnapshotsResponse> {
    private static final SdkField<List<Snapshot>> REBUILD_SNAPSHOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RebuildSnapshots").getter(DescribeWorkspaceSnapshotsResponse.getter(DescribeWorkspaceSnapshotsResponse::rebuildSnapshots)).setter(DescribeWorkspaceSnapshotsResponse.setter(Builder::rebuildSnapshots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RebuildSnapshots").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Snapshot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Snapshot>> RESTORE_SNAPSHOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RestoreSnapshots").getter(DescribeWorkspaceSnapshotsResponse.getter(DescribeWorkspaceSnapshotsResponse::restoreSnapshots)).setter(DescribeWorkspaceSnapshotsResponse.setter(Builder::restoreSnapshots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreSnapshots").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Snapshot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REBUILD_SNAPSHOTS_FIELD, RESTORE_SNAPSHOTS_FIELD));
    private final List<Snapshot> rebuildSnapshots;
    private final List<Snapshot> restoreSnapshots;

    private DescribeWorkspaceSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.rebuildSnapshots = builder.rebuildSnapshots;
        this.restoreSnapshots = builder.restoreSnapshots;
    }

    public final boolean hasRebuildSnapshots() {
        return this.rebuildSnapshots != null && !(this.rebuildSnapshots instanceof SdkAutoConstructList);
    }

    public final List<Snapshot> rebuildSnapshots() {
        return this.rebuildSnapshots;
    }

    public final boolean hasRestoreSnapshots() {
        return this.restoreSnapshots != null && !(this.restoreSnapshots instanceof SdkAutoConstructList);
    }

    public final List<Snapshot> restoreSnapshots() {
        return this.restoreSnapshots;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRebuildSnapshots() ? this.rebuildSnapshots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRestoreSnapshots() ? this.restoreSnapshots() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspaceSnapshotsResponse)) {
            return false;
        }
        DescribeWorkspaceSnapshotsResponse other = (DescribeWorkspaceSnapshotsResponse)((Object)obj);
        return this.hasRebuildSnapshots() == other.hasRebuildSnapshots() && Objects.equals(this.rebuildSnapshots(), other.rebuildSnapshots()) && this.hasRestoreSnapshots() == other.hasRestoreSnapshots() && Objects.equals(this.restoreSnapshots(), other.restoreSnapshots());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeWorkspaceSnapshotsResponse").add("RebuildSnapshots", this.hasRebuildSnapshots() ? this.rebuildSnapshots() : null).add("RestoreSnapshots", this.hasRestoreSnapshots() ? this.restoreSnapshots() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RebuildSnapshots": {
                return Optional.ofNullable(clazz.cast(this.rebuildSnapshots()));
            }
            case "RestoreSnapshots": {
                return Optional.ofNullable(clazz.cast(this.restoreSnapshots()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspaceSnapshotsResponse, T> g) {
        return obj -> g.apply((DescribeWorkspaceSnapshotsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesResponse.BuilderImpl
    implements Builder {
        private List<Snapshot> rebuildSnapshots = DefaultSdkAutoConstructList.getInstance();
        private List<Snapshot> restoreSnapshots = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspaceSnapshotsResponse model) {
            super(model);
            this.rebuildSnapshots(model.rebuildSnapshots);
            this.restoreSnapshots(model.restoreSnapshots);
        }

        public final Collection<Snapshot.Builder> getRebuildSnapshots() {
            if (this.rebuildSnapshots instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rebuildSnapshots != null ? (Collection)this.rebuildSnapshots.stream().map(Snapshot::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rebuildSnapshots(Collection<Snapshot> rebuildSnapshots) {
            this.rebuildSnapshots = SnapshotListCopier.copy(rebuildSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rebuildSnapshots(Snapshot ... rebuildSnapshots) {
            this.rebuildSnapshots(Arrays.asList(rebuildSnapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rebuildSnapshots(Consumer<Snapshot.Builder> ... rebuildSnapshots) {
            this.rebuildSnapshots(Stream.of(rebuildSnapshots).map(c -> (Snapshot)((Snapshot.Builder)Snapshot.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRebuildSnapshots(Collection<Snapshot.BuilderImpl> rebuildSnapshots) {
            this.rebuildSnapshots = SnapshotListCopier.copyFromBuilder(rebuildSnapshots);
        }

        public final Collection<Snapshot.Builder> getRestoreSnapshots() {
            if (this.restoreSnapshots instanceof SdkAutoConstructList) {
                return null;
            }
            return this.restoreSnapshots != null ? (Collection)this.restoreSnapshots.stream().map(Snapshot::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder restoreSnapshots(Collection<Snapshot> restoreSnapshots) {
            this.restoreSnapshots = SnapshotListCopier.copy(restoreSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restoreSnapshots(Snapshot ... restoreSnapshots) {
            this.restoreSnapshots(Arrays.asList(restoreSnapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restoreSnapshots(Consumer<Snapshot.Builder> ... restoreSnapshots) {
            this.restoreSnapshots(Stream.of(restoreSnapshots).map(c -> (Snapshot)((Snapshot.Builder)Snapshot.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRestoreSnapshots(Collection<Snapshot.BuilderImpl> restoreSnapshots) {
            this.restoreSnapshots = SnapshotListCopier.copyFromBuilder(restoreSnapshots);
        }

        @Override
        public DescribeWorkspaceSnapshotsResponse build() {
            return new DescribeWorkspaceSnapshotsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorkspaceSnapshotsResponse> {
        public Builder rebuildSnapshots(Collection<Snapshot> var1);

        public Builder rebuildSnapshots(Snapshot ... var1);

        public Builder rebuildSnapshots(Consumer<Snapshot.Builder> ... var1);

        public Builder restoreSnapshots(Collection<Snapshot> var1);

        public Builder restoreSnapshots(Snapshot ... var1);

        public Builder restoreSnapshots(Consumer<Snapshot.Builder> ... var1);
    }
}

