/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterWorkspaceDirectoryRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<RegisterWorkspaceDirectoryRequest.Builder, RegisterWorkspaceDirectoryRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(RegisterWorkspaceDirectoryRequest::directoryId))
            .setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(RegisterWorkspaceDirectoryRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLE_WORK_DOCS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableWorkDocs").getter(getter(RegisterWorkspaceDirectoryRequest::enableWorkDocs))
            .setter(setter(Builder::enableWorkDocs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableWorkDocs").build()).build();

    private static final SdkField<Boolean> ENABLE_SELF_SERVICE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableSelfService").getter(getter(RegisterWorkspaceDirectoryRequest::enableSelfService))
            .setter(setter(Builder::enableSelfService))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableSelfService").build()).build();

    private static final SdkField<String> TENANCY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Tenancy")
            .getter(getter(RegisterWorkspaceDirectoryRequest::tenancyAsString)).setter(setter(Builder::tenancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(RegisterWorkspaceDirectoryRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            SUBNET_IDS_FIELD, ENABLE_WORK_DOCS_FIELD, ENABLE_SELF_SERVICE_FIELD, TENANCY_FIELD, TAGS_FIELD));

    private final String directoryId;

    private final List<String> subnetIds;

    private final Boolean enableWorkDocs;

    private final Boolean enableSelfService;

    private final String tenancy;

    private final List<Tag> tags;

    private RegisterWorkspaceDirectoryRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.subnetIds = builder.subnetIds;
        this.enableWorkDocs = builder.enableWorkDocs;
        this.enableSelfService = builder.enableSelfService;
        this.tenancy = builder.tenancy;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier of the directory. You cannot register a directory if it does not have a status of Active. If the
     * directory does not have a status of Active, you will receive an InvalidResourceStateException error. If you have
     * already registered the maximum number of directories that you can register with Amazon WorkSpaces, you will
     * receive a ResourceLimitExceededException error. Deregister directories that you are not using for WorkSpaces, and
     * try again.
     * </p>
     * 
     * @return The identifier of the directory. You cannot register a directory if it does not have a status of Active.
     *         If the directory does not have a status of Active, you will receive an InvalidResourceStateException
     *         error. If you have already registered the maximum number of directories that you can register with Amazon
     *         WorkSpaces, you will receive a ResourceLimitExceededException error. Deregister directories that you are
     *         not using for WorkSpaces, and try again.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * Returns true if the SubnetIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of the subnets for your virtual private cloud (VPC). Make sure that the subnets are in supported
     * Availability Zones. The subnets must also be in separate Availability Zones. If these conditions are not met, you
     * will receive an OperationNotSupportedException error.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubnetIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The identifiers of the subnets for your virtual private cloud (VPC). Make sure that the subnets are in
     *         supported Availability Zones. The subnets must also be in separate Availability Zones. If these
     *         conditions are not met, you will receive an OperationNotSupportedException error.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * Indicates whether Amazon WorkDocs is enabled or disabled. If you have enabled this parameter and WorkDocs is not
     * available in the Region, you will receive an OperationNotSupportedException error. Set
     * <code>EnableWorkDocs</code> to disabled, and try again.
     * </p>
     * 
     * @return Indicates whether Amazon WorkDocs is enabled or disabled. If you have enabled this parameter and WorkDocs
     *         is not available in the Region, you will receive an OperationNotSupportedException error. Set
     *         <code>EnableWorkDocs</code> to disabled, and try again.
     */
    public final Boolean enableWorkDocs() {
        return enableWorkDocs;
    }

    /**
     * <p>
     * Indicates whether self-service capabilities are enabled or disabled.
     * </p>
     * 
     * @return Indicates whether self-service capabilities are enabled or disabled.
     */
    public final Boolean enableSelfService() {
        return enableSelfService;
    }

    /**
     * <p>
     * Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own License (BYOL) images,
     * this value must be set to <code>DEDICATED</code> and your AWS account must be enabled for BYOL. If your account
     * has not been enabled for BYOL, you will receive an InvalidParameterValuesException error. For more information
     * about BYOL images, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own Windows
     * Desktop Images</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tenancyAsString}.
     * </p>
     * 
     * @return Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own License (BYOL)
     *         images, this value must be set to <code>DEDICATED</code> and your AWS account must be enabled for BYOL.
     *         If your account has not been enabled for BYOL, you will receive an InvalidParameterValuesException error.
     *         For more information about BYOL images, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own
     *         Windows Desktop Images</a>.
     * @see Tenancy
     */
    public final Tenancy tenancy() {
        return Tenancy.fromValue(tenancy);
    }

    /**
     * <p>
     * Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own License (BYOL) images,
     * this value must be set to <code>DEDICATED</code> and your AWS account must be enabled for BYOL. If your account
     * has not been enabled for BYOL, you will receive an InvalidParameterValuesException error. For more information
     * about BYOL images, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own Windows
     * Desktop Images</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tenancyAsString}.
     * </p>
     * 
     * @return Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own License (BYOL)
     *         images, this value must be set to <code>DEDICATED</code> and your AWS account must be enabled for BYOL.
     *         If your account has not been enabled for BYOL, you will receive an InvalidParameterValuesException error.
     *         For more information about BYOL images, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own
     *         Windows Desktop Images</a>.
     * @see Tenancy
     */
    public final String tenancyAsString() {
        return tenancy;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags associated with the directory.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags associated with the directory.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enableWorkDocs());
        hashCode = 31 * hashCode + Objects.hashCode(enableSelfService());
        hashCode = 31 * hashCode + Objects.hashCode(tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterWorkspaceDirectoryRequest)) {
            return false;
        }
        RegisterWorkspaceDirectoryRequest other = (RegisterWorkspaceDirectoryRequest) obj;
        return Objects.equals(directoryId(), other.directoryId()) && hasSubnetIds() == other.hasSubnetIds()
                && Objects.equals(subnetIds(), other.subnetIds()) && Objects.equals(enableWorkDocs(), other.enableWorkDocs())
                && Objects.equals(enableSelfService(), other.enableSelfService())
                && Objects.equals(tenancyAsString(), other.tenancyAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterWorkspaceDirectoryRequest").add("DirectoryId", directoryId())
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null).add("EnableWorkDocs", enableWorkDocs())
                .add("EnableSelfService", enableSelfService()).add("Tenancy", tenancyAsString())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "EnableWorkDocs":
            return Optional.ofNullable(clazz.cast(enableWorkDocs()));
        case "EnableSelfService":
            return Optional.ofNullable(clazz.cast(enableSelfService()));
        case "Tenancy":
            return Optional.ofNullable(clazz.cast(tenancyAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterWorkspaceDirectoryRequest, T> g) {
        return obj -> g.apply((RegisterWorkspaceDirectoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RegisterWorkspaceDirectoryRequest> {
        /**
         * <p>
         * The identifier of the directory. You cannot register a directory if it does not have a status of Active. If
         * the directory does not have a status of Active, you will receive an InvalidResourceStateException error. If
         * you have already registered the maximum number of directories that you can register with Amazon WorkSpaces,
         * you will receive a ResourceLimitExceededException error. Deregister directories that you are not using for
         * WorkSpaces, and try again.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the directory. You cannot register a directory if it does not have a status of
         *        Active. If the directory does not have a status of Active, you will receive an
         *        InvalidResourceStateException error. If you have already registered the maximum number of directories
         *        that you can register with Amazon WorkSpaces, you will receive a ResourceLimitExceededException error.
         *        Deregister directories that you are not using for WorkSpaces, and try again.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The identifiers of the subnets for your virtual private cloud (VPC). Make sure that the subnets are in
         * supported Availability Zones. The subnets must also be in separate Availability Zones. If these conditions
         * are not met, you will receive an OperationNotSupportedException error.
         * </p>
         * 
         * @param subnetIds
         *        The identifiers of the subnets for your virtual private cloud (VPC). Make sure that the subnets are in
         *        supported Availability Zones. The subnets must also be in separate Availability Zones. If these
         *        conditions are not met, you will receive an OperationNotSupportedException error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The identifiers of the subnets for your virtual private cloud (VPC). Make sure that the subnets are in
         * supported Availability Zones. The subnets must also be in separate Availability Zones. If these conditions
         * are not met, you will receive an OperationNotSupportedException error.
         * </p>
         * 
         * @param subnetIds
         *        The identifiers of the subnets for your virtual private cloud (VPC). Make sure that the subnets are in
         *        supported Availability Zones. The subnets must also be in separate Availability Zones. If these
         *        conditions are not met, you will receive an OperationNotSupportedException error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * Indicates whether Amazon WorkDocs is enabled or disabled. If you have enabled this parameter and WorkDocs is
         * not available in the Region, you will receive an OperationNotSupportedException error. Set
         * <code>EnableWorkDocs</code> to disabled, and try again.
         * </p>
         * 
         * @param enableWorkDocs
         *        Indicates whether Amazon WorkDocs is enabled or disabled. If you have enabled this parameter and
         *        WorkDocs is not available in the Region, you will receive an OperationNotSupportedException error. Set
         *        <code>EnableWorkDocs</code> to disabled, and try again.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableWorkDocs(Boolean enableWorkDocs);

        /**
         * <p>
         * Indicates whether self-service capabilities are enabled or disabled.
         * </p>
         * 
         * @param enableSelfService
         *        Indicates whether self-service capabilities are enabled or disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableSelfService(Boolean enableSelfService);

        /**
         * <p>
         * Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own License (BYOL)
         * images, this value must be set to <code>DEDICATED</code> and your AWS account must be enabled for BYOL. If
         * your account has not been enabled for BYOL, you will receive an InvalidParameterValuesException error. For
         * more information about BYOL images, see <a
         * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own
         * Windows Desktop Images</a>.
         * </p>
         * 
         * @param tenancy
         *        Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own License
         *        (BYOL) images, this value must be set to <code>DEDICATED</code> and your AWS account must be enabled
         *        for BYOL. If your account has not been enabled for BYOL, you will receive an
         *        InvalidParameterValuesException error. For more information about BYOL images, see <a
         *        href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your
         *        Own Windows Desktop Images</a>.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder tenancy(String tenancy);

        /**
         * <p>
         * Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own License (BYOL)
         * images, this value must be set to <code>DEDICATED</code> and your AWS account must be enabled for BYOL. If
         * your account has not been enabled for BYOL, you will receive an InvalidParameterValuesException error. For
         * more information about BYOL images, see <a
         * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own
         * Windows Desktop Images</a>.
         * </p>
         * 
         * @param tenancy
         *        Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own License
         *        (BYOL) images, this value must be set to <code>DEDICATED</code> and your AWS account must be enabled
         *        for BYOL. If your account has not been enabled for BYOL, you will receive an
         *        InvalidParameterValuesException error. For more information about BYOL images, see <a
         *        href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your
         *        Own Windows Desktop Images</a>.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder tenancy(Tenancy tenancy);

        /**
         * <p>
         * The tags associated with the directory.
         * </p>
         * 
         * @param tags
         *        The tags associated with the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags associated with the directory.
         * </p>
         * 
         * @param tags
         *        The tags associated with the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags associated with the directory.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String directoryId;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean enableWorkDocs;

        private Boolean enableSelfService;

        private String tenancy;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterWorkspaceDirectoryRequest model) {
            super(model);
            directoryId(model.directoryId);
            subnetIds(model.subnetIds);
            enableWorkDocs(model.enableWorkDocs);
            enableSelfService(model.enableSelfService);
            tenancy(model.tenancy);
            tags(model.tags);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        public final Boolean getEnableWorkDocs() {
            return enableWorkDocs;
        }

        @Override
        public final Builder enableWorkDocs(Boolean enableWorkDocs) {
            this.enableWorkDocs = enableWorkDocs;
            return this;
        }

        public final void setEnableWorkDocs(Boolean enableWorkDocs) {
            this.enableWorkDocs = enableWorkDocs;
        }

        public final Boolean getEnableSelfService() {
            return enableSelfService;
        }

        @Override
        public final Builder enableSelfService(Boolean enableSelfService) {
            this.enableSelfService = enableSelfService;
            return this;
        }

        public final void setEnableSelfService(Boolean enableSelfService) {
            this.enableSelfService = enableSelfService;
        }

        public final String getTenancy() {
            return tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(Tenancy tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterWorkspaceDirectoryRequest build() {
            return new RegisterWorkspaceDirectoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
