/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWorkspaceImagePermissionsResponse extends WorkSpacesResponse implements
        ToCopyableBuilder<DescribeWorkspaceImagePermissionsResponse.Builder, DescribeWorkspaceImagePermissionsResponse> {
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageId").getter(getter(DescribeWorkspaceImagePermissionsResponse::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()).build();

    private static final SdkField<List<ImagePermission>> IMAGE_PERMISSIONS_FIELD = SdkField
            .<List<ImagePermission>> builder(MarshallingType.LIST)
            .memberName("ImagePermissions")
            .getter(getter(DescribeWorkspaceImagePermissionsResponse::imagePermissions))
            .setter(setter(Builder::imagePermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImagePermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImagePermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImagePermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeWorkspaceImagePermissionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_ID_FIELD,
            IMAGE_PERMISSIONS_FIELD, NEXT_TOKEN_FIELD));

    private final String imageId;

    private final List<ImagePermission> imagePermissions;

    private final String nextToken;

    private DescribeWorkspaceImagePermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.imageId = builder.imageId;
        this.imagePermissions = builder.imagePermissions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The identifier of the image.
     * </p>
     * 
     * @return The identifier of the image.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * Returns true if the ImagePermissions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasImagePermissions() {
        return imagePermissions != null && !(imagePermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of the AWS accounts that the image has been shared with.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasImagePermissions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The identifiers of the AWS accounts that the image has been shared with.
     */
    public final List<ImagePermission> imagePermissions() {
        return imagePermissions;
    }

    /**
     * <p>
     * The token to use to retrieve the next set of results, or null if no more results are available.
     * </p>
     * 
     * @return The token to use to retrieve the next set of results, or null if no more results are available.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(hasImagePermissions() ? imagePermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspaceImagePermissionsResponse)) {
            return false;
        }
        DescribeWorkspaceImagePermissionsResponse other = (DescribeWorkspaceImagePermissionsResponse) obj;
        return Objects.equals(imageId(), other.imageId()) && hasImagePermissions() == other.hasImagePermissions()
                && Objects.equals(imagePermissions(), other.imagePermissions()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWorkspaceImagePermissionsResponse").add("ImageId", imageId())
                .add("ImagePermissions", hasImagePermissions() ? imagePermissions() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "ImagePermissions":
            return Optional.ofNullable(clazz.cast(imagePermissions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspaceImagePermissionsResponse, T> g) {
        return obj -> g.apply((DescribeWorkspaceImagePermissionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeWorkspaceImagePermissionsResponse> {
        /**
         * <p>
         * The identifier of the image.
         * </p>
         * 
         * @param imageId
         *        The identifier of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The identifiers of the AWS accounts that the image has been shared with.
         * </p>
         * 
         * @param imagePermissions
         *        The identifiers of the AWS accounts that the image has been shared with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imagePermissions(Collection<ImagePermission> imagePermissions);

        /**
         * <p>
         * The identifiers of the AWS accounts that the image has been shared with.
         * </p>
         * 
         * @param imagePermissions
         *        The identifiers of the AWS accounts that the image has been shared with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imagePermissions(ImagePermission... imagePermissions);

        /**
         * <p>
         * The identifiers of the AWS accounts that the image has been shared with.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ImagePermission>.Builder} avoiding the need
         * to create one manually via {@link List<ImagePermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ImagePermission>.Builder#build()} is called immediately and
         * its result is passed to {@link #imagePermissions(List<ImagePermission>)}.
         * 
         * @param imagePermissions
         *        a consumer that will call methods on {@link List<ImagePermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imagePermissions(List<ImagePermission>)
         */
        Builder imagePermissions(Consumer<ImagePermission.Builder>... imagePermissions);

        /**
         * <p>
         * The token to use to retrieve the next set of results, or null if no more results are available.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next set of results, or null if no more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends WorkSpacesResponse.BuilderImpl implements Builder {
        private String imageId;

        private List<ImagePermission> imagePermissions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspaceImagePermissionsResponse model) {
            super(model);
            imageId(model.imageId);
            imagePermissions(model.imagePermissions);
            nextToken(model.nextToken);
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final Collection<ImagePermission.Builder> getImagePermissions() {
            if (imagePermissions instanceof SdkAutoConstructList) {
                return null;
            }
            return imagePermissions != null ? imagePermissions.stream().map(ImagePermission::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder imagePermissions(Collection<ImagePermission> imagePermissions) {
            this.imagePermissions = ImagePermissionsCopier.copy(imagePermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imagePermissions(ImagePermission... imagePermissions) {
            imagePermissions(Arrays.asList(imagePermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imagePermissions(Consumer<ImagePermission.Builder>... imagePermissions) {
            imagePermissions(Stream.of(imagePermissions).map(c -> ImagePermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setImagePermissions(Collection<ImagePermission.BuilderImpl> imagePermissions) {
            this.imagePermissions = ImagePermissionsCopier.copyFromBuilder(imagePermissions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeWorkspaceImagePermissionsResponse build() {
            return new DescribeWorkspaceImagePermissionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
