/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConnectionAliasesRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<DescribeConnectionAliasesRequest.Builder, DescribeConnectionAliasesRequest> {
    private static final SdkField<List<String>> ALIAS_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AliasIds")
            .getter(getter(DescribeConnectionAliasesRequest::aliasIds))
            .setter(setter(Builder::aliasIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(DescribeConnectionAliasesRequest::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(DescribeConnectionAliasesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeConnectionAliasesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_IDS_FIELD,
            RESOURCE_ID_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> aliasIds;

    private final String resourceId;

    private final Integer limit;

    private final String nextToken;

    private DescribeConnectionAliasesRequest(BuilderImpl builder) {
        super(builder);
        this.aliasIds = builder.aliasIds;
        this.resourceId = builder.resourceId;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the AliasIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAliasIds() {
        return aliasIds != null && !(aliasIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of the connection aliases to describe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAliasIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The identifiers of the connection aliases to describe.
     */
    public final List<String> aliasIds() {
        return aliasIds;
    }

    /**
     * <p>
     * The identifier of the directory associated with the connection alias.
     * </p>
     * 
     * @return The identifier of the directory associated with the connection alias.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The maximum number of connection aliases to return.
     * </p>
     * 
     * @return The maximum number of connection aliases to return.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive
     * the next set of results.
     * </p>
     * 
     * @return If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to
     *         receive the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAliasIds() ? aliasIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectionAliasesRequest)) {
            return false;
        }
        DescribeConnectionAliasesRequest other = (DescribeConnectionAliasesRequest) obj;
        return hasAliasIds() == other.hasAliasIds() && Objects.equals(aliasIds(), other.aliasIds())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(limit(), other.limit())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConnectionAliasesRequest").add("AliasIds", hasAliasIds() ? aliasIds() : null)
                .add("ResourceId", resourceId()).add("Limit", limit()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AliasIds":
            return Optional.ofNullable(clazz.cast(aliasIds()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectionAliasesRequest, T> g) {
        return obj -> g.apply((DescribeConnectionAliasesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeConnectionAliasesRequest> {
        /**
         * <p>
         * The identifiers of the connection aliases to describe.
         * </p>
         * 
         * @param aliasIds
         *        The identifiers of the connection aliases to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasIds(Collection<String> aliasIds);

        /**
         * <p>
         * The identifiers of the connection aliases to describe.
         * </p>
         * 
         * @param aliasIds
         *        The identifiers of the connection aliases to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasIds(String... aliasIds);

        /**
         * <p>
         * The identifier of the directory associated with the connection alias.
         * </p>
         * 
         * @param resourceId
         *        The identifier of the directory associated with the connection alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The maximum number of connection aliases to return.
         * </p>
         * 
         * @param limit
         *        The maximum number of connection aliases to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to
         * receive the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If you received a <code>NextToken</code> from a previous call that was paginated, provide this token
         *        to receive the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private List<String> aliasIds = DefaultSdkAutoConstructList.getInstance();

        private String resourceId;

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectionAliasesRequest model) {
            super(model);
            aliasIds(model.aliasIds);
            resourceId(model.resourceId);
            limit(model.limit);
            nextToken(model.nextToken);
        }

        public final Collection<String> getAliasIds() {
            if (aliasIds instanceof SdkAutoConstructList) {
                return null;
            }
            return aliasIds;
        }

        @Override
        public final Builder aliasIds(Collection<String> aliasIds) {
            this.aliasIds = ConnectionAliasIdListCopier.copy(aliasIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliasIds(String... aliasIds) {
            aliasIds(Arrays.asList(aliasIds));
            return this;
        }

        public final void setAliasIds(Collection<String> aliasIds) {
            this.aliasIds = ConnectionAliasIdListCopier.copy(aliasIds);
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConnectionAliasesRequest build() {
            return new DescribeConnectionAliasesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
