/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.TerminateRequest;
import software.amazon.awssdk.services.workspaces.model.TerminateWorkspaceRequestsCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TerminateWorkspacesRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, TerminateWorkspacesRequest> {
    private static final SdkField<List<TerminateRequest>> TERMINATE_WORKSPACE_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TerminateWorkspacesRequest.getter(TerminateWorkspacesRequest::terminateWorkspaceRequests)).setter(TerminateWorkspacesRequest.setter(Builder::terminateWorkspaceRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminateWorkspaceRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TerminateRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TERMINATE_WORKSPACE_REQUESTS_FIELD));
    private final List<TerminateRequest> terminateWorkspaceRequests;

    private TerminateWorkspacesRequest(BuilderImpl builder) {
        super(builder);
        this.terminateWorkspaceRequests = builder.terminateWorkspaceRequests;
    }

    public boolean hasTerminateWorkspaceRequests() {
        return this.terminateWorkspaceRequests != null && !(this.terminateWorkspaceRequests instanceof SdkAutoConstructList);
    }

    public List<TerminateRequest> terminateWorkspaceRequests() {
        return this.terminateWorkspaceRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.terminateWorkspaceRequests());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateWorkspacesRequest)) {
            return false;
        }
        TerminateWorkspacesRequest other = (TerminateWorkspacesRequest)((Object)obj);
        return Objects.equals(this.terminateWorkspaceRequests(), other.terminateWorkspaceRequests());
    }

    public String toString() {
        return ToString.builder((String)"TerminateWorkspacesRequest").add("TerminateWorkspaceRequests", this.terminateWorkspaceRequests()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TerminateWorkspaceRequests": {
                return Optional.ofNullable(clazz.cast(this.terminateWorkspaceRequests()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TerminateWorkspacesRequest, T> g) {
        return obj -> g.apply((TerminateWorkspacesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private List<TerminateRequest> terminateWorkspaceRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateWorkspacesRequest model) {
            super(model);
            this.terminateWorkspaceRequests(model.terminateWorkspaceRequests);
        }

        public final Collection<TerminateRequest.Builder> getTerminateWorkspaceRequests() {
            return this.terminateWorkspaceRequests != null ? (Collection)this.terminateWorkspaceRequests.stream().map(TerminateRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder terminateWorkspaceRequests(Collection<TerminateRequest> terminateWorkspaceRequests) {
            this.terminateWorkspaceRequests = TerminateWorkspaceRequestsCopier.copy(terminateWorkspaceRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminateWorkspaceRequests(TerminateRequest ... terminateWorkspaceRequests) {
            this.terminateWorkspaceRequests(Arrays.asList(terminateWorkspaceRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminateWorkspaceRequests(Consumer<TerminateRequest.Builder> ... terminateWorkspaceRequests) {
            this.terminateWorkspaceRequests(Stream.of(terminateWorkspaceRequests).map(c -> (TerminateRequest)((TerminateRequest.Builder)TerminateRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTerminateWorkspaceRequests(Collection<TerminateRequest.BuilderImpl> terminateWorkspaceRequests) {
            this.terminateWorkspaceRequests = TerminateWorkspaceRequestsCopier.copyFromBuilder(terminateWorkspaceRequests);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TerminateWorkspacesRequest build() {
            return new TerminateWorkspacesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TerminateWorkspacesRequest> {
        public Builder terminateWorkspaceRequests(Collection<TerminateRequest> var1);

        public Builder terminateWorkspaceRequests(TerminateRequest ... var1);

        public Builder terminateWorkspaceRequests(Consumer<TerminateRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

