/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.services.workspaces.model.WorkspaceProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyWorkspacePropertiesRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, ModifyWorkspacePropertiesRequest> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyWorkspacePropertiesRequest.getter(ModifyWorkspacePropertiesRequest::workspaceId)).setter(ModifyWorkspacePropertiesRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceId").build()}).build();
    private static final SdkField<WorkspaceProperties> WORKSPACE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ModifyWorkspacePropertiesRequest.getter(ModifyWorkspacePropertiesRequest::workspaceProperties)).setter(ModifyWorkspacePropertiesRequest.setter(Builder::workspaceProperties)).constructor(WorkspaceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD, WORKSPACE_PROPERTIES_FIELD));
    private final String workspaceId;
    private final WorkspaceProperties workspaceProperties;

    private ModifyWorkspacePropertiesRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceId = builder.workspaceId;
        this.workspaceProperties = builder.workspaceProperties;
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public WorkspaceProperties workspaceProperties() {
        return this.workspaceProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceProperties());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyWorkspacePropertiesRequest)) {
            return false;
        }
        ModifyWorkspacePropertiesRequest other = (ModifyWorkspacePropertiesRequest)((Object)obj);
        return Objects.equals(this.workspaceId(), other.workspaceId()) && Objects.equals(this.workspaceProperties(), other.workspaceProperties());
    }

    public String toString() {
        return ToString.builder((String)"ModifyWorkspacePropertiesRequest").add("WorkspaceId", (Object)this.workspaceId()).add("WorkspaceProperties", (Object)this.workspaceProperties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
            case "WorkspaceProperties": {
                return Optional.ofNullable(clazz.cast(this.workspaceProperties()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyWorkspacePropertiesRequest, T> g) {
        return obj -> g.apply((ModifyWorkspacePropertiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private String workspaceId;
        private WorkspaceProperties workspaceProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyWorkspacePropertiesRequest model) {
            super(model);
            this.workspaceId(model.workspaceId);
            this.workspaceProperties(model.workspaceProperties);
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        public final WorkspaceProperties.Builder getWorkspaceProperties() {
            return this.workspaceProperties != null ? this.workspaceProperties.toBuilder() : null;
        }

        @Override
        public final Builder workspaceProperties(WorkspaceProperties workspaceProperties) {
            this.workspaceProperties = workspaceProperties;
            return this;
        }

        public final void setWorkspaceProperties(WorkspaceProperties.BuilderImpl workspaceProperties) {
            this.workspaceProperties = workspaceProperties != null ? workspaceProperties.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyWorkspacePropertiesRequest build() {
            return new ModifyWorkspacePropertiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyWorkspacePropertiesRequest> {
        public Builder workspaceId(String var1);

        public Builder workspaceProperties(WorkspaceProperties var1);

        default public Builder workspaceProperties(Consumer<WorkspaceProperties.Builder> workspaceProperties) {
            return this.workspaceProperties((WorkspaceProperties)((WorkspaceProperties.Builder)WorkspaceProperties.builder().applyMutation(workspaceProperties)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

