/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesResponse;
import software.amazon.awssdk.services.workspaces.model.Workspace;
import software.amazon.awssdk.services.workspaces.model.WorkspaceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorkspacesResponse
extends WorkSpacesResponse
implements ToCopyableBuilder<Builder, DescribeWorkspacesResponse> {
    private static final SdkField<List<Workspace>> WORKSPACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeWorkspacesResponse.getter(DescribeWorkspacesResponse::workspaces)).setter(DescribeWorkspacesResponse.setter(Builder::workspaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Workspaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Workspace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeWorkspacesResponse.getter(DescribeWorkspacesResponse::nextToken)).setter(DescribeWorkspacesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACES_FIELD, NEXT_TOKEN_FIELD));
    private final List<Workspace> workspaces;
    private final String nextToken;

    private DescribeWorkspacesResponse(BuilderImpl builder) {
        super(builder);
        this.workspaces = builder.workspaces;
        this.nextToken = builder.nextToken;
    }

    public boolean hasWorkspaces() {
        return this.workspaces != null && !(this.workspaces instanceof SdkAutoConstructList);
    }

    public List<Workspace> workspaces() {
        return this.workspaces;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspacesResponse)) {
            return false;
        }
        DescribeWorkspacesResponse other = (DescribeWorkspacesResponse)((Object)obj);
        return Objects.equals(this.workspaces(), other.workspaces()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeWorkspacesResponse").add("Workspaces", this.workspaces()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Workspaces": {
                return Optional.ofNullable(clazz.cast(this.workspaces()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspacesResponse, T> g) {
        return obj -> g.apply((DescribeWorkspacesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesResponse.BuilderImpl
    implements Builder {
        private List<Workspace> workspaces = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspacesResponse model) {
            super(model);
            this.workspaces(model.workspaces);
            this.nextToken(model.nextToken);
        }

        public final Collection<Workspace.Builder> getWorkspaces() {
            return this.workspaces != null ? (Collection)this.workspaces.stream().map(Workspace::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder workspaces(Collection<Workspace> workspaces) {
            this.workspaces = WorkspaceListCopier.copy(workspaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaces(Workspace ... workspaces) {
            this.workspaces(Arrays.asList(workspaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaces(Consumer<Workspace.Builder> ... workspaces) {
            this.workspaces(Stream.of(workspaces).map(c -> (Workspace)((Workspace.Builder)Workspace.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWorkspaces(Collection<Workspace.BuilderImpl> workspaces) {
            this.workspaces = WorkspaceListCopier.copyFromBuilder(workspaces);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeWorkspacesResponse build() {
            return new DescribeWorkspacesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorkspacesResponse> {
        public Builder workspaces(Collection<Workspace> var1);

        public Builder workspaces(Workspace ... var1);

        public Builder workspaces(Consumer<Workspace.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

