/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyClientPropertiesRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<ModifyClientPropertiesRequest.Builder, ModifyClientPropertiesRequest> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyClientPropertiesRequest::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<ClientProperties> CLIENT_PROPERTIES_FIELD = SdkField
            .<ClientProperties> builder(MarshallingType.SDK_POJO).getter(getter(ModifyClientPropertiesRequest::clientProperties))
            .setter(setter(Builder::clientProperties)).constructor(ClientProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientProperties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            CLIENT_PROPERTIES_FIELD));

    private final String resourceId;

    private final ClientProperties clientProperties;

    private ModifyClientPropertiesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.clientProperties = builder.clientProperties;
    }

    /**
     * <p>
     * The resource identifiers, in the form of directory IDs.
     * </p>
     * 
     * @return The resource identifiers, in the form of directory IDs.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * Information about the Amazon WorkSpaces client.
     * </p>
     * 
     * @return Information about the Amazon WorkSpaces client.
     */
    public ClientProperties clientProperties() {
        return clientProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(clientProperties());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyClientPropertiesRequest)) {
            return false;
        }
        ModifyClientPropertiesRequest other = (ModifyClientPropertiesRequest) obj;
        return Objects.equals(resourceId(), other.resourceId()) && Objects.equals(clientProperties(), other.clientProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyClientPropertiesRequest").add("ResourceId", resourceId())
                .add("ClientProperties", clientProperties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ClientProperties":
            return Optional.ofNullable(clazz.cast(clientProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyClientPropertiesRequest, T> g) {
        return obj -> g.apply((ModifyClientPropertiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyClientPropertiesRequest> {
        /**
         * <p>
         * The resource identifiers, in the form of directory IDs.
         * </p>
         * 
         * @param resourceId
         *        The resource identifiers, in the form of directory IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * Information about the Amazon WorkSpaces client.
         * </p>
         * 
         * @param clientProperties
         *        Information about the Amazon WorkSpaces client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientProperties(ClientProperties clientProperties);

        /**
         * <p>
         * Information about the Amazon WorkSpaces client.
         * </p>
         * This is a convenience that creates an instance of the {@link ClientProperties.Builder} avoiding the need to
         * create one manually via {@link ClientProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClientProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #clientProperties(ClientProperties)}.
         * 
         * @param clientProperties
         *        a consumer that will call methods on {@link ClientProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientProperties(ClientProperties)
         */
        default Builder clientProperties(Consumer<ClientProperties.Builder> clientProperties) {
            return clientProperties(ClientProperties.builder().applyMutation(clientProperties).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String resourceId;

        private ClientProperties clientProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyClientPropertiesRequest model) {
            super(model);
            resourceId(model.resourceId);
            clientProperties(model.clientProperties);
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final ClientProperties.Builder getClientProperties() {
            return clientProperties != null ? clientProperties.toBuilder() : null;
        }

        @Override
        public final Builder clientProperties(ClientProperties clientProperties) {
            this.clientProperties = clientProperties;
            return this;
        }

        public final void setClientProperties(ClientProperties.BuilderImpl clientProperties) {
            this.clientProperties = clientProperties != null ? clientProperties.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyClientPropertiesRequest build() {
            return new ModifyClientPropertiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
