/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a WorkSpace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Workspace implements SdkPojo, Serializable, ToCopyableBuilder<Workspace.Builder, Workspace> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Workspace::workspaceId)).setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceId").build()).build();

    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Workspace::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Workspace::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Workspace::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Workspace::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Workspace::bundleId)).setter(setter(Builder::bundleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleId").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Workspace::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Workspace::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Workspace::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> COMPUTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Workspace::computerName)).setter(setter(Builder::computerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputerName").build()).build();

    private static final SdkField<String> VOLUME_ENCRYPTION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Workspace::volumeEncryptionKey)).setter(setter(Builder::volumeEncryptionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeEncryptionKey").build())
            .build();

    private static final SdkField<Boolean> USER_VOLUME_ENCRYPTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Workspace::userVolumeEncryptionEnabled))
            .setter(setter(Builder::userVolumeEncryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserVolumeEncryptionEnabled")
                    .build()).build();

    private static final SdkField<Boolean> ROOT_VOLUME_ENCRYPTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Workspace::rootVolumeEncryptionEnabled))
            .setter(setter(Builder::rootVolumeEncryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootVolumeEncryptionEnabled")
                    .build()).build();

    private static final SdkField<WorkspaceProperties> WORKSPACE_PROPERTIES_FIELD = SdkField
            .<WorkspaceProperties> builder(MarshallingType.SDK_POJO).getter(getter(Workspace::workspaceProperties))
            .setter(setter(Builder::workspaceProperties)).constructor(WorkspaceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceProperties").build())
            .build();

    private static final SdkField<List<ModificationState>> MODIFICATION_STATES_FIELD = SdkField
            .<List<ModificationState>> builder(MarshallingType.LIST)
            .getter(getter(Workspace::modificationStates))
            .setter(setter(Builder::modificationStates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationStates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModificationState> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModificationState::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD,
            DIRECTORY_ID_FIELD, USER_NAME_FIELD, IP_ADDRESS_FIELD, STATE_FIELD, BUNDLE_ID_FIELD, SUBNET_ID_FIELD,
            ERROR_MESSAGE_FIELD, ERROR_CODE_FIELD, COMPUTER_NAME_FIELD, VOLUME_ENCRYPTION_KEY_FIELD,
            USER_VOLUME_ENCRYPTION_ENABLED_FIELD, ROOT_VOLUME_ENCRYPTION_ENABLED_FIELD, WORKSPACE_PROPERTIES_FIELD,
            MODIFICATION_STATES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String workspaceId;

    private final String directoryId;

    private final String userName;

    private final String ipAddress;

    private final String state;

    private final String bundleId;

    private final String subnetId;

    private final String errorMessage;

    private final String errorCode;

    private final String computerName;

    private final String volumeEncryptionKey;

    private final Boolean userVolumeEncryptionEnabled;

    private final Boolean rootVolumeEncryptionEnabled;

    private final WorkspaceProperties workspaceProperties;

    private final List<ModificationState> modificationStates;

    private Workspace(BuilderImpl builder) {
        this.workspaceId = builder.workspaceId;
        this.directoryId = builder.directoryId;
        this.userName = builder.userName;
        this.ipAddress = builder.ipAddress;
        this.state = builder.state;
        this.bundleId = builder.bundleId;
        this.subnetId = builder.subnetId;
        this.errorMessage = builder.errorMessage;
        this.errorCode = builder.errorCode;
        this.computerName = builder.computerName;
        this.volumeEncryptionKey = builder.volumeEncryptionKey;
        this.userVolumeEncryptionEnabled = builder.userVolumeEncryptionEnabled;
        this.rootVolumeEncryptionEnabled = builder.rootVolumeEncryptionEnabled;
        this.workspaceProperties = builder.workspaceProperties;
        this.modificationStates = builder.modificationStates;
    }

    /**
     * <p>
     * The identifier of the WorkSpace.
     * </p>
     * 
     * @return The identifier of the WorkSpace.
     */
    public String workspaceId() {
        return workspaceId;
    }

    /**
     * <p>
     * The identifier of the AWS Directory Service directory for the WorkSpace.
     * </p>
     * 
     * @return The identifier of the AWS Directory Service directory for the WorkSpace.
     */
    public String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The user for the WorkSpace.
     * </p>
     * 
     * @return The user for the WorkSpace.
     */
    public String userName() {
        return userName;
    }

    /**
     * <p>
     * The IP address of the WorkSpace.
     * </p>
     * 
     * @return The IP address of the WorkSpace.
     */
    public String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * The operational state of the WorkSpace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link WorkspaceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The operational state of the WorkSpace.
     * @see WorkspaceState
     */
    public WorkspaceState state() {
        return WorkspaceState.fromValue(state);
    }

    /**
     * <p>
     * The operational state of the WorkSpace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link WorkspaceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The operational state of the WorkSpace.
     * @see WorkspaceState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The identifier of the bundle used to create the WorkSpace.
     * </p>
     * 
     * @return The identifier of the bundle used to create the WorkSpace.
     */
    public String bundleId() {
        return bundleId;
    }

    /**
     * <p>
     * The identifier of the subnet for the WorkSpace.
     * </p>
     * 
     * @return The identifier of the subnet for the WorkSpace.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The text of the error message that is returned if the WorkSpace cannot be created.
     * </p>
     * 
     * @return The text of the error message that is returned if the WorkSpace cannot be created.
     */
    public String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The error code that is returned if the WorkSpace cannot be created.
     * </p>
     * 
     * @return The error code that is returned if the WorkSpace cannot be created.
     */
    public String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The name of the WorkSpace, as seen by the operating system.
     * </p>
     * 
     * @return The name of the WorkSpace, as seen by the operating system.
     */
    public String computerName() {
        return computerName;
    }

    /**
     * <p>
     * The symmetric AWS KMS customer master key (CMK) used to encrypt data stored on your WorkSpace. Amazon WorkSpaces
     * does not support asymmetric CMKs.
     * </p>
     * 
     * @return The symmetric AWS KMS customer master key (CMK) used to encrypt data stored on your WorkSpace. Amazon
     *         WorkSpaces does not support asymmetric CMKs.
     */
    public String volumeEncryptionKey() {
        return volumeEncryptionKey;
    }

    /**
     * <p>
     * Indicates whether the data stored on the user volume is encrypted.
     * </p>
     * 
     * @return Indicates whether the data stored on the user volume is encrypted.
     */
    public Boolean userVolumeEncryptionEnabled() {
        return userVolumeEncryptionEnabled;
    }

    /**
     * <p>
     * Indicates whether the data stored on the root volume is encrypted.
     * </p>
     * 
     * @return Indicates whether the data stored on the root volume is encrypted.
     */
    public Boolean rootVolumeEncryptionEnabled() {
        return rootVolumeEncryptionEnabled;
    }

    /**
     * <p>
     * The properties of the WorkSpace.
     * </p>
     * 
     * @return The properties of the WorkSpace.
     */
    public WorkspaceProperties workspaceProperties() {
        return workspaceProperties;
    }

    /**
     * Returns true if the ModificationStates property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasModificationStates() {
        return modificationStates != null && !(modificationStates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The modification states of the WorkSpace.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasModificationStates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The modification states of the WorkSpace.
     */
    public List<ModificationState> modificationStates() {
        return modificationStates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(computerName());
        hashCode = 31 * hashCode + Objects.hashCode(volumeEncryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(userVolumeEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(rootVolumeEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(modificationStates());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Workspace)) {
            return false;
        }
        Workspace other = (Workspace) obj;
        return Objects.equals(workspaceId(), other.workspaceId()) && Objects.equals(directoryId(), other.directoryId())
                && Objects.equals(userName(), other.userName()) && Objects.equals(ipAddress(), other.ipAddress())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(bundleId(), other.bundleId())
                && Objects.equals(subnetId(), other.subnetId()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(errorCode(), other.errorCode()) && Objects.equals(computerName(), other.computerName())
                && Objects.equals(volumeEncryptionKey(), other.volumeEncryptionKey())
                && Objects.equals(userVolumeEncryptionEnabled(), other.userVolumeEncryptionEnabled())
                && Objects.equals(rootVolumeEncryptionEnabled(), other.rootVolumeEncryptionEnabled())
                && Objects.equals(workspaceProperties(), other.workspaceProperties())
                && Objects.equals(modificationStates(), other.modificationStates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Workspace").add("WorkspaceId", workspaceId()).add("DirectoryId", directoryId())
                .add("UserName", userName()).add("IpAddress", ipAddress()).add("State", stateAsString())
                .add("BundleId", bundleId()).add("SubnetId", subnetId()).add("ErrorMessage", errorMessage())
                .add("ErrorCode", errorCode()).add("ComputerName", computerName())
                .add("VolumeEncryptionKey", volumeEncryptionKey())
                .add("UserVolumeEncryptionEnabled", userVolumeEncryptionEnabled())
                .add("RootVolumeEncryptionEnabled", rootVolumeEncryptionEnabled())
                .add("WorkspaceProperties", workspaceProperties()).add("ModificationStates", modificationStates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "IpAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "BundleId":
            return Optional.ofNullable(clazz.cast(bundleId()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "ComputerName":
            return Optional.ofNullable(clazz.cast(computerName()));
        case "VolumeEncryptionKey":
            return Optional.ofNullable(clazz.cast(volumeEncryptionKey()));
        case "UserVolumeEncryptionEnabled":
            return Optional.ofNullable(clazz.cast(userVolumeEncryptionEnabled()));
        case "RootVolumeEncryptionEnabled":
            return Optional.ofNullable(clazz.cast(rootVolumeEncryptionEnabled()));
        case "WorkspaceProperties":
            return Optional.ofNullable(clazz.cast(workspaceProperties()));
        case "ModificationStates":
            return Optional.ofNullable(clazz.cast(modificationStates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Workspace, T> g) {
        return obj -> g.apply((Workspace) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Workspace> {
        /**
         * <p>
         * The identifier of the WorkSpace.
         * </p>
         * 
         * @param workspaceId
         *        The identifier of the WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        /**
         * <p>
         * The identifier of the AWS Directory Service directory for the WorkSpace.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the AWS Directory Service directory for the WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The user for the WorkSpace.
         * </p>
         * 
         * @param userName
         *        The user for the WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The IP address of the WorkSpace.
         * </p>
         * 
         * @param ipAddress
         *        The IP address of the WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * The operational state of the WorkSpace.
         * </p>
         * 
         * @param state
         *        The operational state of the WorkSpace.
         * @see WorkspaceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkspaceState
         */
        Builder state(String state);

        /**
         * <p>
         * The operational state of the WorkSpace.
         * </p>
         * 
         * @param state
         *        The operational state of the WorkSpace.
         * @see WorkspaceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkspaceState
         */
        Builder state(WorkspaceState state);

        /**
         * <p>
         * The identifier of the bundle used to create the WorkSpace.
         * </p>
         * 
         * @param bundleId
         *        The identifier of the bundle used to create the WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        /**
         * <p>
         * The identifier of the subnet for the WorkSpace.
         * </p>
         * 
         * @param subnetId
         *        The identifier of the subnet for the WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The text of the error message that is returned if the WorkSpace cannot be created.
         * </p>
         * 
         * @param errorMessage
         *        The text of the error message that is returned if the WorkSpace cannot be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The error code that is returned if the WorkSpace cannot be created.
         * </p>
         * 
         * @param errorCode
         *        The error code that is returned if the WorkSpace cannot be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The name of the WorkSpace, as seen by the operating system.
         * </p>
         * 
         * @param computerName
         *        The name of the WorkSpace, as seen by the operating system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computerName(String computerName);

        /**
         * <p>
         * The symmetric AWS KMS customer master key (CMK) used to encrypt data stored on your WorkSpace. Amazon
         * WorkSpaces does not support asymmetric CMKs.
         * </p>
         * 
         * @param volumeEncryptionKey
         *        The symmetric AWS KMS customer master key (CMK) used to encrypt data stored on your WorkSpace. Amazon
         *        WorkSpaces does not support asymmetric CMKs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeEncryptionKey(String volumeEncryptionKey);

        /**
         * <p>
         * Indicates whether the data stored on the user volume is encrypted.
         * </p>
         * 
         * @param userVolumeEncryptionEnabled
         *        Indicates whether the data stored on the user volume is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userVolumeEncryptionEnabled(Boolean userVolumeEncryptionEnabled);

        /**
         * <p>
         * Indicates whether the data stored on the root volume is encrypted.
         * </p>
         * 
         * @param rootVolumeEncryptionEnabled
         *        Indicates whether the data stored on the root volume is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootVolumeEncryptionEnabled(Boolean rootVolumeEncryptionEnabled);

        /**
         * <p>
         * The properties of the WorkSpace.
         * </p>
         * 
         * @param workspaceProperties
         *        The properties of the WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceProperties(WorkspaceProperties workspaceProperties);

        /**
         * <p>
         * The properties of the WorkSpace.
         * </p>
         * This is a convenience that creates an instance of the {@link WorkspaceProperties.Builder} avoiding the need
         * to create one manually via {@link WorkspaceProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkspaceProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #workspaceProperties(WorkspaceProperties)}.
         * 
         * @param workspaceProperties
         *        a consumer that will call methods on {@link WorkspaceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workspaceProperties(WorkspaceProperties)
         */
        default Builder workspaceProperties(Consumer<WorkspaceProperties.Builder> workspaceProperties) {
            return workspaceProperties(WorkspaceProperties.builder().applyMutation(workspaceProperties).build());
        }

        /**
         * <p>
         * The modification states of the WorkSpace.
         * </p>
         * 
         * @param modificationStates
         *        The modification states of the WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modificationStates(Collection<ModificationState> modificationStates);

        /**
         * <p>
         * The modification states of the WorkSpace.
         * </p>
         * 
         * @param modificationStates
         *        The modification states of the WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modificationStates(ModificationState... modificationStates);

        /**
         * <p>
         * The modification states of the WorkSpace.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ModificationState>.Builder} avoiding the
         * need to create one manually via {@link List<ModificationState>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ModificationState>.Builder#build()} is called immediately
         * and its result is passed to {@link #modificationStates(List<ModificationState>)}.
         * 
         * @param modificationStates
         *        a consumer that will call methods on {@link List<ModificationState>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modificationStates(List<ModificationState>)
         */
        Builder modificationStates(Consumer<ModificationState.Builder>... modificationStates);
    }

    static final class BuilderImpl implements Builder {
        private String workspaceId;

        private String directoryId;

        private String userName;

        private String ipAddress;

        private String state;

        private String bundleId;

        private String subnetId;

        private String errorMessage;

        private String errorCode;

        private String computerName;

        private String volumeEncryptionKey;

        private Boolean userVolumeEncryptionEnabled;

        private Boolean rootVolumeEncryptionEnabled;

        private WorkspaceProperties workspaceProperties;

        private List<ModificationState> modificationStates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Workspace model) {
            workspaceId(model.workspaceId);
            directoryId(model.directoryId);
            userName(model.userName);
            ipAddress(model.ipAddress);
            state(model.state);
            bundleId(model.bundleId);
            subnetId(model.subnetId);
            errorMessage(model.errorMessage);
            errorCode(model.errorCode);
            computerName(model.computerName);
            volumeEncryptionKey(model.volumeEncryptionKey);
            userVolumeEncryptionEnabled(model.userVolumeEncryptionEnabled);
            rootVolumeEncryptionEnabled(model.rootVolumeEncryptionEnabled);
            workspaceProperties(model.workspaceProperties);
            modificationStates(model.modificationStates);
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final String getUserName() {
            return userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(WorkspaceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getBundleId() {
            return bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getComputerName() {
            return computerName;
        }

        @Override
        public final Builder computerName(String computerName) {
            this.computerName = computerName;
            return this;
        }

        public final void setComputerName(String computerName) {
            this.computerName = computerName;
        }

        public final String getVolumeEncryptionKey() {
            return volumeEncryptionKey;
        }

        @Override
        public final Builder volumeEncryptionKey(String volumeEncryptionKey) {
            this.volumeEncryptionKey = volumeEncryptionKey;
            return this;
        }

        public final void setVolumeEncryptionKey(String volumeEncryptionKey) {
            this.volumeEncryptionKey = volumeEncryptionKey;
        }

        public final Boolean getUserVolumeEncryptionEnabled() {
            return userVolumeEncryptionEnabled;
        }

        @Override
        public final Builder userVolumeEncryptionEnabled(Boolean userVolumeEncryptionEnabled) {
            this.userVolumeEncryptionEnabled = userVolumeEncryptionEnabled;
            return this;
        }

        public final void setUserVolumeEncryptionEnabled(Boolean userVolumeEncryptionEnabled) {
            this.userVolumeEncryptionEnabled = userVolumeEncryptionEnabled;
        }

        public final Boolean getRootVolumeEncryptionEnabled() {
            return rootVolumeEncryptionEnabled;
        }

        @Override
        public final Builder rootVolumeEncryptionEnabled(Boolean rootVolumeEncryptionEnabled) {
            this.rootVolumeEncryptionEnabled = rootVolumeEncryptionEnabled;
            return this;
        }

        public final void setRootVolumeEncryptionEnabled(Boolean rootVolumeEncryptionEnabled) {
            this.rootVolumeEncryptionEnabled = rootVolumeEncryptionEnabled;
        }

        public final WorkspaceProperties.Builder getWorkspaceProperties() {
            return workspaceProperties != null ? workspaceProperties.toBuilder() : null;
        }

        @Override
        public final Builder workspaceProperties(WorkspaceProperties workspaceProperties) {
            this.workspaceProperties = workspaceProperties;
            return this;
        }

        public final void setWorkspaceProperties(WorkspaceProperties.BuilderImpl workspaceProperties) {
            this.workspaceProperties = workspaceProperties != null ? workspaceProperties.build() : null;
        }

        public final Collection<ModificationState.Builder> getModificationStates() {
            return modificationStates != null ? modificationStates.stream().map(ModificationState::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder modificationStates(Collection<ModificationState> modificationStates) {
            this.modificationStates = ModificationStateListCopier.copy(modificationStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modificationStates(ModificationState... modificationStates) {
            modificationStates(Arrays.asList(modificationStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modificationStates(Consumer<ModificationState.Builder>... modificationStates) {
            modificationStates(Stream.of(modificationStates).map(c -> ModificationState.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setModificationStates(Collection<ModificationState.BuilderImpl> modificationStates) {
            this.modificationStates = ModificationStateListCopier.copyFromBuilder(modificationStates);
        }

        @Override
        public Workspace build() {
            return new Workspace(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
