/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Snapshot implements SdkPojo, Serializable, ToCopyableBuilder<Snapshot.Builder, Snapshot> {
    private static final SdkField<Instant> SNAPSHOT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Snapshot::snapshotTime)).setter(setter(Builder::snapshotTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant snapshotTime;

    private Snapshot(BuilderImpl builder) {
        this.snapshotTime = builder.snapshotTime;
    }

    /**
     * <p>
     * The time when the snapshot was created.
     * </p>
     * 
     * @return The time when the snapshot was created.
     */
    public Instant snapshotTime() {
        return snapshotTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snapshotTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Snapshot)) {
            return false;
        }
        Snapshot other = (Snapshot) obj;
        return Objects.equals(snapshotTime(), other.snapshotTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Snapshot").add("SnapshotTime", snapshotTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotTime":
            return Optional.ofNullable(clazz.cast(snapshotTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Snapshot, T> g) {
        return obj -> g.apply((Snapshot) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Snapshot> {
        /**
         * <p>
         * The time when the snapshot was created.
         * </p>
         * 
         * @param snapshotTime
         *        The time when the snapshot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotTime(Instant snapshotTime);
    }

    static final class BuilderImpl implements Builder {
        private Instant snapshotTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Snapshot model) {
            snapshotTime(model.snapshotTime);
        }

        public final Instant getSnapshotTime() {
            return snapshotTime;
        }

        @Override
        public final Builder snapshotTime(Instant snapshotTime) {
            this.snapshotTime = snapshotTime;
            return this;
        }

        public final void setSnapshotTime(Instant snapshotTime) {
            this.snapshotTime = snapshotTime;
        }

        @Override
        public Snapshot build() {
            return new Snapshot(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
