/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workmail.model.WorkMailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResetPasswordRequest
extends WorkMailRequest
implements ToCopyableBuilder<Builder, ResetPasswordRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationId").getter(ResetPasswordRequest.getter(ResetPasswordRequest::organizationId)).setter(ResetPasswordRequest.setter(Builder::organizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(ResetPasswordRequest.getter(ResetPasswordRequest::userId)).setter(ResetPasswordRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Password").getter(ResetPasswordRequest.getter(ResetPasswordRequest::password)).setter(ResetPasswordRequest.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD, USER_ID_FIELD, PASSWORD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OrganizationId", ORGANIZATION_ID_FIELD);
            this.put("UserId", USER_ID_FIELD);
            this.put("Password", PASSWORD_FIELD);
        }
    });
    private final String organizationId;
    private final String userId;
    private final String password;

    private ResetPasswordRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.userId = builder.userId;
        this.password = builder.password;
    }

    public final String organizationId() {
        return this.organizationId;
    }

    public final String userId() {
        return this.userId;
    }

    public final String password() {
        return this.password;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetPasswordRequest)) {
            return false;
        }
        ResetPasswordRequest other = (ResetPasswordRequest)((Object)obj);
        return Objects.equals(this.organizationId(), other.organizationId()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.password(), other.password());
    }

    public final String toString() {
        return ToString.builder((String)"ResetPasswordRequest").add("OrganizationId", (Object)this.organizationId()).add("UserId", (Object)this.userId()).add("Password", (Object)(this.password() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationId": {
                return Optional.ofNullable(clazz.cast(this.organizationId()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResetPasswordRequest, T> g) {
        return obj -> g.apply((ResetPasswordRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailRequest.BuilderImpl
    implements Builder {
        private String organizationId;
        private String userId;
        private String password;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetPasswordRequest model) {
            super(model);
            this.organizationId(model.organizationId);
            this.userId(model.userId);
            this.password(model.password);
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getPassword() {
            return this.password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResetPasswordRequest build() {
            return new ResetPasswordRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkMailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ResetPasswordRequest> {
        public Builder organizationId(String var1);

        public Builder userId(String var1);

        public Builder password(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

