/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workmail.model.PersonalAccessTokenScopeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PersonalAccessTokenSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PersonalAccessTokenSummary> {
    private static final SdkField<String> PERSONAL_ACCESS_TOKEN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PersonalAccessTokenId").getter(PersonalAccessTokenSummary.getter(PersonalAccessTokenSummary::personalAccessTokenId)).setter(PersonalAccessTokenSummary.setter(Builder::personalAccessTokenId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersonalAccessTokenId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(PersonalAccessTokenSummary.getter(PersonalAccessTokenSummary::userId)).setter(PersonalAccessTokenSummary.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(PersonalAccessTokenSummary.getter(PersonalAccessTokenSummary::name)).setter(PersonalAccessTokenSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Instant> DATE_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DateCreated").getter(PersonalAccessTokenSummary.getter(PersonalAccessTokenSummary::dateCreated)).setter(PersonalAccessTokenSummary.setter(Builder::dateCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateCreated").build()}).build();
    private static final SdkField<Instant> DATE_LAST_USED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DateLastUsed").getter(PersonalAccessTokenSummary.getter(PersonalAccessTokenSummary::dateLastUsed)).setter(PersonalAccessTokenSummary.setter(Builder::dateLastUsed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateLastUsed").build()}).build();
    private static final SdkField<Instant> EXPIRES_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpiresTime").getter(PersonalAccessTokenSummary.getter(PersonalAccessTokenSummary::expiresTime)).setter(PersonalAccessTokenSummary.setter(Builder::expiresTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiresTime").build()}).build();
    private static final SdkField<List<String>> SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Scopes").getter(PersonalAccessTokenSummary.getter(PersonalAccessTokenSummary::scopes)).setter(PersonalAccessTokenSummary.setter(Builder::scopes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scopes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERSONAL_ACCESS_TOKEN_ID_FIELD, USER_ID_FIELD, NAME_FIELD, DATE_CREATED_FIELD, DATE_LAST_USED_FIELD, EXPIRES_TIME_FIELD, SCOPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String personalAccessTokenId;
    private final String userId;
    private final String name;
    private final Instant dateCreated;
    private final Instant dateLastUsed;
    private final Instant expiresTime;
    private final List<String> scopes;

    private PersonalAccessTokenSummary(BuilderImpl builder) {
        this.personalAccessTokenId = builder.personalAccessTokenId;
        this.userId = builder.userId;
        this.name = builder.name;
        this.dateCreated = builder.dateCreated;
        this.dateLastUsed = builder.dateLastUsed;
        this.expiresTime = builder.expiresTime;
        this.scopes = builder.scopes;
    }

    public final String personalAccessTokenId() {
        return this.personalAccessTokenId;
    }

    public final String userId() {
        return this.userId;
    }

    public final String name() {
        return this.name;
    }

    public final Instant dateCreated() {
        return this.dateCreated;
    }

    public final Instant dateLastUsed() {
        return this.dateLastUsed;
    }

    public final Instant expiresTime() {
        return this.expiresTime;
    }

    public final boolean hasScopes() {
        return this.scopes != null && !(this.scopes instanceof SdkAutoConstructList);
    }

    public final List<String> scopes() {
        return this.scopes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.personalAccessTokenId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateLastUsed());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScopes() ? this.scopes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PersonalAccessTokenSummary)) {
            return false;
        }
        PersonalAccessTokenSummary other = (PersonalAccessTokenSummary)obj;
        return Objects.equals(this.personalAccessTokenId(), other.personalAccessTokenId()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.dateCreated(), other.dateCreated()) && Objects.equals(this.dateLastUsed(), other.dateLastUsed()) && Objects.equals(this.expiresTime(), other.expiresTime()) && this.hasScopes() == other.hasScopes() && Objects.equals(this.scopes(), other.scopes());
    }

    public final String toString() {
        return ToString.builder((String)"PersonalAccessTokenSummary").add("PersonalAccessTokenId", (Object)this.personalAccessTokenId()).add("UserId", (Object)this.userId()).add("Name", (Object)this.name()).add("DateCreated", (Object)this.dateCreated()).add("DateLastUsed", (Object)this.dateLastUsed()).add("ExpiresTime", (Object)this.expiresTime()).add("Scopes", this.hasScopes() ? this.scopes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PersonalAccessTokenId": {
                return Optional.ofNullable(clazz.cast(this.personalAccessTokenId()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DateCreated": {
                return Optional.ofNullable(clazz.cast(this.dateCreated()));
            }
            case "DateLastUsed": {
                return Optional.ofNullable(clazz.cast(this.dateLastUsed()));
            }
            case "ExpiresTime": {
                return Optional.ofNullable(clazz.cast(this.expiresTime()));
            }
            case "Scopes": {
                return Optional.ofNullable(clazz.cast(this.scopes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PersonalAccessTokenSummary, T> g) {
        return obj -> g.apply((PersonalAccessTokenSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String personalAccessTokenId;
        private String userId;
        private String name;
        private Instant dateCreated;
        private Instant dateLastUsed;
        private Instant expiresTime;
        private List<String> scopes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PersonalAccessTokenSummary model) {
            this.personalAccessTokenId(model.personalAccessTokenId);
            this.userId(model.userId);
            this.name(model.name);
            this.dateCreated(model.dateCreated);
            this.dateLastUsed(model.dateLastUsed);
            this.expiresTime(model.expiresTime);
            this.scopes(model.scopes);
        }

        public final String getPersonalAccessTokenId() {
            return this.personalAccessTokenId;
        }

        public final void setPersonalAccessTokenId(String personalAccessTokenId) {
            this.personalAccessTokenId = personalAccessTokenId;
        }

        @Override
        public final Builder personalAccessTokenId(String personalAccessTokenId) {
            this.personalAccessTokenId = personalAccessTokenId;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getDateCreated() {
            return this.dateCreated;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final Instant getDateLastUsed() {
            return this.dateLastUsed;
        }

        public final void setDateLastUsed(Instant dateLastUsed) {
            this.dateLastUsed = dateLastUsed;
        }

        @Override
        public final Builder dateLastUsed(Instant dateLastUsed) {
            this.dateLastUsed = dateLastUsed;
            return this;
        }

        public final Instant getExpiresTime() {
            return this.expiresTime;
        }

        public final void setExpiresTime(Instant expiresTime) {
            this.expiresTime = expiresTime;
        }

        @Override
        public final Builder expiresTime(Instant expiresTime) {
            this.expiresTime = expiresTime;
            return this;
        }

        public final Collection<String> getScopes() {
            if (this.scopes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scopes;
        }

        public final void setScopes(Collection<String> scopes) {
            this.scopes = PersonalAccessTokenScopeListCopier.copy(scopes);
        }

        @Override
        public final Builder scopes(Collection<String> scopes) {
            this.scopes = PersonalAccessTokenScopeListCopier.copy(scopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(String ... scopes) {
            this.scopes(Arrays.asList(scopes));
            return this;
        }

        public PersonalAccessTokenSummary build() {
            return new PersonalAccessTokenSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PersonalAccessTokenSummary> {
        public Builder personalAccessTokenId(String var1);

        public Builder userId(String var1);

        public Builder name(String var1);

        public Builder dateCreated(Instant var1);

        public Builder dateLastUsed(Instant var1);

        public Builder expiresTime(Instant var1);

        public Builder scopes(Collection<String> var1);

        public Builder scopes(String ... var1);
    }
}

