/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workmail.model.ImpersonationRoleType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImpersonationRole
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImpersonationRole> {
    private static final SdkField<String> IMPERSONATION_ROLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImpersonationRoleId").getter(ImpersonationRole.getter(ImpersonationRole::impersonationRoleId)).setter(ImpersonationRole.setter(Builder::impersonationRoleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImpersonationRoleId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ImpersonationRole.getter(ImpersonationRole::name)).setter(ImpersonationRole.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ImpersonationRole.getter(ImpersonationRole::typeAsString)).setter(ImpersonationRole.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Instant> DATE_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DateCreated").getter(ImpersonationRole.getter(ImpersonationRole::dateCreated)).setter(ImpersonationRole.setter(Builder::dateCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateCreated").build()}).build();
    private static final SdkField<Instant> DATE_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DateModified").getter(ImpersonationRole.getter(ImpersonationRole::dateModified)).setter(ImpersonationRole.setter(Builder::dateModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateModified").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPERSONATION_ROLE_ID_FIELD, NAME_FIELD, TYPE_FIELD, DATE_CREATED_FIELD, DATE_MODIFIED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImpersonationRole.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String impersonationRoleId;
    private final String name;
    private final String type;
    private final Instant dateCreated;
    private final Instant dateModified;

    private ImpersonationRole(BuilderImpl builder) {
        this.impersonationRoleId = builder.impersonationRoleId;
        this.name = builder.name;
        this.type = builder.type;
        this.dateCreated = builder.dateCreated;
        this.dateModified = builder.dateModified;
    }

    public final String impersonationRoleId() {
        return this.impersonationRoleId;
    }

    public final String name() {
        return this.name;
    }

    public final ImpersonationRoleType type() {
        return ImpersonationRoleType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Instant dateCreated() {
        return this.dateCreated;
    }

    public final Instant dateModified() {
        return this.dateModified;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.impersonationRoleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateModified());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImpersonationRole)) {
            return false;
        }
        ImpersonationRole other = (ImpersonationRole)obj;
        return Objects.equals(this.impersonationRoleId(), other.impersonationRoleId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.dateCreated(), other.dateCreated()) && Objects.equals(this.dateModified(), other.dateModified());
    }

    public final String toString() {
        return ToString.builder((String)"ImpersonationRole").add("ImpersonationRoleId", (Object)this.impersonationRoleId()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("DateCreated", (Object)this.dateCreated()).add("DateModified", (Object)this.dateModified()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImpersonationRoleId": {
                return Optional.ofNullable(clazz.cast(this.impersonationRoleId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "DateCreated": {
                return Optional.ofNullable(clazz.cast(this.dateCreated()));
            }
            case "DateModified": {
                return Optional.ofNullable(clazz.cast(this.dateModified()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ImpersonationRoleId", IMPERSONATION_ROLE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("DateCreated", DATE_CREATED_FIELD);
        map.put("DateModified", DATE_MODIFIED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImpersonationRole, T> g) {
        return obj -> g.apply((ImpersonationRole)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String impersonationRoleId;
        private String name;
        private String type;
        private Instant dateCreated;
        private Instant dateModified;

        private BuilderImpl() {
        }

        private BuilderImpl(ImpersonationRole model) {
            this.impersonationRoleId(model.impersonationRoleId);
            this.name(model.name);
            this.type(model.type);
            this.dateCreated(model.dateCreated);
            this.dateModified(model.dateModified);
        }

        public final String getImpersonationRoleId() {
            return this.impersonationRoleId;
        }

        public final void setImpersonationRoleId(String impersonationRoleId) {
            this.impersonationRoleId = impersonationRoleId;
        }

        @Override
        public final Builder impersonationRoleId(String impersonationRoleId) {
            this.impersonationRoleId = impersonationRoleId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ImpersonationRoleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getDateCreated() {
            return this.dateCreated;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final Instant getDateModified() {
            return this.dateModified;
        }

        public final void setDateModified(Instant dateModified) {
            this.dateModified = dateModified;
        }

        @Override
        public final Builder dateModified(Instant dateModified) {
            this.dateModified = dateModified;
            return this;
        }

        public ImpersonationRole build() {
            return new ImpersonationRole(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImpersonationRole> {
        public Builder impersonationRoleId(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(ImpersonationRoleType var1);

        public Builder dateCreated(Instant var1);

        public Builder dateModified(Instant var1);
    }
}

