/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workmail.model.WorkMailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteOrganizationRequest
extends WorkMailRequest
implements ToCopyableBuilder<Builder, DeleteOrganizationRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(DeleteOrganizationRequest.getter(DeleteOrganizationRequest::clientToken)).setter(DeleteOrganizationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationId").getter(DeleteOrganizationRequest.getter(DeleteOrganizationRequest::organizationId)).setter(DeleteOrganizationRequest.setter(Builder::organizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()}).build();
    private static final SdkField<Boolean> DELETE_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteDirectory").getter(DeleteOrganizationRequest.getter(DeleteOrganizationRequest::deleteDirectory)).setter(DeleteOrganizationRequest.setter(Builder::deleteDirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteDirectory").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, ORGANIZATION_ID_FIELD, DELETE_DIRECTORY_FIELD));
    private final String clientToken;
    private final String organizationId;
    private final Boolean deleteDirectory;

    private DeleteOrganizationRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.organizationId = builder.organizationId;
        this.deleteDirectory = builder.deleteDirectory;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String organizationId() {
        return this.organizationId;
    }

    public final Boolean deleteDirectory() {
        return this.deleteDirectory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteDirectory());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteOrganizationRequest)) {
            return false;
        }
        DeleteOrganizationRequest other = (DeleteOrganizationRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.organizationId(), other.organizationId()) && Objects.equals(this.deleteDirectory(), other.deleteDirectory());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteOrganizationRequest").add("ClientToken", (Object)this.clientToken()).add("OrganizationId", (Object)this.organizationId()).add("DeleteDirectory", (Object)this.deleteDirectory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "OrganizationId": {
                return Optional.ofNullable(clazz.cast(this.organizationId()));
            }
            case "DeleteDirectory": {
                return Optional.ofNullable(clazz.cast(this.deleteDirectory()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteOrganizationRequest, T> g) {
        return obj -> g.apply((DeleteOrganizationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String organizationId;
        private Boolean deleteDirectory;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteOrganizationRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.organizationId(model.organizationId);
            this.deleteDirectory(model.deleteDirectory);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final Boolean getDeleteDirectory() {
            return this.deleteDirectory;
        }

        public final void setDeleteDirectory(Boolean deleteDirectory) {
            this.deleteDirectory = deleteDirectory;
        }

        @Override
        public final Builder deleteDirectory(Boolean deleteDirectory) {
            this.deleteDirectory = deleteDirectory;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteOrganizationRequest build() {
            return new DeleteOrganizationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkMailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteOrganizationRequest> {
        public Builder clientToken(String var1);

        public Builder organizationId(String var1);

        public Builder deleteDirectory(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

