/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The representation of an organization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<OrganizationSummary.Builder, OrganizationSummary> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationId").getter(getter(OrganizationSummary::organizationId))
            .setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Alias")
            .getter(getter(OrganizationSummary::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()).build();

    private static final SdkField<String> DEFAULT_MAIL_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultMailDomain").getter(getter(OrganizationSummary::defaultMailDomain))
            .setter(setter(Builder::defaultMailDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultMailDomain").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(OrganizationSummary::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(OrganizationSummary::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD,
            ALIAS_FIELD, DEFAULT_MAIL_DOMAIN_FIELD, ERROR_MESSAGE_FIELD, STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String organizationId;

    private final String alias;

    private final String defaultMailDomain;

    private final String errorMessage;

    private final String state;

    private OrganizationSummary(BuilderImpl builder) {
        this.organizationId = builder.organizationId;
        this.alias = builder.alias;
        this.defaultMailDomain = builder.defaultMailDomain;
        this.errorMessage = builder.errorMessage;
        this.state = builder.state;
    }

    /**
     * <p>
     * The identifier associated with the organization.
     * </p>
     * 
     * @return The identifier associated with the organization.
     */
    public final String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * The alias associated with the organization.
     * </p>
     * 
     * @return The alias associated with the organization.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * The default email domain associated with the organization.
     * </p>
     * 
     * @return The default email domain associated with the organization.
     */
    public final String defaultMailDomain() {
        return defaultMailDomain;
    }

    /**
     * <p>
     * The error message associated with the organization. It is only present if unexpected behavior has occurred with
     * regards to the organization. It provides insight or solutions regarding unexpected behavior.
     * </p>
     * 
     * @return The error message associated with the organization. It is only present if unexpected behavior has
     *         occurred with regards to the organization. It provides insight or solutions regarding unexpected
     *         behavior.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The state associated with the organization.
     * </p>
     * 
     * @return The state associated with the organization.
     */
    public final String state() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(defaultMailDomain());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationSummary)) {
            return false;
        }
        OrganizationSummary other = (OrganizationSummary) obj;
        return Objects.equals(organizationId(), other.organizationId()) && Objects.equals(alias(), other.alias())
                && Objects.equals(defaultMailDomain(), other.defaultMailDomain())
                && Objects.equals(errorMessage(), other.errorMessage()) && Objects.equals(state(), other.state());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrganizationSummary").add("OrganizationId", organizationId()).add("Alias", alias())
                .add("DefaultMailDomain", defaultMailDomain()).add("ErrorMessage", errorMessage()).add("State", state()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "Alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "DefaultMailDomain":
            return Optional.ofNullable(clazz.cast(defaultMailDomain()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationSummary, T> g) {
        return obj -> g.apply((OrganizationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationSummary> {
        /**
         * <p>
         * The identifier associated with the organization.
         * </p>
         * 
         * @param organizationId
         *        The identifier associated with the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * The alias associated with the organization.
         * </p>
         * 
         * @param alias
         *        The alias associated with the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * The default email domain associated with the organization.
         * </p>
         * 
         * @param defaultMailDomain
         *        The default email domain associated with the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultMailDomain(String defaultMailDomain);

        /**
         * <p>
         * The error message associated with the organization. It is only present if unexpected behavior has occurred
         * with regards to the organization. It provides insight or solutions regarding unexpected behavior.
         * </p>
         * 
         * @param errorMessage
         *        The error message associated with the organization. It is only present if unexpected behavior has
         *        occurred with regards to the organization. It provides insight or solutions regarding unexpected
         *        behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The state associated with the organization.
         * </p>
         * 
         * @param state
         *        The state associated with the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);
    }

    static final class BuilderImpl implements Builder {
        private String organizationId;

        private String alias;

        private String defaultMailDomain;

        private String errorMessage;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationSummary model) {
            organizationId(model.organizationId);
            alias(model.alias);
            defaultMailDomain(model.defaultMailDomain);
            errorMessage(model.errorMessage);
            state(model.state);
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public final String getAlias() {
            return alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        public final String getDefaultMailDomain() {
            return defaultMailDomain;
        }

        @Override
        public final Builder defaultMailDomain(String defaultMailDomain) {
            this.defaultMailDomain = defaultMailDomain;
            return this;
        }

        public final void setDefaultMailDomain(String defaultMailDomain) {
            this.defaultMailDomain = defaultMailDomain;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public OrganizationSummary build() {
            return new OrganizationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
