/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.worklink.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the fleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FleetSummary implements SdkPojo, Serializable, ToCopyableBuilder<FleetSummary.Builder, FleetSummary> {
    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetArn").getter(getter(FleetSummary::fleetArn)).setter(setter(Builder::fleetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(FleetSummary::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(FleetSummary::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<String> FLEET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetName").getter(getter(FleetSummary::fleetName)).setter(setter(Builder::fleetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetName").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(FleetSummary::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> COMPANY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompanyCode").getter(getter(FleetSummary::companyCode)).setter(setter(Builder::companyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompanyCode").build()).build();

    private static final SdkField<String> FLEET_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetStatus").getter(getter(FleetSummary::fleetStatusAsString)).setter(setter(Builder::fleetStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetStatus").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(FleetSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ARN_FIELD,
            CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, FLEET_NAME_FIELD, DISPLAY_NAME_FIELD, COMPANY_CODE_FIELD,
            FLEET_STATUS_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fleetArn;

    private final Instant createdTime;

    private final Instant lastUpdatedTime;

    private final String fleetName;

    private final String displayName;

    private final String companyCode;

    private final String fleetStatus;

    private final Map<String, String> tags;

    private FleetSummary(BuilderImpl builder) {
        this.fleetArn = builder.fleetArn;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.fleetName = builder.fleetName;
        this.displayName = builder.displayName;
        this.companyCode = builder.companyCode;
        this.fleetStatus = builder.fleetStatus;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the fleet.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the fleet.
     */
    public final String fleetArn() {
        return fleetArn;
    }

    /**
     * <p>
     * The time when the fleet was created.
     * </p>
     * 
     * @return The time when the fleet was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The time when the fleet was last updated.
     * </p>
     * 
     * @return The time when the fleet was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The name of the fleet.
     * </p>
     * 
     * @return The name of the fleet.
     */
    public final String fleetName() {
        return fleetName;
    }

    /**
     * <p>
     * The name of the fleet to display.
     * </p>
     * 
     * @return The name of the fleet to display.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The identifier used by users to sign into the Amazon WorkLink app.
     * </p>
     * 
     * @return The identifier used by users to sign into the Amazon WorkLink app.
     */
    public final String companyCode() {
        return companyCode;
    }

    /**
     * <p>
     * The status of the fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fleetStatus} will
     * return {@link FleetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fleetStatusAsString}.
     * </p>
     * 
     * @return The status of the fleet.
     * @see FleetStatus
     */
    public final FleetStatus fleetStatus() {
        return FleetStatus.fromValue(fleetStatus);
    }

    /**
     * <p>
     * The status of the fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fleetStatus} will
     * return {@link FleetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fleetStatusAsString}.
     * </p>
     * 
     * @return The status of the fleet.
     * @see FleetStatus
     */
    public final String fleetStatusAsString() {
        return fleetStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags attached to the resource. A tag is a key-value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags attached to the resource. A tag is a key-value pair.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(fleetName());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(companyCode());
        hashCode = 31 * hashCode + Objects.hashCode(fleetStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetSummary)) {
            return false;
        }
        FleetSummary other = (FleetSummary) obj;
        return Objects.equals(fleetArn(), other.fleetArn()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(fleetName(), other.fleetName())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(companyCode(), other.companyCode())
                && Objects.equals(fleetStatusAsString(), other.fleetStatusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FleetSummary").add("FleetArn", fleetArn()).add("CreatedTime", createdTime())
                .add("LastUpdatedTime", lastUpdatedTime()).add("FleetName", fleetName()).add("DisplayName", displayName())
                .add("CompanyCode", companyCode()).add("FleetStatus", fleetStatusAsString())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetArn":
            return Optional.ofNullable(clazz.cast(fleetArn()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "FleetName":
            return Optional.ofNullable(clazz.cast(fleetName()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "CompanyCode":
            return Optional.ofNullable(clazz.cast(companyCode()));
        case "FleetStatus":
            return Optional.ofNullable(clazz.cast(fleetStatusAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FleetSummary, T> g) {
        return obj -> g.apply((FleetSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FleetSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the fleet.
         * </p>
         * 
         * @param fleetArn
         *        The Amazon Resource Name (ARN) of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetArn(String fleetArn);

        /**
         * <p>
         * The time when the fleet was created.
         * </p>
         * 
         * @param createdTime
         *        The time when the fleet was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The time when the fleet was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time when the fleet was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The name of the fleet.
         * </p>
         * 
         * @param fleetName
         *        The name of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetName(String fleetName);

        /**
         * <p>
         * The name of the fleet to display.
         * </p>
         * 
         * @param displayName
         *        The name of the fleet to display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The identifier used by users to sign into the Amazon WorkLink app.
         * </p>
         * 
         * @param companyCode
         *        The identifier used by users to sign into the Amazon WorkLink app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder companyCode(String companyCode);

        /**
         * <p>
         * The status of the fleet.
         * </p>
         * 
         * @param fleetStatus
         *        The status of the fleet.
         * @see FleetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetStatus
         */
        Builder fleetStatus(String fleetStatus);

        /**
         * <p>
         * The status of the fleet.
         * </p>
         * 
         * @param fleetStatus
         *        The status of the fleet.
         * @see FleetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetStatus
         */
        Builder fleetStatus(FleetStatus fleetStatus);

        /**
         * <p>
         * The tags attached to the resource. A tag is a key-value pair.
         * </p>
         * 
         * @param tags
         *        The tags attached to the resource. A tag is a key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String fleetArn;

        private Instant createdTime;

        private Instant lastUpdatedTime;

        private String fleetName;

        private String displayName;

        private String companyCode;

        private String fleetStatus;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FleetSummary model) {
            fleetArn(model.fleetArn);
            createdTime(model.createdTime);
            lastUpdatedTime(model.lastUpdatedTime);
            fleetName(model.fleetName);
            displayName(model.displayName);
            companyCode(model.companyCode);
            fleetStatus(model.fleetStatus);
            tags(model.tags);
        }

        public final String getFleetArn() {
            return fleetArn;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getFleetName() {
            return fleetName;
        }

        public final void setFleetName(String fleetName) {
            this.fleetName = fleetName;
        }

        @Override
        public final Builder fleetName(String fleetName) {
            this.fleetName = fleetName;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getCompanyCode() {
            return companyCode;
        }

        public final void setCompanyCode(String companyCode) {
            this.companyCode = companyCode;
        }

        @Override
        public final Builder companyCode(String companyCode) {
            this.companyCode = companyCode;
            return this;
        }

        public final String getFleetStatus() {
            return fleetStatus;
        }

        public final void setFleetStatus(String fleetStatus) {
            this.fleetStatus = fleetStatus;
        }

        @Override
        public final Builder fleetStatus(String fleetStatus) {
            this.fleetStatus = fleetStatus;
            return this;
        }

        @Override
        public final Builder fleetStatus(FleetStatus fleetStatus) {
            this.fleetStatus(fleetStatus == null ? null : fleetStatus.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public FleetSummary build() {
            return new FleetSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
