/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.worklink.model.IdentityProviderType;
import software.amazon.awssdk.services.worklink.model.WorkLinkResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIdentityProviderConfigurationResponse
extends WorkLinkResponse
implements ToCopyableBuilder<Builder, DescribeIdentityProviderConfigurationResponse> {
    private static final SdkField<String> IDENTITY_PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeIdentityProviderConfigurationResponse.getter(DescribeIdentityProviderConfigurationResponse::identityProviderTypeAsString)).setter(DescribeIdentityProviderConfigurationResponse.setter(Builder::identityProviderType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderType").build()}).build();
    private static final SdkField<String> SERVICE_PROVIDER_SAML_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeIdentityProviderConfigurationResponse.getter(DescribeIdentityProviderConfigurationResponse::serviceProviderSamlMetadata)).setter(DescribeIdentityProviderConfigurationResponse.setter(Builder::serviceProviderSamlMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceProviderSamlMetadata").build()}).build();
    private static final SdkField<String> IDENTITY_PROVIDER_SAML_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeIdentityProviderConfigurationResponse.getter(DescribeIdentityProviderConfigurationResponse::identityProviderSamlMetadata)).setter(DescribeIdentityProviderConfigurationResponse.setter(Builder::identityProviderSamlMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderSamlMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_PROVIDER_TYPE_FIELD, SERVICE_PROVIDER_SAML_METADATA_FIELD, IDENTITY_PROVIDER_SAML_METADATA_FIELD));
    private final String identityProviderType;
    private final String serviceProviderSamlMetadata;
    private final String identityProviderSamlMetadata;

    private DescribeIdentityProviderConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.identityProviderType = builder.identityProviderType;
        this.serviceProviderSamlMetadata = builder.serviceProviderSamlMetadata;
        this.identityProviderSamlMetadata = builder.identityProviderSamlMetadata;
    }

    public IdentityProviderType identityProviderType() {
        return IdentityProviderType.fromValue(this.identityProviderType);
    }

    public String identityProviderTypeAsString() {
        return this.identityProviderType;
    }

    public String serviceProviderSamlMetadata() {
        return this.serviceProviderSamlMetadata;
    }

    public String identityProviderSamlMetadata() {
        return this.identityProviderSamlMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceProviderSamlMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderSamlMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIdentityProviderConfigurationResponse)) {
            return false;
        }
        DescribeIdentityProviderConfigurationResponse other = (DescribeIdentityProviderConfigurationResponse)((Object)obj);
        return Objects.equals(this.identityProviderTypeAsString(), other.identityProviderTypeAsString()) && Objects.equals(this.serviceProviderSamlMetadata(), other.serviceProviderSamlMetadata()) && Objects.equals(this.identityProviderSamlMetadata(), other.identityProviderSamlMetadata());
    }

    public String toString() {
        return ToString.builder((String)"DescribeIdentityProviderConfigurationResponse").add("IdentityProviderType", (Object)this.identityProviderTypeAsString()).add("ServiceProviderSamlMetadata", (Object)this.serviceProviderSamlMetadata()).add("IdentityProviderSamlMetadata", (Object)this.identityProviderSamlMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityProviderType": {
                return Optional.ofNullable(clazz.cast(this.identityProviderTypeAsString()));
            }
            case "ServiceProviderSamlMetadata": {
                return Optional.ofNullable(clazz.cast(this.serviceProviderSamlMetadata()));
            }
            case "IdentityProviderSamlMetadata": {
                return Optional.ofNullable(clazz.cast(this.identityProviderSamlMetadata()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIdentityProviderConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeIdentityProviderConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkLinkResponse.BuilderImpl
    implements Builder {
        private String identityProviderType;
        private String serviceProviderSamlMetadata;
        private String identityProviderSamlMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIdentityProviderConfigurationResponse model) {
            super(model);
            this.identityProviderType(model.identityProviderType);
            this.serviceProviderSamlMetadata(model.serviceProviderSamlMetadata);
            this.identityProviderSamlMetadata(model.identityProviderSamlMetadata);
        }

        public final String getIdentityProviderType() {
            return this.identityProviderType;
        }

        @Override
        public final Builder identityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
            return this;
        }

        @Override
        public final Builder identityProviderType(IdentityProviderType identityProviderType) {
            this.identityProviderType(identityProviderType == null ? null : identityProviderType.toString());
            return this;
        }

        public final void setIdentityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
        }

        public final String getServiceProviderSamlMetadata() {
            return this.serviceProviderSamlMetadata;
        }

        @Override
        public final Builder serviceProviderSamlMetadata(String serviceProviderSamlMetadata) {
            this.serviceProviderSamlMetadata = serviceProviderSamlMetadata;
            return this;
        }

        public final void setServiceProviderSamlMetadata(String serviceProviderSamlMetadata) {
            this.serviceProviderSamlMetadata = serviceProviderSamlMetadata;
        }

        public final String getIdentityProviderSamlMetadata() {
            return this.identityProviderSamlMetadata;
        }

        @Override
        public final Builder identityProviderSamlMetadata(String identityProviderSamlMetadata) {
            this.identityProviderSamlMetadata = identityProviderSamlMetadata;
            return this;
        }

        public final void setIdentityProviderSamlMetadata(String identityProviderSamlMetadata) {
            this.identityProviderSamlMetadata = identityProviderSamlMetadata;
        }

        @Override
        public DescribeIdentityProviderConfigurationResponse build() {
            return new DescribeIdentityProviderConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkLinkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeIdentityProviderConfigurationResponse> {
        public Builder identityProviderType(String var1);

        public Builder identityProviderType(IdentityProviderType var1);

        public Builder serviceProviderSamlMetadata(String var1);

        public Builder identityProviderSamlMetadata(String var1);
    }
}

