/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.worklink.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWebsiteCertificateAuthoritiesResponse extends WorkLinkResponse implements
        ToCopyableBuilder<ListWebsiteCertificateAuthoritiesResponse.Builder, ListWebsiteCertificateAuthoritiesResponse> {
    private static final SdkField<List<WebsiteCaSummary>> WEBSITE_CERTIFICATE_AUTHORITIES_FIELD = SdkField
            .<List<WebsiteCaSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListWebsiteCertificateAuthoritiesResponse::websiteCertificateAuthorities))
            .setter(setter(Builder::websiteCertificateAuthorities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebsiteCertificateAuthorities")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WebsiteCaSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(WebsiteCaSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListWebsiteCertificateAuthoritiesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            WEBSITE_CERTIFICATE_AUTHORITIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<WebsiteCaSummary> websiteCertificateAuthorities;

    private final String nextToken;

    private ListWebsiteCertificateAuthoritiesResponse(BuilderImpl builder) {
        super(builder);
        this.websiteCertificateAuthorities = builder.websiteCertificateAuthorities;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the WebsiteCertificateAuthorities property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasWebsiteCertificateAuthorities() {
        return websiteCertificateAuthorities != null && !(websiteCertificateAuthorities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the certificates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWebsiteCertificateAuthorities()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the certificates.
     */
    public List<WebsiteCaSummary> websiteCertificateAuthorities() {
        return websiteCertificateAuthorities;
    }

    /**
     * <p>
     * The pagination token used to retrieve the next page of results for this operation. If there are no more pages,
     * this value is null.
     * </p>
     * 
     * @return The pagination token used to retrieve the next page of results for this operation. If there are no more
     *         pages, this value is null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(websiteCertificateAuthorities());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWebsiteCertificateAuthoritiesResponse)) {
            return false;
        }
        ListWebsiteCertificateAuthoritiesResponse other = (ListWebsiteCertificateAuthoritiesResponse) obj;
        return Objects.equals(websiteCertificateAuthorities(), other.websiteCertificateAuthorities())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListWebsiteCertificateAuthoritiesResponse")
                .add("WebsiteCertificateAuthorities", websiteCertificateAuthorities()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebsiteCertificateAuthorities":
            return Optional.ofNullable(clazz.cast(websiteCertificateAuthorities()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWebsiteCertificateAuthoritiesResponse, T> g) {
        return obj -> g.apply((ListWebsiteCertificateAuthoritiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkLinkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListWebsiteCertificateAuthoritiesResponse> {
        /**
         * <p>
         * Information about the certificates.
         * </p>
         * 
         * @param websiteCertificateAuthorities
         *        Information about the certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder websiteCertificateAuthorities(Collection<WebsiteCaSummary> websiteCertificateAuthorities);

        /**
         * <p>
         * Information about the certificates.
         * </p>
         * 
         * @param websiteCertificateAuthorities
         *        Information about the certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder websiteCertificateAuthorities(WebsiteCaSummary... websiteCertificateAuthorities);

        /**
         * <p>
         * Information about the certificates.
         * </p>
         * This is a convenience that creates an instance of the {@link List<WebsiteCaSummary>.Builder} avoiding the
         * need to create one manually via {@link List<WebsiteCaSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<WebsiteCaSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #websiteCertificateAuthorities(List<WebsiteCaSummary>)}.
         * 
         * @param websiteCertificateAuthorities
         *        a consumer that will call methods on {@link List<WebsiteCaSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #websiteCertificateAuthorities(List<WebsiteCaSummary>)
         */
        Builder websiteCertificateAuthorities(Consumer<WebsiteCaSummary.Builder>... websiteCertificateAuthorities);

        /**
         * <p>
         * The pagination token used to retrieve the next page of results for this operation. If there are no more
         * pages, this value is null.
         * </p>
         * 
         * @param nextToken
         *        The pagination token used to retrieve the next page of results for this operation. If there are no
         *        more pages, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends WorkLinkResponse.BuilderImpl implements Builder {
        private List<WebsiteCaSummary> websiteCertificateAuthorities = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWebsiteCertificateAuthoritiesResponse model) {
            super(model);
            websiteCertificateAuthorities(model.websiteCertificateAuthorities);
            nextToken(model.nextToken);
        }

        public final Collection<WebsiteCaSummary.Builder> getWebsiteCertificateAuthorities() {
            return websiteCertificateAuthorities != null ? websiteCertificateAuthorities.stream()
                    .map(WebsiteCaSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder websiteCertificateAuthorities(Collection<WebsiteCaSummary> websiteCertificateAuthorities) {
            this.websiteCertificateAuthorities = WebsiteCaSummaryListCopier.copy(websiteCertificateAuthorities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder websiteCertificateAuthorities(WebsiteCaSummary... websiteCertificateAuthorities) {
            websiteCertificateAuthorities(Arrays.asList(websiteCertificateAuthorities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder websiteCertificateAuthorities(Consumer<WebsiteCaSummary.Builder>... websiteCertificateAuthorities) {
            websiteCertificateAuthorities(Stream.of(websiteCertificateAuthorities)
                    .map(c -> WebsiteCaSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWebsiteCertificateAuthorities(Collection<WebsiteCaSummary.BuilderImpl> websiteCertificateAuthorities) {
            this.websiteCertificateAuthorities = WebsiteCaSummaryListCopier.copyFromBuilder(websiteCertificateAuthorities);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListWebsiteCertificateAuthoritiesResponse build() {
            return new ListWebsiteCertificateAuthoritiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
